/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midlet;

import com.sun.midp.content.AppMonitor;
import com.sun.midp.lcdui.DisplayAccess;
import com.sun.midp.lcdui.DisplayManager;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import com.sun.mmedia.BasicPlayer;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public abstract class MIDletState {
    static final int PAUSED = 0;
    static final int ACTIVE = 1;
    static final int PAUSED_RESUME = 2;
    static final int ACTIVE_PENDING = 3;
    static final int PAUSE_PENDING = 4;
    static final int DESTROY_PENDING = 5;
    static final int DESTROYED = 6;
    private static SecurityToken classSecurityToken;
    private static Object createMIDletLock;
    private static boolean allowedToCreateMIDlet;
    private static boolean skipPauseApp;
    private int state;
    private Object mutex;
    private Scheduler scheduler;
    protected MIDlet midlet;
    protected Display display;
    protected DisplayManager displayManager;
    private static final String MEDIA_TYPE = "media";
    private static final com.sun.mmedia.MIDletPauseListener mediaListener;
    PauseTracker pauseTracker = new PauseTracker();

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MIDlet createMIDlet(String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object object = createMIDletLock;
        synchronized (object) {
            try {
                AppMonitor.midletInit(Scheduler.getScheduler().getMIDletSuite().getStorageName(), classname);
                allowedToCreateMIDlet = true;
                Class<?> midletClass = Class.forName(classname);
                Object midlet = midletClass.newInstance();
                if (midlet instanceof MIDlet) {
                    MIDlet mIDlet = (MIDlet)midlet;
                    return mIDlet;
                }
                throw new InstantiationException("Class not a MIDlet");
            }
            finally {
                allowedToCreateMIDlet = false;
            }
        }
    }

    private static native void warnAboutPauseActivity0(String var0, String var1);

    void notifyMIDletPaused(boolean paused) {
        this.pauseTracker.notifyMIDletPaused(paused);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MIDletState(MIDlet m) {
        this.midlet = m;
        this.state = 2;
        this.scheduler = Scheduler.getScheduler();
        this.mutex = this.scheduler.getMutex();
        Object object = createMIDletLock;
        synchronized (object) {
            MIDletSuite suite;
            if (!allowedToCreateMIDlet && (suite = this.scheduler.getMIDletSuite()) != null) {
                suite.checkIfPermissionAllowed(1);
            }
        }
        this.displayManager = DisplayManagerFactory.getDisplayManager();
        DisplayAccess accessor = this.displayManager.createDisplay(classSecurityToken, this.midlet);
        this.display = accessor.getDisplay();
        if (this.scheduler.getMIDletSuite().isTrusted()) {
            accessor.setTrustedIcon(classSecurityToken, true);
        }
        BasicPlayer.setMIDletPauseListener(mediaListener);
    }

    public MIDlet getMIDlet() {
        return this.midlet;
    }

    public Display getDisplay() {
        return this.display;
    }

    protected abstract void startApp() throws MIDletStateChangeException;

    protected abstract void pauseApp();

    protected abstract void destroyApp(boolean var1) throws MIDletStateChangeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void notifyDestroyed() {
        Object object = this.mutex;
        synchronized (object) {
            this.state = 6;
            this.mutex.notify();
        }
    }

    public final void notifyPaused() {
        skipPauseApp = true;
        MIDletState.notifyPaused0(true);
        this.notifyMIDletPaused(true);
    }

    private static native void notifyPaused0(boolean var0);

    public final void notifyResumed() {
        MIDletState.notifyPaused0(false);
    }

    public final MIDletSuite getMIDletSuite() {
        return this.scheduler.getMIDletSuite();
    }

    public final void resumeRequest() {
        this.setState(2);
    }

    public final native boolean platformRequest(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(int newState) {
        Object object = this.mutex;
        synchronized (object) {
            this.setStateWithoutNotify(newState);
            this.mutex.notify();
        }
    }

    public int checkPermission(String permission) {
        return this.getMIDletSuite().checkPermission(permission);
    }

    void setStateWithoutNotify(int newState) {
        if (skipPauseApp) {
            if (newState == 4) {
                newState = 0;
            } else if (newState == 1) {
                skipPauseApp = false;
            }
        }
        switch (this.state) {
            case 6: {
                return;
            }
            case 5: {
                if (newState == 6) break;
                return;
            }
            case 0: {
                if (newState == 4) {
                    return;
                }
                if (newState != 5) break;
                this.notifyResumed();
                break;
            }
            case 1: {
                if (newState != 2 && newState != 3) break;
                return;
            }
        }
        this.state = newState;
        if (this.state == 1) {
            this.notifyMIDletPaused(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getState() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state;
        }
    }

    static {
        createMIDletLock = new Object();
        skipPauseApp = false;
        mediaListener = new MediaListener();
    }

    class PauseTracker {
        PauseTracker() {
        }

        void notifyMIDletPaused(boolean paused) {
            if (!MIDletState.this.midlet.getClass().getName().startsWith("com.sun.midp.dev.")) {
                try {
                    BasicPlayer.pauseStateEntered(mediaListener, paused);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static class MediaListener
    implements com.sun.mmedia.MIDletPauseListener {
        private MediaListener() {
        }

        public void reportActivity(String mediaType) {
            MIDletState.warnAboutPauseActivity0(MIDletState.MEDIA_TYPE, mediaType);
        }
    }

    public static interface MIDletPauseListener {
        public void reportActivity(String var1);
    }
}

