/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.main;

import com.sun.midp.main.CommandState;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.midletsuite.InvalidJadException;
import java.io.IOException;

public class CommandProcessor {
    static final int MAIN_EXIT = 2001;
    static final int OK = 0;
    static final int ERROR = -1;
    static final int MIDLET_SUITE_NOT_FOUND = -2;
    static final int EXIT = 1;
    static final int MANAGE = 2;
    static final int INSTALL = 3;
    static final int INSTALL_RUN = 4;
    static final int RUN = 5;
    static final int REMOVE = 6;
    static final int LIST = 7;
    static final int RUN_CLASS = 8;
    static final int STORAGE_NAMES = 9;
    private static boolean performing = false;
    private static Installer installer = null;

    public static void perform(CommandState state) throws IOException, InvalidJadException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (performing) {
            return;
        }
        performing = true;
        if (installer == null) {
            installer = Installer.getInstaller();
        }
        CommandProcessor.dispatch(state);
        String nextMidletSuiteToRun = installer.getNextMIDletSuiteToRun();
        if (nextMidletSuiteToRun != null) {
            state.nextCommand = 5;
            state.suiteStorageName = nextMidletSuiteToRun;
            state.midletName = installer.getNextMIDletToRun();
        }
        performing = false;
    }

    private static void dispatch(CommandState state) throws IOException, InvalidJadException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int currentCommand = state.nextCommand;
        state.nextCommand = 1;
        if (currentCommand == 3 || currentCommand == 4) {
            CommandProcessor.install(state);
        } else if (currentCommand == 5) {
            if (state.initialCommand == 2) {
                state.nextCommand = 2;
            }
            CommandProcessor.run(state);
        } else if (currentCommand == 6) {
            CommandProcessor.remove(state);
        }
    }

    private static void install(CommandState state) throws IOException, InvalidJadException {
        try {
            state.status = -1;
            if (state.securityDomain != null) {
                installer.setUnsignedSecurityDomain(state.securityDomain);
            }
            state.suiteStorageName = installer.installJad(state.suiteURL, state.forceOverwrite, state.removeRMS, null);
            state.status = 0;
            if (state.initialCommand == 4) {
                state.nextCommand = 5;
            }
            return;
        }
        catch (InvalidJadException ije) {
            String mediaType;
            if (ije.getReason() == 43) {
                state.status = -2;
                throw new IllegalArgumentException("The JAD URL is not valid");
            }
            if (ije.getReason() == 1 || ije.getReason() == 2) {
                state.status = -2;
                if (state.autotest && state.suiteStorageName != null) {
                    state.nextCommand = 6;
                }
                return;
            }
            if (ije.getReason() == 37 && ("application/java".equals(mediaType = ije.getExtraData()) || "application/java-archive".equals(mediaType))) {
                state.suiteStorageName = installer.installJar(state.suiteURL, state.forceOverwrite, state.removeRMS, null);
                state.status = 0;
                if (state.initialCommand == 4) {
                    state.nextCommand = 5;
                }
                return;
            }
            throw ije;
        }
        catch (IllegalArgumentException iae) {
            state.status = -2;
            throw iae;
        }
        finally {
            if (state.status == -1 && state.autotest) {
                state.nextCommand = 3;
            }
        }
    }

    private static void run(CommandState state) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        MIDletSuite midletSuite;
        state.status = -1;
        if (state.suiteStorageName == null) {
            throw new IllegalArgumentException("The storage name for the MIDlet suite was not given");
        }
        if (state.midletName != null || state.midletNumber == null) {
            String temp = state.midletName;
            state.midletName = null;
            midletSuite = installer.getMIDletSuite(state.suiteStorageName, temp);
        } else {
            int midletNumber;
            try {
                midletNumber = Integer.parseInt(state.midletNumber);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("The value for MIDlet number was not formatted properly");
            }
            midletSuite = installer.getMIDletSuite(state.suiteStorageName, midletNumber);
        }
        if (midletSuite == null) {
            state.status = -2;
            return;
        }
        if (state.runOnce) {
            state.nextCommand = 6;
        } else if (state.autotest) {
            state.nextCommand = 3;
        }
        if (!Scheduler.getScheduler().schedule(midletSuite)) {
            state.nextCommand = 1;
        }
        state.status = 0;
    }

    private static void remove(CommandState state) {
        state.status = -1;
        if (state.suiteStorageName == null) {
            throw new IllegalArgumentException("No suite specified");
        }
        if (state.suiteStorageName.equals("all")) {
            String[] suite = installer.list();
            for (int i = 0; i < suite.length; ++i) {
                installer.remove(suite[i]);
            }
        } else {
            installer.remove(state.suiteStorageName);
        }
        state.status = 0;
    }

    private CommandProcessor() {
    }
}

