/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.lcdui;

public class DynamicCharacterArray {
    protected char[] buffer;
    protected int length;

    public DynamicCharacterArray(int capacity) {
        this(null, capacity);
    }

    public DynamicCharacterArray(String str) {
        this(str.toCharArray());
    }

    public DynamicCharacterArray(char[] data) {
        this(data, data.length);
    }

    public DynamicCharacterArray(char[] data, int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (data != null) {
            if (data.length > capacity) {
                throw new IllegalArgumentException();
            }
            this.length = data.length;
            this.buffer = new char[capacity];
            System.arraycopy(data, 0, this.buffer, 0, this.length);
        } else {
            this.buffer = new char[capacity];
        }
    }

    public int insert(char[] data, int offset, int length, int position) {
        if (position < 0) {
            position = 0;
        } else if (position > this.length) {
            position = this.length;
        }
        if (offset < 0 || offset > data.length || length < 0 || length > data.length || offset + length < 0 || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.length + length > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        if (data.length != 0) {
            System.arraycopy(this.buffer, position, this.buffer, position + length, this.length - position);
            System.arraycopy(data, offset, this.buffer, position, length);
            this.length += length;
        }
        return position;
    }

    public int insert(int position, char ch) {
        char[] arr = new char[]{ch};
        return this.insert(arr, 0, 1, position);
    }

    public int insert(int position, String str) {
        return this.insert(str.toCharArray(), 0, str.length(), position);
    }

    public void append(char c) {
        this.insert(this.length, c);
    }

    public void set(char[] data, int offset, int length) {
        if (data == null) {
            this.length = 0;
            return;
        }
        if (offset < 0 || offset > data.length || length < 0 || length > data.length || offset + length < 0 || offset + length > data.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (length > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(data, offset, this.buffer, 0, length);
        this.length = length;
    }

    public void get(char[] data) {
        this.getChars(0, this.buffer.length, data, 0);
    }

    public void getChars(int position, int length, char[] data, int offset) {
        System.arraycopy(this.buffer, position, data, offset, length);
    }

    public char[] toCharArray() {
        char[] buf = new char[this.length];
        System.arraycopy(this.buffer, 0, buf, 0, buf.length);
        return buf;
    }

    public void delete(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length < 0 || offset + length > this.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (offset + length < this.length) {
            System.arraycopy(this.buffer, offset + length, this.buffer, offset, this.length - (offset + length));
        }
        this.length -= length;
    }

    public void setCapacity(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.buffer.length == capacity) {
            return;
        }
        if (this.length > capacity) {
            this.length = capacity;
        }
        char[] newBuffer = new char[capacity];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
        this.buffer = newBuffer;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int length() {
        return this.length;
    }

    public char charAt(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer[index] = ch;
    }

    public String toString() {
        return String.valueOf(this.buffer, 0, this.length);
    }
}

