/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.lcdui;

import com.sun.midp.lcdui.DisplayManager;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.EventHandler;
import com.sun.midp.lcdui.Events;
import com.sun.mmedia.BasicPlayer;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;

public class DefaultEventHandler
implements EventHandler {
    private Thread eventThread;
    private VMEventHandler vmEventHandler;
    private QueuedEventHandler queuedEventHandler;
    private EventQueue eventQueue;
    private DisplayManager displayManager = DisplayManagerFactory.getDisplayManager();
    protected Object eventLock = new Object();
    private boolean inMenu;

    public native int getKeyCode(int var1);

    public native int getGameAction(int var1);

    public native int getSystemKey(int var1);

    public native String getKeyName(int var1);

    public native void updateCommandSet(Command[] var1, int var2, Command[] var3, int var4);

    public boolean isDispatchThread() {
        return Thread.currentThread() == this.eventThread;
    }

    public void clearSystemScreen() {
        this.inMenu = false;
        this.dismissMenu();
    }

    public void scheduleScreenChange(Display parent, Displayable d) {
        this.eventQueue.push(parent, d);
    }

    public void scheduleRepaint(int x, int y, int w, int h, Object target) {
        this.eventQueue.push(x, y, w, h, target);
    }

    public void scheduleCallSerially() {
        this.eventQueue.push();
    }

    public void scheduleInvalidate(Item src) {
        this.eventQueue.push(src, true);
    }

    public void scheduleItemStateChanged(Item src) {
        this.eventQueue.push(src, false);
    }

    public void serviceRepaints() {
        try {
            this.eventQueue.serviceRepaints();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public DefaultEventHandler() {
        try {
            this.queuedEventHandler = new QueuedEventHandler();
            this.eventThread = new Thread(this.queuedEventHandler);
            this.eventThread.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.vmEventHandler = new VMEventHandler();
            new Thread(this.vmEventHandler).start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void keyEvent(int type, String str, int code) {
        block14: {
            try {
                if (type == 5) {
                    Object object = this.eventLock;
                    synchronized (object) {
                        this.displayManager.inputMethodEvent(str);
                        break block14;
                    }
                }
                if (this.getSystemKey(code) == 3 && type == 2) {
                    Object object = this.eventLock;
                    synchronized (object) {
                        this.displayManager.killCurrent();
                        break block14;
                    }
                }
                if (this.inMenu) {
                    this.inMenu = this.menuKeyEvent(type, code);
                    break block14;
                }
                Object object = this.eventLock;
                synchronized (object) {
                    this.displayManager.keyEvent(type, code);
                }
            }
            catch (Throwable t) {
                DefaultEventHandler.handleThrowable(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pointerEvent(int type, int x, int y) {
        block6: {
            try {
                if (this.inMenu) {
                    this.inMenu = this.menuPointerEvent(type, x, y);
                    break block6;
                }
                Object object = this.eventLock;
                synchronized (object) {
                    this.displayManager.pointerEvent(type, x, y);
                }
            }
            catch (Throwable t) {
                DefaultEventHandler.handleThrowable(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commandEvent(int type) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                if (type == -1) {
                    this.displayManager.suspendPainting();
                    this.paintMenu();
                    this.inMenu = true;
                } else {
                    if (this.inMenu) {
                        this.displayManager.resumePainting();
                    }
                    this.inMenu = false;
                    if (type >= 0) {
                        this.displayManager.commandAction(type);
                    }
                }
            }
        }
        catch (Throwable t) {
            DefaultEventHandler.handleThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemEvent(int type) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                switch (type) {
                    case 1: {
                        this.displayManager.suspendAll();
                        this.incomingCall();
                        break;
                    }
                    case 2: {
                        this.displayManager.resumeAll();
                        break;
                    }
                    case 3: {
                        this.displayManager.shutdown();
                    }
                    case 4: {
                        this.displayManager.suspendCurrent();
                        break;
                    }
                    case 5: {
                        this.displayManager.resumePrevious();
                        break;
                    }
                    case 6: {
                        this.displayManager.killCurrent();
                        break;
                    }
                }
            }
        }
        catch (Throwable t) {
            DefaultEventHandler.handleThrowable(t);
        }
    }

    void multiMediaEvent(int playerID, int curMTime) {
        try {
            BasicPlayer p = BasicPlayer.get(playerID);
            if (p != null) {
                p.sendEvent("endOfMedia", new Long(curMTime));
            }
        }
        catch (Throwable t) {
            DefaultEventHandler.handleThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void screenChangeEvent(Display parent, Displayable d) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                this.displayManager.screenChange(parent, d);
            }
        }
        catch (Throwable t) {
            DefaultEventHandler.handleThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaintScreenEvent(int x1, int y1, int x2, int y2, Object target) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                this.displayManager.repaint(x1, y1, x2, y2, target);
            }
        }
        catch (Throwable t) {
            DefaultEventHandler.handleThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callSeriallyEvent() {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                this.displayManager.callSerially();
            }
        }
        catch (Throwable t) {
            DefaultEventHandler.handleThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateEvent(Item src) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                this.displayManager.callInvalidate(src);
            }
        }
        catch (Throwable t) {
            DefaultEventHandler.handleThrowable(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void itemStateChangedEvent(Item src) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                this.displayManager.callItemStateChanged(src);
            }
        }
        catch (Throwable t) {
            DefaultEventHandler.handleThrowable(t);
        }
    }

    void unknownVMEvent(int event, Events queue) {
        System.err.println("Unknown VM Event: " + event);
    }

    static void handleThrowable(Throwable t) {
        if (t != null) {
            System.err.println("\nError occurred while dispatching event:");
            t.printStackTrace();
        }
    }

    native void paintMenu();

    native void dismissMenu();

    native boolean menuKeyEvent(int var1, int var2);

    native boolean menuPointerEvent(int var1, int var2, int var3);

    native void incomingCall();

    class EventQueue {
        int vmEvent;
        Display parentOfNextScreen;
        Displayable nextScreen;
        boolean callSeriallyPending;
        boolean invalidatePending;
        Item invalidItem;
        Item changedItem;
        int paintX1 = -1;
        int paintY1 = -1;
        int paintX2 = -1;
        int paintY2 = -1;
        Object paintTarget;
        Object qLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRepaints() {
            Object target;
            int y2;
            int x2;
            int y1;
            int x1;
            Object object = this.qLock;
            synchronized (object) {
                if (this.paintX1 == -1) {
                    return;
                }
                x1 = this.paintX1;
                y1 = this.paintY1;
                x2 = this.paintX2;
                y2 = this.paintY2;
                target = this.paintTarget;
                this.paintY2 = -1;
                this.paintX2 = -1;
                this.paintY1 = -1;
                this.paintX1 = -1;
                this.paintTarget = null;
            }
            DefaultEventHandler.this.repaintScreenEvent(x1, y1, x2, y2, target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(int vmEvent) {
            Object object = this.qLock;
            synchronized (object) {
                this.vmEvent = vmEvent;
            }
            DefaultEventHandler.this.queuedEventHandler.process();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push() {
            Object object = this.qLock;
            synchronized (object) {
                this.callSeriallyPending = true;
            }
            DefaultEventHandler.this.queuedEventHandler.process();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(Item src, boolean b) {
            Object object = this.qLock;
            synchronized (object) {
                if (b) {
                    this.invalidatePending = true;
                    this.invalidItem = src;
                } else {
                    this.changedItem = src;
                }
            }
            DefaultEventHandler.this.queuedEventHandler.process();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(Display parent, Displayable d) {
            Object object = this.qLock;
            synchronized (object) {
                this.parentOfNextScreen = parent;
                this.nextScreen = d;
            }
            DefaultEventHandler.this.queuedEventHandler.process();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(int x, int y, int w, int h, Object target) {
            try {
                w += x;
                h += y;
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                Object object = this.qLock;
                synchronized (object) {
                    if (this.paintX1 == -1) {
                        this.paintX1 = x;
                        this.paintY1 = y;
                        this.paintX2 = w;
                        this.paintY2 = h;
                        this.paintTarget = target;
                    } else {
                        if (this.paintX1 > x) {
                            this.paintX1 = x;
                        }
                        if (this.paintY1 > y) {
                            this.paintY1 = y;
                        }
                        if (this.paintX2 < w) {
                            this.paintX2 = w;
                        }
                        if (this.paintY2 < h) {
                            this.paintY2 = h;
                        }
                        this.paintTarget = null;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            DefaultEventHandler.this.queuedEventHandler.process();
        }
    }

    class QueuedEventHandler
    implements Runnable {
        public QueuedEventHandler() {
            DefaultEventHandler.this.eventQueue = new EventQueue();
        }

        public synchronized void process() {
            try {
                this.notify();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public synchronized void tryToSleep() {
            if (((DefaultEventHandler)DefaultEventHandler.this).eventQueue.nextScreen == null && ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintX1 == -1 && !((DefaultEventHandler)DefaultEventHandler.this).eventQueue.callSeriallyPending && !((DefaultEventHandler)DefaultEventHandler.this).eventQueue.invalidatePending && ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.changedItem == null && ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.vmEvent == 0) {
                try {
                    this.wait();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int type = 0;
            Display parentOfNextScreen = null;
            Displayable nextScreen = null;
            boolean call = false;
            boolean validate = false;
            Item validateItem = null;
            Item changedItem = null;
            int y2 = -1;
            int x2 = -1;
            int y1 = -1;
            int x1 = -1;
            Object target = null;
            while (true) {
                try {
                    while (true) {
                        this.tryToSleep();
                        if (((DefaultEventHandler)DefaultEventHandler.this).eventQueue.vmEvent != 0) {
                            switch (((DefaultEventHandler)DefaultEventHandler.this).eventQueue.vmEvent) {
                                case 1: {
                                    type = ((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readInt();
                                    if (type == 5) {
                                        DefaultEventHandler.this.keyEvent(type, ((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readUTF(), 0);
                                        break;
                                    }
                                    DefaultEventHandler.this.keyEvent(type, null, ((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readInt());
                                    break;
                                }
                                case 2: {
                                    DefaultEventHandler.this.pointerEvent(((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readInt(), ((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readInt(), ((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readInt());
                                    break;
                                }
                                case 3: {
                                    DefaultEventHandler.this.commandEvent(((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readInt());
                                    break;
                                }
                                case 4: {
                                    DefaultEventHandler.this.systemEvent(((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readInt());
                                    break;
                                }
                                case 8: {
                                    DefaultEventHandler.this.multiMediaEvent(((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readInt(), ((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue.readInt());
                                    break;
                                }
                                default: {
                                    DefaultEventHandler.this.unknownVMEvent(((DefaultEventHandler)DefaultEventHandler.this).eventQueue.vmEvent, ((DefaultEventHandler)DefaultEventHandler.this).vmEventHandler.queue);
                                }
                            }
                            ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.vmEvent = 0;
                            DefaultEventHandler.this.vmEventHandler.proceed();
                        }
                        Object object = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.qLock;
                        synchronized (object) {
                            if (((DefaultEventHandler)DefaultEventHandler.this).eventQueue.nextScreen != null) {
                                parentOfNextScreen = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.parentOfNextScreen;
                                nextScreen = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.nextScreen;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.nextScreen = null;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintY2 = -1;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintX2 = -1;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintY1 = -1;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintX1 = -1;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintTarget = null;
                            } else if (((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintX1 != -1) {
                                x1 = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintX1;
                                x2 = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintX2;
                                y1 = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintY1;
                                y2 = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintY2;
                                target = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintTarget;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintY2 = -1;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintX2 = -1;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintY1 = -1;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintX1 = -1;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.paintTarget = null;
                            }
                            if (((DefaultEventHandler)DefaultEventHandler.this).eventQueue.callSeriallyPending) {
                                call = true;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.callSeriallyPending = false;
                            }
                            if (((DefaultEventHandler)DefaultEventHandler.this).eventQueue.invalidatePending) {
                                validate = true;
                                validateItem = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.invalidItem;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.invalidItem = null;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.invalidatePending = false;
                            }
                            if (((DefaultEventHandler)DefaultEventHandler.this).eventQueue.changedItem != null) {
                                changedItem = ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.changedItem;
                                ((DefaultEventHandler)DefaultEventHandler.this).eventQueue.changedItem = null;
                            }
                        }
                        if (nextScreen != null) {
                            DefaultEventHandler.this.screenChangeEvent(parentOfNextScreen, nextScreen);
                            parentOfNextScreen = null;
                            nextScreen = null;
                        }
                        if (x1 != -1) {
                            DefaultEventHandler.this.repaintScreenEvent(x1, y1, x2, y2, target);
                            y2 = -1;
                            x2 = -1;
                            y1 = -1;
                            x1 = -1;
                            target = null;
                        }
                        if (call) {
                            DefaultEventHandler.this.callSeriallyEvent();
                            call = false;
                        }
                        if (validate) {
                            DefaultEventHandler.this.validateEvent(validateItem);
                            validateItem = null;
                            validate = false;
                        }
                        if (changedItem == null) continue;
                        DefaultEventHandler.this.itemStateChangedEvent(changedItem);
                        changedItem = null;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class VMEventHandler
    implements Runnable {
        Events queue;

        VMEventHandler() {
        }

        public synchronized void proceed() {
            try {
                this.notify();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public synchronized void run() {
            try {
                this.queue = new Events();
                this.queue.open();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            block6: while (true) {
                try {
                    while (true) {
                        DefaultEventHandler.this.eventQueue.push(this.queue.readInt());
                        try {
                            this.wait();
                            continue block6;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

