/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.lcdui;

import com.sun.midp.lcdui.AutomationHandler;
import com.sun.midp.lcdui.DefaultEventHandler;
import com.sun.midp.lcdui.EventSequence;
import com.sun.midp.lcdui.RecordedEvent;
import com.sun.midp.lcdui.ScreenGrabber;
import com.sun.midp.lcdui.SequenceHandler;

public class AutomatedEventHandler
extends DefaultEventHandler
implements AutomationHandler {
    static AutomationHandler thisReference;
    EventSequence eventSequence;
    SequenceHandler sequenceHandler;
    int hotKey_StartRecording = 0;
    int hotKey_StopRecording = 0;
    int hotKey_CaptureScreen = 0;
    boolean lastScreenCaptureComparisonTrue;
    boolean recordingInProgress;
    long millis;

    public AutomatedEventHandler() {
        thisReference = this;
    }

    public void startEventSequence() {
        this.initializeEventSequence();
        this.recordingInProgress = true;
        this.millis = System.currentTimeMillis();
    }

    public EventSequence stopEventSequence() {
        if (!this.recordingInProgress) {
            this.initializeEventSequence();
        }
        int time = (int)(System.currentTimeMillis() - this.millis);
        RecordedEvent event = new RecordedEvent(time);
        this.eventSequence.appendEvent(event);
        this.recordingInProgress = false;
        byte[] s_cap = ScreenGrabber.getInstance().getData();
        this.eventSequence.setScreenCapture(s_cap);
        return this.eventSequence;
    }

    public void registerSequenceHandler(SequenceHandler handler) throws IllegalArgumentException {
        this.sequenceHandler = handler;
    }

    public void registerHotKey(int action, int keyCode) throws IllegalArgumentException {
        switch (action) {
            case 0: {
                this.hotKey_StartRecording = keyCode;
                break;
            }
            case 1: {
                this.hotKey_StopRecording = keyCode;
                break;
            }
            case 2: {
                this.hotKey_CaptureScreen = keyCode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replayEventSequence(EventSequence sequence) {
        sequence.initializeReplay();
        EventPlaybackThread eventPlaybackThread = new EventPlaybackThread(sequence, 100);
        eventPlaybackThread.start();
        AutomationHandler automationHandler = thisReference;
        synchronized (automationHandler) {
            try {
                thisReference.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.lastScreenCaptureComparisonTrue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replayEventSequence(EventSequence sequence, int speed) {
        sequence.initializeReplay();
        EventPlaybackThread eventPlaybackThread = new EventPlaybackThread(sequence, speed);
        eventPlaybackThread.start();
        AutomationHandler automationHandler = thisReference;
        synchronized (automationHandler) {
            try {
                thisReference.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.lastScreenCaptureComparisonTrue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSequence updateScreenForSequence(EventSequence sequence) {
        sequence.initializeReplay();
        EventUpdaterThread eventUpdaterThread = new EventUpdaterThread(sequence);
        eventUpdaterThread.start();
        AutomationHandler automationHandler = thisReference;
        synchronized (automationHandler) {
            try {
                thisReference.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return eventUpdaterThread.getUpdatedEventSequence();
    }

    public byte[] captureScreen() {
        byte[] x = ScreenGrabber.getInstance().getData();
        return x;
    }

    public static AutomationHandler getAutomationHandler() {
        return thisReference;
    }

    void keyEvent(int type, String str, int code) {
        if (type == 1 && (code == this.hotKey_StartRecording || code == this.hotKey_StopRecording || code == this.hotKey_CaptureScreen)) {
            if (code == this.hotKey_StartRecording) {
                this.startEventSequence();
            }
            if (code == this.hotKey_StopRecording) {
                this.stopEventSequence();
                if (this.sequenceHandler != null) {
                    this.sequenceHandler.handleEventSequence(this.eventSequence);
                }
            }
            if (code == this.hotKey_CaptureScreen) {
                byte[] s_cap = this.captureScreen();
                if (this.sequenceHandler != null) {
                    this.sequenceHandler.handleScreenCapture(s_cap);
                }
            }
        } else if (this.recordingInProgress) {
            if (type == 5) {
                int time = (int)(System.currentTimeMillis() - this.millis);
                RecordedEvent event = new RecordedEvent(time, str);
                this.eventSequence.appendEvent(event);
                this.millis = System.currentTimeMillis();
            } else {
                int time = (int)(System.currentTimeMillis() - this.millis);
                RecordedEvent event = new RecordedEvent(time, type, code);
                this.eventSequence.appendEvent(event);
                this.millis = System.currentTimeMillis();
            }
        }
        super.keyEvent(type, str, code);
    }

    void pointerEvent(int type, int x, int y) {
        if (this.recordingInProgress) {
            int time = (int)(System.currentTimeMillis() - this.millis);
            RecordedEvent event = new RecordedEvent(time, type, x, y);
            this.eventSequence.appendEvent(event);
            this.millis = System.currentTimeMillis();
        }
        super.pointerEvent(type, x, y);
    }

    void commandEvent(int type) {
        if (this.recordingInProgress) {
            int time = (int)(System.currentTimeMillis() - this.millis);
            RecordedEvent event = new RecordedEvent(time, type);
            this.eventSequence.appendEvent(event);
            this.millis = System.currentTimeMillis();
        }
        super.commandEvent(type);
    }

    private void initializeEventSequence() {
        this.eventSequence = new EventSequence();
    }

    private static boolean byteMatch(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    class EventUpdaterThread
    extends EventPlaybackThread {
        EventSequence updatedSequence = new EventSequence();

        public EventUpdaterThread(EventSequence s) {
            super(s, 100);
        }

        public EventSequence getUpdatedEventSequence() {
            return this.updatedSequence;
        }

        protected void handleEvent(RecordedEvent event) {
            this.updatedSequence.appendEvent(event);
            super.handleEvent(event);
        }

        protected boolean handleCapture(byte[] dummy) {
            byte[] new_s_cap = ScreenGrabber.getInstance().getData();
            this.updatedSequence.setScreenCapture(new_s_cap);
            return false;
        }
    }

    class EventPlaybackThread
    extends Thread {
        EventSequence sequence;
        int timeFactor;

        public EventPlaybackThread(EventSequence s, int tf) {
            this.sequence = s;
            this.timeFactor = tf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean playbackDone = false;
            block8: while (!playbackDone) {
                int nextObjectType = this.sequence.getNextObjectType();
                switch (nextObjectType) {
                    case 0: {
                        this.handleEvent(this.sequence.getNextEvent());
                        continue block8;
                    }
                    case 1: {
                        playbackDone = this.handleCapture(this.sequence.getCapture());
                        continue block8;
                    }
                    case -1: {
                        playbackDone = true;
                        continue block8;
                    }
                }
                playbackDone = true;
            }
            AutomationHandler automationHandler = thisReference;
            synchronized (automationHandler) {
                thisReference.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleEvent(RecordedEvent event) {
            int t = event.getTimeDelay();
            EventPlaybackThread eventPlaybackThread = this;
            synchronized (eventPlaybackThread) {
                try {
                    EventPlaybackThread.sleep(t * this.timeFactor / 100);
                }
                catch (Exception e) {
                    System.out.println("Exception while sleep()-ing ");
                }
            }
            switch (event.getType()) {
                case 1: {
                    AutomatedEventHandler.this.keyEvent(event.val1, null, event.val2);
                    break;
                }
                case 2: {
                    AutomatedEventHandler.this.keyEvent(5, event.inputString, 0);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    AutomatedEventHandler.this.pointerEvent(event.val1, event.val2, event.val3);
                    break;
                }
                case 5: {
                    AutomatedEventHandler.this.commandEvent(event.val1);
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    System.out.println("unknown event type");
                }
            }
        }

        protected boolean handleCapture(byte[] stored_s_cap) {
            return this.matchScreenCaptures(stored_s_cap);
        }

        private boolean matchScreenCaptures(byte[] screenCapture) {
            byte[] this_s_cap = ScreenGrabber.getInstance().getData();
            if (AutomatedEventHandler.byteMatch(this_s_cap, screenCapture)) {
                AutomatedEventHandler.this.lastScreenCaptureComparisonTrue = true;
                return false;
            }
            AutomatedEventHandler.this.lastScreenCaptureComparisonTrue = false;
            return true;
        }
    }
}

