/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.btspp;

import com.sun.kvem.jsr082.bluetooth.SDDBImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BTNetmonNotifier;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import com.sun.midp.io.j2me.btspp.BTSPPConnection;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothConnectionException;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class BTSPPNotifier
extends BTNotifierBase
implements StreamConnectionNotifier,
BTNetmonNotifier {
    private static final boolean DEBUG = false;
    private static final String cn = "BTSPPNotifier";
    private Integer cid;
    public BTNetmonNotifier btNetmonNotifier = this;

    protected BTSPPNotifier(boolean isSystemUse) {
        this.isSystemUse = isSystemUse;
    }

    protected void initServerNotifier(JSR082Notifier notif, int mode, String name, boolean master, boolean authorize, boolean authenticate, boolean encrypt) throws IOException, BluetoothConnectionException {
        DataElement[] attrVals;
        int[] attrIDs;
        this.notif = notif;
        this.mode = mode;
        this.master = master;
        this.authorize = authorize;
        this.authenticate = authenticate;
        this.encrypt = encrypt;
        this.cid = IDAllocator.getID();
        this.control.registerBTSPPNotifier(this.cid, notif.getServerPort());
        DataElement serviceList = new DataElement(48);
        serviceList.addElement(new DataElement(24, (Object)this.serverUUID));
        serviceList.addElement(DE_SERIAL_PORT_UUID);
        DataElement protocolList = new DataElement(48);
        DataElement protocol = new DataElement(48);
        protocol.addElement(DE_L2CAP_UUID);
        protocolList.addElement(protocol);
        protocol = new DataElement(48);
        protocol.addElement(DE_RFCOMM_UUID);
        protocol.addElement(new DataElement(8, (long)this.cid.intValue()));
        protocolList.addElement(protocol);
        if (this.isSystemUse) {
            protocol = new DataElement(48);
            protocol.addElement(DE_OBEX_UUID);
            protocolList.addElement(protocol);
        }
        if (name == null) {
            attrIDs = new int[]{1, 4};
            attrVals = new DataElement[]{serviceList, protocolList};
        } else {
            DataElement nameDE = new DataElement(32, (Object)name);
            attrIDs = new int[]{1, 4, 256};
            attrVals = new DataElement[]{serviceList, protocolList, nameDE};
        }
        this.serRec = new ServiceRecordImpl(this, attrIDs, attrVals);
        this.protocolListMC = this.serRec.getAttributeValue(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamConnection acceptAndOpen() throws IOException {
        BTSPPConnection conn;
        if (this.isClosed) {
            throw new IOException("Notifier is closed");
        }
        if (!this.control.isDeviceConnectable()) {
            throw new BluetoothStateException("Device is not connectable");
        }
        Object object = this.serRecLock;
        synchronized (object) {
            try {
                if (this.serRec.getHandle() == -1) {
                    SDDBImpl sddb = SDDBImpl.getSDDBInstance();
                    this.serRec.setHandle(sddb.getFreeID());
                    this.updateServiceRecord();
                }
            }
            catch (IllegalArgumentException e) {
                throw new ServiceRegistrationException(e.getMessage());
            }
        }
        while (true) {
            JSR082Connection transport = null;
            try {
                transport = this.notif.acceptAndOpen();
            }
            catch (IOException e) {
                throw new IOException("Notifier is closed");
            }
            conn = this.createBTSPPConnection();
            try {
                conn.initServerConnection(transport, this, this.mode, this.master, this.authorize, this.authenticate, this.encrypt);
            }
            catch (IOException e) {
                try {
                    transport.close();
                }
                catch (IOException ioe) {}
                continue;
            }
            break;
        }
        return conn;
    }

    protected BTSPPConnection createBTSPPConnection() throws IOException {
        return new BTSPPConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        JSR082Notifier jSR082Notifier = this.notif;
        synchronized (jSR082Notifier) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        IDAllocator.freeID(this.cid);
        this.control.unregisterBTSPPNotifier(this.notif.getServerPort());
        SDDBImpl sddb = SDDBImpl.getSDDBInstance();
        sddb.removeServiceRecord(this.serRec);
        this.serRec.removeHandle();
        this.notif.close();
    }

    public ServiceRecord getServiceRecord() {
        if (this.isClosed) {
            throw new IllegalArgumentException("notifier is closed");
        }
        return this.serRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceRecord() {
        Object object = this.serRecLock;
        synchronized (object) {
            if (this.serRec.getHandle() == -1) {
                return;
            }
            ServiceRecordImpl rec = BTSPPNotifier.copyRecord(this, this.serRec);
            BTSPPNotifier.checkRecord(rec, this.protocolListMC);
            SDDBImpl sddb = SDDBImpl.getSDDBInstance();
            sddb.updateServiceRecord(rec);
            this.btNetmonNotifier.netmonUpdate(rec);
        }
    }

    public void netmonUpdate(ServiceRecord rec) {
    }

    private static class IDAllocator {
        private static Vector ids = new Vector(30);
        private static int busyCount;

        private IDAllocator() {
        }

        static synchronized Integer getID() throws IOException {
            if (busyCount == ids.size()) {
                throw new IOException("no free channels left");
            }
            return (Integer)ids.elementAt(busyCount++);
        }

        static synchronized void freeID(Integer id) {
            ids.removeElement(id);
            ids.addElement(id);
            --busyCount;
        }

        static {
            for (int i = 1; i <= 30; ++i) {
                ids.addElement(new Integer(i));
            }
        }
    }
}

