/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class ResourceInputStream
extends InputStream {
    private int handle = -1;
    protected int pos;
    protected int size;
    private String name;

    private String fixResourceName(String name) throws IOException {
        Vector<String> dirVector = new Vector<String>();
        int startIdx = 0;
        int endIdx = 0;
        while ((endIdx = name.indexOf(47, startIdx)) != -1) {
            if (endIdx == startIdx) {
                ++startIdx;
                continue;
            }
            String curDir = name.substring(startIdx, endIdx);
            startIdx = endIdx + 1;
            if (curDir.equals(".")) continue;
            if (curDir.equals("..")) {
                int size = dirVector.size();
                if (size > 0) {
                    dirVector.removeElementAt(size - 1);
                    continue;
                }
                throw new IOException();
            }
            dirVector.addElement(curDir);
        }
        int nameLength = name.length();
        StringBuffer dirName = new StringBuffer(nameLength);
        int numElements = dirVector.size();
        for (int i = 0; i < numElements; ++i) {
            dirName.append((String)dirVector.elementAt(i));
            dirName.append("/");
        }
        if (startIdx < nameLength) {
            String filename = name.substring(startIdx);
            if (filename.endsWith(".class") && !".class".equals(filename)) {
                throw new IOException();
            }
            dirName.append(name.substring(startIdx));
        }
        return dirName.toString();
    }

    public ResourceInputStream(String name) throws IOException {
        if (this.handle != -1) {
            throw new IOException();
        }
        String fixedName = this.fixResourceName(name);
        this.handle = this.open(fixedName.getBytes());
        this.pos = 0;
        this.name = name;
    }

    public int read() throws IOException {
        if (this.pos < this.size) {
            ++this.pos;
        } else {
            return -1;
        }
        return this.read(this.handle);
    }

    public int available() throws IOException {
        return this.size - this.pos;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.size) {
            return -1;
        }
        if (this.pos + len > this.size) {
            len = this.size - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        int result = this.readBytes(this.handle, b, off, this.pos, len);
        if (result > -1) {
            this.pos += result;
        }
        return result;
    }

    public synchronized void reset() {
        if (this.handle == -1) {
            return;
        }
        try {
            this.close(this.handle);
            String fixedName = this.fixResourceName(this.name);
            this.handle = this.open(fixedName.getBytes());
        }
        catch (Exception e) {
            System.err.println("ResourceInputStream.reset: cannot re-open");
        }
        this.pos = 0;
    }

    public void close() throws IOException {
        this.close(this.handle);
        this.handle = -1;
    }

    private native int open(byte[] var1) throws IOException;

    private native int read(int var1) throws IOException;

    private native int readBytes(int var1, byte[] var2, int var3, int var4, int var5) throws IOException;

    private native void close(int var1) throws IOException;

    private native void finalize();
}

