/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import com.sun.cldc.io.Waiter;
import com.sun.midp.io.ConnectionBaseAdapter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class BaseOutputStream
extends OutputStream {
    ConnectionBaseAdapter parent;
    byte[] buf = new byte[1];

    BaseOutputStream(ConnectionBaseAdapter p) {
        this.parent = p;
    }

    private void ensureOpen() throws InterruptedIOException {
        if (this.parent == null) {
            throw new InterruptedIOException("Stream closed");
        }
    }

    public void write(int b) throws IOException {
        this.buf[0] = (byte)b;
        this.write(this.buf, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (len == 0) {
            return;
        }
        int test = b[off] + b[len - 1] + b[off + len - 1];
        int bytesWritten = 0;
        while (true) {
            try {
                bytesWritten += this.parent.writeBytes(b, off + bytesWritten, len - bytesWritten);
            }
            finally {
                if (this.parent == null) {
                    throw new InterruptedIOException("Stream closed");
                }
            }
            if (bytesWritten == len) break;
            Waiter.waitForIO();
        }
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.parent.flush();
    }

    public void close() throws IOException {
        if (this.parent != null) {
            this.parent.closeOutputStream();
            this.parent = null;
        }
    }
}

