/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.dev;

import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.lcdui.Resource;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.InvalidJadException;
import com.sun.midp.midletsuite.JadProperties;
import com.sun.midp.midletsuite.MIDletSuiteImpl;
import com.sun.midp.security.Permissions;
import com.sun.midp.security.SecurityToken;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class DevMIDletSuiteImpl
extends MIDletSuiteImpl {
    private JadProperties bufferedJadProps = new JadProperties();
    private String initialMIDletClassName = null;
    private String storageRoot = null;
    private byte[] permissions;
    private int numberOfMidlets = -1;
    private String pushInterruptQuestion;
    private String alarmInterruptQuestion;

    public static MIDletSuite create(SecurityToken callerSecurityToken, String jadFilename, String midletClassName, String storageName, String domain) throws IOException, InvalidJadException {
        if (domain != null && !Permissions.isValidDomainName(callerSecurityToken, domain)) {
            System.out.println(Resource.getString("Incorrect domain name, switching to 'untrusted'"));
            domain = "untrusted";
        }
        return DevMIDletSuiteImpl.create(callerSecurityToken, jadFilename, midletClassName, storageName, null, null, domain, domain != null && !domain.equals("untrusted"), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MIDletSuite create(SecurityToken callerSecurityToken, String jadFilename, String midletClassName, String storageName, String[] keys, String[] values, String domain, boolean trusted, String pushQuestion, String alarmQuestion) throws IOException, InvalidJadException {
        byte[][] temp;
        if (domain == null) {
            domain = "untrusted";
        }
        if (!Permissions.isValidDomainName(callerSecurityToken, domain)) {
            System.out.println(Resource.getString("Incorrect domain name, switching to 'untrusted'"));
            domain = "untrusted";
        }
        int pushSetting = (temp = Permissions.forDomain(callerSecurityToken, domain))[1][10] == 0 ? 0 : (temp[1][10] == 1 ? 4 : temp[1][10]);
        temp[0][35] = 16;
        temp[1][35] = 16;
        DevMIDletSuiteImpl suite = new DevMIDletSuiteImpl(callerSecurityToken, temp, pushSetting, trusted, storageName);
        if (jadFilename != null) {
            DataInputStream dis = null;
            RandomAccessStream storage = new RandomAccessStream(callerSecurityToken);
            storage.connect(jadFilename, 1);
            try {
                int size = storage.getSizeOf();
                byte[] buffer = new byte[size];
                dis = storage.openDataInputStream();
                try {
                    dis.readFully(buffer);
                    ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                    suite.bufferedJadProps.load(is, null);
                    buffer = null;
                    is = null;
                }
                finally {
                    dis.close();
                }
            }
            finally {
                storage.disconnect();
            }
            suite.numberOfMidlets = suite.countMIDlets();
        } else {
            suite.numberOfMidlets = 1;
        }
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                suite.bufferedJadProps.setProperty(keys[i], values[i]);
            }
        }
        suite.storageRoot = File.getStorageRoot() + storageName;
        suite.initialMIDletClassName = midletClassName;
        suite.pushInterruptQuestion = pushQuestion != null ? pushQuestion : "Information is arriving for %1. Is it OK for %1 to startup and receive this information? The currently running application will exit.\n\nIs it OK to start up?";
        suite.alarmInterruptQuestion = alarmQuestion != null ? alarmQuestion : "Information is arriving for %1. Is it OK for %1 to startup and receive this information? The currently running application will exit.\n\nIs it OK to start up?";
        return suite;
    }

    private DevMIDletSuiteImpl(SecurityToken callerSecurityToken, byte[][] permissions, int pushSetting, boolean trusted, String storageName) {
        super(callerSecurityToken, permissions, pushSetting, trusted, storageName);
    }

    public String getProperty(String key) {
        return this.bufferedJadProps.getProperty(key);
    }

    public void addProperty(String key, String value) {
        MIDletSuite current = Scheduler.getScheduler().getMIDletSuite();
        if (current != null) {
            current.checkIfPermissionAllowed(0);
        }
        this.bufferedJadProps.addProperty(key, value);
    }

    public int getNumberOfMIDlets() {
        return this.numberOfMidlets;
    }

    public String getInitialMIDletClassname() {
        if (this.initialMIDletClassName != null) {
            return this.initialMIDletClassName;
        }
        return "com.sun.midp.dev.PersistentSelector";
    }

    public void checkForPermission(int permission, String resource) throws InterruptedException {
        this.checkForPermission(permission, resource, null);
    }

    public void checkForPermission(int permission, String resource, String extraValue) throws InterruptedException {
        String app = this.getProperty("MIDlet-Name");
        if (app == null) {
            app = this.initialMIDletClassName;
        }
        super.checkForPermission(permission, app, resource, extraValue);
    }

    public String getStorageRoot() {
        return this.storageRoot;
    }

    public byte[] getResource(String name) {
        return null;
    }

    public int getStorageUsed() {
        return 0;
    }

    public String getCA() {
        return null;
    }

    public void saveSettings() {
    }

    protected String getPushInterruptQuestion() {
        return this.pushInterruptQuestion;
    }

    protected String getAlarmInterruptQuestion() {
        return this.alarmInterruptQuestion;
    }

    protected String getSuiteNameForInterrupt() {
        String name = this.getProperty("MIDlet-Name");
        if (name != null) {
            return name;
        }
        return this.initialMIDletClassName;
    }

    public String getJadUrl() {
        return null;
    }

    public String getJarUrl() {
        return "none";
    }
}

