/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.content;

import com.sun.midp.content.AppProxy;
import com.sun.midp.content.ContentHandlerImpl;
import com.sun.midp.content.RegistryImpl;
import java.util.Vector;
import javax.microedition.content.ActionNameMap;
import javax.microedition.content.ContentHandlerException;

final class RegistryInstaller {
    private static final String CH_PREFIX = "MicroEdition-Handler-";
    private static final String CH_ID_SUFFIX = "-ID";
    private static final String CH_ACCESS_SUFFIX = "-Access";

    private RegistryInstaller() {
    }

    static Vector preInstall(AppProxy appl, Vector removeHandlers) throws ContentHandlerException, ClassNotFoundException {
        Vector newhandlers = RegistryInstaller.parseAttributes(appl);
        for (int i = 0; i < newhandlers.size(); ++i) {
            ContentHandlerImpl handler = (ContentHandlerImpl)newhandlers.elementAt(i);
            appl.checkRegisterPermission("register");
            RegistryImpl.checkConflicts(handler, null, true);
        }
        Vector currhandlers = RegistryImpl.forSuite(appl.getStorageID());
        for (int j = 0; j < currhandlers.size(); ++j) {
            ContentHandlerImpl handler = (ContentHandlerImpl)currhandlers.elementAt(j);
            if (handler.dynamic) {
                try {
                    ContentHandlerImpl existing = RegistryImpl.checkConflicts(handler, newhandlers, false);
                    if (existing == null) {
                        continue;
                    }
                }
                catch (ContentHandlerException che) {
                    // empty catch block
                }
            }
            removeHandlers.addElement(handler);
        }
        return newhandlers;
    }

    private static Vector parseAttributes(AppProxy appl) throws ContentHandlerException, ClassNotFoundException {
        String sindex;
        String handler_n;
        String value;
        Vector<ContentHandlerImpl> handlers = new Vector<ContentHandlerImpl>();
        int index = 1;
        while ((value = appl.getProperty(handler_n = CH_PREFIX.concat(sindex = Integer.toString(index)))) != null) {
            String classname;
            String[] types = null;
            String[] suffixes = null;
            String[] actions = null;
            String[] locales = null;
            String[] fields = RegistryInstaller.split(value, ',');
            switch (fields.length) {
                case 5: {
                    locales = RegistryInstaller.split(fields[4], ' ');
                }
                case 4: {
                    actions = RegistryInstaller.split(fields[3], ' ');
                }
                case 3: {
                    suffixes = RegistryInstaller.split(fields[2], ' ');
                }
                case 2: {
                    types = RegistryInstaller.split(fields[1], ' ');
                }
                case 1: {
                    classname = fields[0];
                    if (classname != null && classname.length() > 0) break;
                }
                default: {
                    throw new IllegalArgumentException("Too many or too few fields");
                }
            }
            AppProxy newAppl = appl.forClass(classname);
            ActionNameMap[] actionnames = RegistryInstaller.parseActionNames(actions, locales, handler_n, newAppl);
            String idAttr = handler_n.concat(CH_ID_SUFFIX);
            String id = newAppl.getProperty(idAttr);
            String visAttr = handler_n.concat(CH_ACCESS_SUFFIX);
            String visValue = newAppl.getProperty(visAttr);
            String[] accessRestricted = RegistryInstaller.split(visValue, ' ');
            if (id == null) {
                id = newAppl.getApplicationID();
            }
            ContentHandlerImpl handler = new ContentHandlerImpl(types, suffixes, actions, actionnames, id, accessRestricted);
            handler.classname = classname;
            handler.storageID = newAppl.getStorageID();
            handler.appname = newAppl.getApplicationName();
            handler.version = newAppl.getVersion();
            handler.authority = newAppl.getAuthority();
            if (RegistryImpl.checkConflicts(handler, handlers, false) != null) {
                throw new ContentHandlerException("ID would be ambiguous", 3);
            }
            handlers.addElement(handler);
            ++index;
        }
        return handlers;
    }

    private static ActionNameMap[] parseActionNames(String[] actions, String[] locales, String prefix, AppProxy appl) {
        if (locales == null || locales.length == 0) {
            return null;
        }
        prefix = prefix.concat("-");
        Vector<ActionNameMap> maps = new Vector<ActionNameMap>();
        for (int i = 0; i < locales.length; ++i) {
            String localeAttr = prefix.concat(locales[i]);
            String localeValue = appl.getProperty(localeAttr);
            if (localeValue == null) {
                throw new IllegalArgumentException("missing locale");
            }
            String[] actionnames = RegistryInstaller.split(localeValue, ',');
            ActionNameMap map = new ActionNameMap(actions, actionnames, locales[i]);
            maps.addElement(map);
        }
        if (maps.size() > 0) {
            Object[] result = new ActionNameMap[maps.size()];
            maps.copyInto(result);
            return result;
        }
        return null;
    }

    static String[] split(String string, char delim) {
        Object[] ret = ContentHandlerImpl.ZERO_STRINGS;
        if (string != null) {
            Vector values = RegistryInstaller.getDelimSeparatedValues(string, delim);
            ret = new String[values.size()];
            values.copyInto(ret);
        }
        return ret;
    }

    private static Vector getDelimSeparatedValues(String input, char delim) {
        Vector<String> output = new Vector<String>(5, 5);
        int len = (input = input.trim()).length();
        if (len == 0) {
            return output;
        }
        int end = 0;
        int start = 0;
        block0: while (end < len) {
            while (start < len && input.charAt(start) <= ' ') {
                ++start;
            }
            for (end = start; end < len; ++end) {
                char c = input.charAt(end);
                if (c != delim && (c != '\t' || delim != ' ')) continue;
                output.addElement(input.substring(start, end).trim());
                start = end + 1;
                continue block0;
            }
        }
        end = len;
        output.addElement(input.substring(start, end).trim());
        return output;
    }
}

