/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.content;

import com.sun.midp.content.AppProxy;
import com.sun.midp.content.InvocationImpl;
import com.sun.midp.content.InvocationStore;
import com.sun.midp.content.RequestListenerImpl;
import javax.microedition.content.ActionNameMap;
import javax.microedition.content.ContentHandler;
import javax.microedition.content.Invocation;
import javax.microedition.content.RequestListener;

public class ContentHandlerImpl
implements ContentHandler {
    String ID;
    String[] types;
    String[] suffixes;
    String[] actions;
    ActionNameMap[] actionnames;
    final int seqno = nextSeqno++;
    private static int nextSeqno;
    RequestListenerImpl listenerImpl;
    public static final String[] ZERO_STRINGS;
    private static final ActionNameMap[] ZERO_ACTIONNAMES;
    private static final String LOCALE_PROP = "microedition.locale";
    String storageID;
    String appname;
    String version;
    String classname;
    String authority;
    String[] accessRestricted;
    boolean dynamic;
    int requestCalls;
    boolean removed;

    ContentHandlerImpl(String[] types, String[] suffixes, String[] actions, ActionNameMap[] actionnames, String ID, String[] accessRestricted) {
        this();
        int i;
        int len;
        if (actionnames != null && actionnames.length > 0) {
            if (actions == null) {
                throw new IllegalArgumentException("no actions");
            }
            len = actions.length;
            for (i = 0; i < actionnames.length; ++i) {
                int j;
                ActionNameMap map = actionnames[i];
                if (len != map.size()) {
                    throw new IllegalArgumentException("actions not identical");
                }
                for (j = 0; j < len; ++j) {
                    if (actions[j].equals(map.getAction(j))) continue;
                    throw new IllegalArgumentException("actions not identical");
                }
                for (j = 0; j < i; ++j) {
                    if (!map.getLocale().equals(actionnames[j].getLocale())) continue;
                    throw new IllegalArgumentException("duplicate locale");
                }
            }
        }
        if (ID != null) {
            len = ID.length();
            if (len == 0) {
                throw new IllegalArgumentException("invalid ID");
            }
            for (i = 0; i < ID.length(); ++i) {
                if (ID.charAt(i) > ' ') continue;
                throw new IllegalArgumentException("invalid ID");
            }
            this.ID = ID;
        }
        this.types = ContentHandlerImpl.copy(types);
        this.suffixes = ContentHandlerImpl.copy(suffixes);
        this.actions = ContentHandlerImpl.copy(actions);
        this.actionnames = ContentHandlerImpl.copy(actionnames);
        this.accessRestricted = ContentHandlerImpl.copy(accessRestricted);
    }

    protected ContentHandlerImpl(ContentHandlerImpl handler) {
        this();
        this.types = handler.types;
        this.suffixes = handler.suffixes;
        this.ID = handler.ID;
        this.accessRestricted = handler.accessRestricted;
        this.actions = handler.actions;
        this.actionnames = handler.actionnames;
        this.listenerImpl = handler.listenerImpl;
        this.storageID = handler.storageID;
        this.classname = handler.classname;
        this.version = handler.version;
        this.dynamic = handler.dynamic;
        this.requestCalls = handler.requestCalls;
        this.authority = handler.authority;
        this.appname = handler.appname;
    }

    ContentHandlerImpl() {
    }

    public static String[] copy(String[] strings) {
        if (strings != null && strings.length > 0) {
            String[] copy = new String[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i].length() == 0) {
                    throw new IllegalArgumentException("string length is 0");
                }
                copy[i] = strings[i];
            }
            return strings;
        }
        return ZERO_STRINGS;
    }

    private static ActionNameMap[] copy(ActionNameMap[] actionnames) {
        if (actionnames != null && actionnames.length > 0) {
            ActionNameMap[] copy = new ActionNameMap[actionnames.length];
            for (int i = 0; i < actionnames.length; ++i) {
                if (actionnames[i] == null) {
                    throw new NullPointerException();
                }
                copy[i] = actionnames[i];
            }
            return copy;
        }
        return ZERO_ACTIONNAMES;
    }

    public static ContentHandler[] copy(ContentHandler[] handlers) {
        ContentHandler[] h = new ContentHandler[handlers.length];
        for (int i = 0; i < handlers.length; ++i) {
            h[i] = handlers[i];
        }
        return h;
    }

    public String getType(int index) {
        return this.get(index, this.types);
    }

    public int getTypeCount() {
        return this.types.length;
    }

    public boolean hasType(String type) {
        return this.has(type, this.types, true);
    }

    public String getSuffix(int index) {
        return this.get(index, this.suffixes);
    }

    public int getSuffixCount() {
        return this.suffixes.length;
    }

    public boolean hasSuffix(String suffix) {
        return this.has(suffix, this.suffixes, true);
    }

    public String getAction(int index) {
        return this.get(index, this.actions);
    }

    public int getActionCount() {
        return this.actions.length;
    }

    public boolean hasAction(String action) {
        return this.has(action, this.actions, false);
    }

    private String get(int index, String[] strings) {
        if (index < 0 || index >= strings.length) {
            throw new IndexOutOfBoundsException();
        }
        return strings[index];
    }

    private boolean has(String string, String[] strings, boolean ignoreCase) {
        int len = string.length();
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].length() != len || !string.regionMatches(ignoreCase, 0, strings[i], 0, len)) continue;
            return true;
        }
        return false;
    }

    public ActionNameMap getActionNameMap() {
        String locale = System.getProperty(LOCALE_PROP);
        return locale == null ? null : this.getActionNameMap(locale);
    }

    public ActionNameMap getActionNameMap(String locale) {
        while (locale.length() > 0) {
            for (int i = 0; i < this.actionnames.length; ++i) {
                if (!locale.equals(this.actionnames[i].getLocale())) continue;
                return this.actionnames[i];
            }
            int lastdash = locale.lastIndexOf(45);
            if (lastdash < 0) break;
            locale = locale.substring(0, lastdash);
        }
        return null;
    }

    public int getActionNameMapCount() {
        return this.actionnames.length;
    }

    public ActionNameMap getActionNameMap(int index) {
        if (index < 0 || index >= this.actionnames.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.actionnames[index];
    }

    public String getAppName() {
        return this.appname;
    }

    public String getVersion() {
        return this.version;
    }

    public String getID() {
        return this.ID;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getAccessAllowed(int index) {
        return this.get(index, this.accessRestricted);
    }

    public int accessAllowedCount() {
        return this.accessRestricted.length;
    }

    public boolean isAccessAllowed(String ID) {
        ID.length();
        if (this.accessRestricted.length == 0) {
            return true;
        }
        for (int i = 0; i < this.accessRestricted.length; ++i) {
            if (!ID.startsWith(this.accessRestricted[i])) continue;
            return true;
        }
        return false;
    }

    public InvocationImpl getRequest(boolean wait, Invocation invocation) {
        if (this.requestCalls == 0) {
            InvocationStore.setCleanup(this.storageID, this.classname, false);
        }
        ++this.requestCalls;
        InvocationImpl invoc = InvocationStore.getRequest(this.storageID, this.classname, wait);
        if (invoc != null) {
            AppProxy.requestForeground(invoc.invokingSuiteID, invoc.invokingClassname, invoc.suiteID, invoc.classname);
            invoc.invocation = invocation;
        }
        return invoc;
    }

    public void cancelGetRequest() {
        InvocationStore.cancel();
    }

    protected boolean finish(InvocationImpl invoc, int status) {
        int currst = invoc.getStatus();
        if (currst != 2 && currst != 4) {
            throw new IllegalStateException("Status already set");
        }
        return invoc.finish(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(RequestListener listener) {
        ContentHandlerImpl contentHandlerImpl = this;
        synchronized (contentHandlerImpl) {
            if (listener != null || this.listenerImpl != null) {
                if (this.listenerImpl == null) {
                    this.listenerImpl = new RequestListenerImpl(this, listener);
                } else {
                    this.listenerImpl.setListener(listener);
                }
                if (listener == null) {
                    this.listenerImpl = null;
                }
            }
        }
    }

    protected void requestNotify() {
    }

    void markUnregistered() {
        this.removed = true;
        this.ID = null;
        this.appname = null;
        this.version = null;
        this.version = null;
        this.authority = null;
        this.dynamic = false;
        this.types = null;
        this.suffixes = null;
        this.actions = null;
        this.actionnames = null;
        this.accessRestricted = null;
    }

    void decode(String s) {
        int[] offset = new int[]{0};
        this.storageID = ContentHandlerImpl.getString(s, offset);
        this.classname = ContentHandlerImpl.getString(s, offset);
        int n = offset[0];
        offset[0] = n + 1;
        boolean bl = this.removed = s.charAt(n) != '\u0000';
        if (this.removed) {
            return;
        }
        this.ID = ContentHandlerImpl.getString(s, offset);
        this.appname = ContentHandlerImpl.getString(s, offset);
        this.version = ContentHandlerImpl.getString(s, offset);
        this.authority = ContentHandlerImpl.getString(s, offset);
        int n2 = offset[0];
        offset[0] = n2 + 1;
        this.dynamic = s.charAt(n2) != '\u0000';
        this.types = ContentHandlerImpl.getStrings(s, offset);
        this.suffixes = ContentHandlerImpl.getStrings(s, offset);
        this.actions = ContentHandlerImpl.getStrings(s, offset);
        int n3 = offset[0];
        offset[0] = n3 + 1;
        int mapsLen = s.charAt(n3);
        this.actionnames = new ActionNameMap[mapsLen];
        for (int i = 0; i < mapsLen; ++i) {
            String locale = ContentHandlerImpl.getString(s, offset);
            String[] names = ContentHandlerImpl.getStrings(s, offset);
            this.actionnames[i] = new ActionNameMap(this.actions, names, locale);
        }
        this.accessRestricted = ContentHandlerImpl.getStrings(s, offset);
        int n4 = offset[0];
        offset[0] = n4 + 1;
        char delim = s.charAt(n4);
        if (delim != '\n') {
            throw new RuntimeException("corrupted content handler database");
        }
    }

    String encode() {
        StringBuffer sb = new StringBuffer(1024);
        ContentHandlerImpl.putString(this.storageID, sb);
        ContentHandlerImpl.putString(this.classname, sb);
        sb.append((char)(this.removed ? 1 : 0));
        if (this.removed) {
            return sb.toString();
        }
        ContentHandlerImpl.putString(this.ID, sb);
        ContentHandlerImpl.putString(this.appname, sb);
        ContentHandlerImpl.putString(this.version, sb);
        ContentHandlerImpl.putString(this.authority, sb);
        sb.append((char)(this.dynamic ? 1 : 0));
        ContentHandlerImpl.putStrings(this.types, sb);
        ContentHandlerImpl.putStrings(this.suffixes, sb);
        ContentHandlerImpl.putStrings(this.actions, sb);
        sb.append((char)this.actionnames.length);
        for (int i = 0; i < this.actionnames.length; ++i) {
            ActionNameMap map = this.actionnames[i];
            ContentHandlerImpl.putString(map.getLocale(), sb);
            int size = map.size();
            sb.append((char)size);
            for (int j = 0; j < size; ++j) {
                ContentHandlerImpl.putString(map.getActionName(j), sb);
            }
        }
        ContentHandlerImpl.putStrings(this.accessRestricted, sb);
        sb.append('\n');
        return sb.toString();
    }

    private static void putString(String string, StringBuffer sb) {
        if (string == null) {
            sb.append('\uffff');
        } else {
            int len = string.length();
            sb.append((char)len);
            sb.append(string);
        }
    }

    private static void putStrings(String[] strings, StringBuffer sb) {
        sb.append((char)strings.length);
        for (int i = 0; i < strings.length; ++i) {
            ContentHandlerImpl.putString(strings[i], sb);
        }
    }

    private static String getString(String s, int[] offset) {
        int n = offset[0];
        offset[0] = n + 1;
        char len = s.charAt(n);
        if ((len & 0xFFFF) == 65535) {
            return null;
        }
        if (len == '\u0000') {
            return "";
        }
        String v = s.substring(offset[0], offset[0] + len);
        offset[0] = offset[0] + len;
        return v;
    }

    private static String[] getStrings(String s, int[] offset) {
        int n = offset[0];
        offset[0] = n + 1;
        int len = s.charAt(n);
        if (len == 0) {
            return ZERO_STRINGS;
        }
        String[] strings = new String[len];
        for (int i = 0; i < len; ++i) {
            strings[i] = ContentHandlerImpl.getString(s, offset);
        }
        return strings;
    }

    boolean equals(ContentHandlerImpl other) {
        return this.seqno == other.seqno && this.storageID.equals(other.storageID) && this.classname.equals(other.classname);
    }

    public String toString() {
        if (AppProxy.LOG_INFO) {
            StringBuffer sb = new StringBuffer(80);
            sb.append("CH:");
            sb.append(" classname: ");
            sb.append(this.classname);
            sb.append(", removed: ");
            sb.append(this.removed);
            sb.append(", dynamic: ");
            sb.append(this.dynamic);
            sb.append(", types: ");
            this.toString(sb, this.types);
            sb.append(", ID: ");
            sb.append(this.ID);
            sb.append(", suffixes: ");
            this.toString(sb, this.suffixes);
            sb.append(", actions: ");
            this.toString(sb, this.actions);
            sb.append(", access: ");
            this.toString(sb, this.accessRestricted);
            sb.append(", suiteID: ");
            sb.append(this.storageID);
            sb.append(", authority: ");
            sb.append(this.authority);
            sb.append(", appname: ");
            sb.append(this.appname);
            return sb.toString();
        }
        return super.toString();
    }

    private void toString(StringBuffer sb, String[] strings) {
        if (strings == null) {
            sb.append("null");
            return;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(':');
            }
            sb.append(strings[i]);
        }
    }

    static {
        ZERO_STRINGS = new String[0];
        ZERO_ACTIONNAMES = new ActionNameMap[0];
    }
}

