/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim.formats;

import com.sun.kvem.midp.pim.UnsupportedPIMFormatException;
import com.sun.kvem.midp.pim.formats.Base64Encoding;
import com.sun.kvem.midp.pim.formats.QuotedPrintableEncoding;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class FormatSupport {
    public static final String QUOTED_PRINTABLE = "QUOTED_PRINTABLE";
    public static final String BASE64 = "BASE64";
    public static final String PLAIN_TEXT = "PLAIN_TEXT";
    public static final String UTF8 = "UTF-8";

    public static String getCharSet(String[] attributes) {
        String charset = FormatSupport.getAttributeValue(attributes, "CHARSET=", UTF8);
        try {
            "".getBytes(charset);
            return charset;
        }
        catch (UnsupportedEncodingException e) {
            return UTF8;
        }
    }

    public static String getAttributeValue(String[] attributes, String key, String defaultValue) {
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].startsWith(key)) continue;
            return attributes[i].substring(key.length());
        }
        return defaultValue;
    }

    public static String getEncoding(String[] attributes) {
        for (int i = 0; i < attributes.length; ++i) {
            String s = attributes[i].toUpperCase();
            if (attributes[i].equals("ENCODING=QUOTED-PRINTABLE") || attributes[i].equals("QUOTED-PRINTABLE")) {
                return QUOTED_PRINTABLE;
            }
            if (!attributes[i].equals("ENCODING=BASE64") && !attributes[i].equals(BASE64) && !attributes[i].equals("ENCODING=B")) continue;
            return BASE64;
        }
        return PLAIN_TEXT;
    }

    public static String convertString(String data, String encoding, String charset) {
        if (encoding.equals(QUOTED_PRINTABLE)) {
            byte[] b = QuotedPrintableEncoding.fromQuotedPrintable(data);
            try {
                return new String(b, charset);
            }
            catch (UnsupportedEncodingException e) {
                return new String(b);
            }
        }
        if (encoding.equals(BASE64)) {
            byte[] b = Base64Encoding.fromBase64(data);
            try {
                return new String(b, charset);
            }
            catch (UnsupportedEncodingException e) {
                return new String(b);
            }
        }
        if (charset.equals(UTF8)) {
            return data;
        }
        try {
            return new String(data.getBytes(UTF8), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 encoding not available");
        }
    }

    public static String[] split(String data, char separatorChar, int startingPoint) {
        int i;
        if (startingPoint == data.length()) {
            return new String[0];
        }
        Vector<String> elementList = new Vector<String>();
        int startSearchAt = startingPoint;
        int startOfElement = startingPoint;
        while ((i = data.indexOf(separatorChar, startSearchAt)) != -1) {
            if (i != 0 && data.charAt(i - 1) == '\\') {
                startSearchAt = i + 1;
                continue;
            }
            String element = data.substring(startOfElement, i);
            elementList.addElement(element);
            startSearchAt = startOfElement = i + 1;
        }
        if (elementList.size() == 0) {
            return new String[]{data.substring(startOfElement)};
        }
        elementList.addElement(data.substring(startOfElement));
        String[] elements = new String[elementList.size()];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = (String)elementList.elementAt(i2);
        }
        return elements;
    }

    public static String join(String[] elements, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(elements[i]);
        }
        return sb.toString();
    }

    public static void sort(int[] a) {
        for (int j = 1; j < a.length; ++j) {
            int v = a[j];
            for (int i = j - 1; i >= 0 && a[i] > v; --i) {
                a[i + 1] = a[i];
            }
            a[i + 1] = v;
        }
    }

    public static boolean contains(int[] a, int value) {
        int lowerBound = 0;
        int upperBound = a.length - 1;
        while (upperBound - lowerBound >= 0) {
            int i = lowerBound + (upperBound - lowerBound) / 2;
            int v = a[i];
            if (v > value) {
                upperBound = i - 1;
                continue;
            }
            if (v < value) {
                lowerBound = i + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public static DataElement parseObjectLine(String line) throws UnsupportedPIMFormatException {
        int i = line.indexOf(58);
        if (i == -1 || i == 0) {
            throw new UnsupportedPIMFormatException("Invalid line: '" + line + "'");
        }
        DataElement element = new DataElement();
        element.data = line.substring(i + 1).trim();
        String prefix = line.substring(0, i).trim();
        if ((i = prefix.indexOf(59)) == -1) {
            element.propertyName = prefix.toUpperCase();
            element.attributes = new String[0];
        } else {
            element.propertyName = prefix.substring(0, i).toUpperCase();
            element.attributes = FormatSupport.split(prefix, ';', i + 1);
            for (int j = 0; j < element.attributes.length; ++j) {
                element.attributes[j] = element.attributes[j].toUpperCase();
            }
        }
        i = element.propertyName.lastIndexOf(46);
        if (i != -1) {
            element.propertyName = element.propertyName.substring(i + 1);
        }
        return element;
    }

    public static String parseString(String[] attributes, String data) {
        String charset = FormatSupport.getCharSet(attributes);
        String encoding = FormatSupport.getEncoding(attributes);
        return FormatSupport.convertString(data, encoding, charset);
    }

    public static String[] parseStringArray(String[] attributes, String data) {
        String charset = FormatSupport.getCharSet(attributes);
        String encoding = FormatSupport.getEncoding(attributes);
        String[] elements = FormatSupport.split(data, ';', 0);
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = FormatSupport.convertString(elements[i], encoding, charset);
        }
        return elements;
    }

    public static byte[] parseBinary(String[] attributes, String data) {
        String encoding = FormatSupport.getEncoding(attributes);
        if (encoding.equals(QUOTED_PRINTABLE)) {
            return QuotedPrintableEncoding.fromQuotedPrintable(data);
        }
        if (encoding.equals(BASE64)) {
            return Base64Encoding.fromBase64(data);
        }
        return data.getBytes();
    }

    public static class DataElement {
        String propertyName;
        String[] attributes;
        String data;
    }
}

