/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim;

import com.sun.kvem.midp.pim.AbstractPIMItem;
import com.sun.kvem.midp.pim.AbstractPIMList;
import com.sun.kvem.midp.pim.ContactListImpl;
import com.sun.kvem.midp.pim.EventListImpl;
import com.sun.kvem.midp.pim.MarkableInputStream;
import com.sun.kvem.midp.pim.PIMFormat;
import com.sun.kvem.midp.pim.PIMHandler;
import com.sun.kvem.midp.pim.ToDoListImpl;
import com.sun.kvem.midp.pim.UnsupportedPIMFormatException;
import com.sun.kvem.midp.pim.formats.VCalendar10Format;
import com.sun.kvem.midp.pim.formats.VCard21Format;
import com.sun.kvem.midp.pim.formats.VCard30Format;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.Permissions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;

public final class PIMImpl
extends PIM {
    private static final PIMFormat[] formats = new PIMFormat[]{new VCalendar10Format(), new VCard21Format(), new VCard30Format()};

    public PIMItem[] fromSerialFormat(InputStream is, String enc) throws PIMException, UnsupportedEncodingException {
        return this.fromSerialFormat(is, enc, null);
    }

    private PIMItem[] fromSerialFormat(InputStream is, String enc, PIMList list) throws PIMException, UnsupportedEncodingException {
        if (enc == null) {
            enc = "UTF-8";
        }
        MarkableInputStream in = new MarkableInputStream(is);
        ((InputStream)in).mark(Integer.MAX_VALUE);
        try {
            for (int i = 0; i < formats.length; ++i) {
                try {
                    PIMItem[] items = formats[i].decode(in, enc, list);
                    if (items == null) {
                        throw new PIMException("Empty stream or insufficient data");
                    }
                    return items;
                }
                catch (UnsupportedPIMFormatException e) {
                    ((InputStream)in).reset();
                    ((InputStream)in).mark(Integer.MAX_VALUE);
                    continue;
                }
            }
            throw new PIMException("Format not recognized");
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PIMException(e.toString());
        }
    }

    public String[] listPIMLists(int pimListType) {
        this.checkPermissions(pimListType, 1);
        this.validatePimListType(pimListType);
        return PIMHandler.getInstance().getListNames(pimListType);
    }

    private void checkListPermissions(AbstractPIMList list, int mode) {
        if (mode == 1) {
            list.checkReadPermission();
        } else if (mode == 2) {
            list.checkWritePermission();
        } else if (mode == 3) {
            list.checkReadPermission();
            list.checkWritePermission();
        } else {
            throw new IllegalArgumentException("Invalid mode " + mode);
        }
    }

    private int[] getPermissions(int listType, int mode) {
        switch (listType) {
            case 1: {
                switch (mode) {
                    case 1: {
                        return new int[]{25};
                    }
                    case 2: {
                        return new int[]{26};
                    }
                    case 3: {
                        return new int[]{25, 26};
                    }
                }
                throw new IllegalArgumentException("Not a valid mode: " + mode);
            }
            case 2: {
                switch (mode) {
                    case 1: {
                        return new int[]{27};
                    }
                    case 2: {
                        return new int[]{28};
                    }
                    case 3: {
                        return new int[]{27, 28};
                    }
                }
                throw new IllegalArgumentException("Not a valid mode: " + mode);
            }
            case 3: {
                switch (mode) {
                    case 1: {
                        return new int[]{29};
                    }
                    case 2: {
                        return new int[]{30};
                    }
                    case 3: {
                        return new int[]{29, 30};
                    }
                }
                throw new IllegalArgumentException("Not a valid mode: " + mode);
            }
        }
        throw new IllegalArgumentException("Not a valid list type: " + listType);
    }

    private void checkPermissions(int pimListType, int mode) {
        int i;
        int[] permissions = this.getPermissions(pimListType, mode);
        MIDletSuite suite = Scheduler.getScheduler().getMIDletSuite();
        for (i = 0; i < permissions.length; ++i) {
            String name = Permissions.getName(permissions[i]);
            int status = suite.checkPermission(name);
            if (status == 0) {
                suite.checkIfPermissionAllowed(permissions[i]);
                continue;
            }
            if (status != 1) continue;
            permissions[i] = -1;
        }
        for (i = 0; i < permissions.length; ++i) {
            if (permissions[i] == -1) continue;
            try {
                suite.checkForPermission(permissions[i], null);
                continue;
            }
            catch (InterruptedException e) {
                throw new SecurityException("Security check interrupted: " + e.getMessage());
            }
        }
    }

    public PIMList openPIMList(int pimListType, int mode) throws PIMException {
        this.validatePimListType(pimListType);
        this.validateMode(mode);
        this.checkPermissions(pimListType, mode);
        String listName = PIMHandler.getInstance().getDefaultListName(pimListType);
        if (listName == null) {
            throw new PIMException("List not available");
        }
        return this.openPIMListImpl(pimListType, mode, listName);
    }

    public PIMList openPIMList(int pimListType, int mode, String name) throws PIMException {
        if (name == null) {
            throw new NullPointerException("PIM list name cannot be null");
        }
        this.validatePimListType(pimListType);
        this.validateMode(mode);
        this.checkPermissions(pimListType, mode);
        this.validateName(pimListType, name);
        return this.openPIMListImpl(pimListType, mode, name);
    }

    /*
     * WARNING - void declaration
     */
    private PIMList openPIMListImpl(int pimListType, int mode, String name) throws PIMException {
        void var4_4;
        switch (pimListType) {
            case 1: {
                AbstractPIMList list = new ContactListImpl(name, mode);
                break;
            }
            case 2: {
                AbstractPIMList list = new EventListImpl(name, mode);
                break;
            }
            case 3: {
                AbstractPIMList list = new ToDoListImpl(name, mode);
                break;
            }
            default: {
                throw new Error("Unreachable code");
            }
        }
        Object[] keys = PIMHandler.getInstance().getListKeys(pimListType, name);
        for (int i = 0; i < keys.length; ++i) {
            byte[] data = PIMHandler.getInstance().getListElement(pimListType, name, keys[i]);
            try {
                PIMItem[] items = this.fromSerialFormat(new ByteArrayInputStream(data), "UTF-8", (PIMList)var4_4);
                for (int j = 0; j < items.length; ++j) {
                    AbstractPIMItem item = (AbstractPIMItem)items[j];
                    item.setKey(keys[i]);
                    var4_4.addItem(item);
                    item.setDefaultValues();
                    item.setModified(false);
                }
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("UTF-8 not supported");
            }
            catch (PIMException e) {
                // empty catch block
            }
        }
        return var4_4;
    }

    public String[] supportedSerialFormats(int pimListType) {
        this.validatePimListType(pimListType);
        int supportedFormatCount = 0;
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].isTypeSupported(pimListType)) continue;
            ++supportedFormatCount;
        }
        String[] supportedFormats = new String[supportedFormatCount];
        for (int i = 0; i < formats.length; ++i) {
            if (!formats[i].isTypeSupported(pimListType)) continue;
            supportedFormats[--supportedFormatCount] = formats[i].getName();
        }
        return supportedFormats;
    }

    public void toSerialFormat(PIMItem item, OutputStream os, String enc, String dataFormat) throws PIMException, UnsupportedEncodingException {
        if (enc == null) {
            enc = "UTF-8";
        }
        if (dataFormat == null) {
            throw new NullPointerException("Null data format");
        }
        if (item == null) {
            throw new NullPointerException("Null PIM item");
        }
        try {
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].getName().equals(dataFormat)) continue;
                formats[i].encode(os, enc, item);
                return;
            }
            throw new PIMException("Data format '" + dataFormat + "' not supported.");
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new PIMException(e.toString());
        }
    }

    private void validatePimListType(int pimListType) {
        switch (pimListType) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a valid PIM list type: " + pimListType);
            }
        }
    }

    private void validateMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid PIM list mode: " + mode);
            }
        }
    }

    private void validateName(int pimListType, String name) throws PIMException {
        String[] names = PIMHandler.getInstance().getListNames(pimListType);
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            return;
        }
        throw new PIMException("PIM list does not exist: '" + name + "'");
    }
}

