/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim;

import com.sun.kvem.midp.pim.AbstractPIMList;
import com.sun.kvem.midp.pim.ContactImpl;
import com.sun.kvem.midp.pim.EmptyPIMField;
import com.sun.kvem.midp.pim.EventImpl;
import com.sun.kvem.midp.pim.PIMField;
import com.sun.kvem.midp.pim.PIMFormat;
import com.sun.kvem.midp.pim.PIMHandler;
import com.sun.kvem.midp.pim.ScalarPIMField;
import com.sun.kvem.midp.pim.ToDoImpl;
import com.sun.kvem.midp.pim.VectorPIMField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.microedition.pim.FieldFullException;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import javax.microedition.pim.UnsupportedFieldException;

public abstract class AbstractPIMItem
implements PIMItem {
    private int[] fieldKeys = new int[0];
    private PIMField[] fieldValues = new PIMField[0];
    private String[] categories = null;
    private boolean modified = true;
    private AbstractPIMList pimList;
    private Object key = null;
    private boolean removed = false;
    private final int type;

    protected AbstractPIMItem(AbstractPIMList pimList, int type) {
        this.pimList = pimList;
        this.type = type;
    }

    protected AbstractPIMItem(AbstractPIMList pimList, PIMItem baseItem) {
        this(pimList, pimList.getType());
        int[] fields = baseItem.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int field = fields[i];
            if (!pimList.isSupportedField(field)) continue;
            int dataType = pimList.getFieldDataType(field);
            int indices = baseItem.countValues(field);
            for (int index = 0; index < indices; ++index) {
                int attributes = baseItem.getAttributes(field, index);
                Object value = null;
                switch (dataType) {
                    case 0: {
                        value = baseItem.getBinary(field, index);
                        break;
                    }
                    case 1: {
                        value = new Boolean(baseItem.getBoolean(field, index));
                        break;
                    }
                    case 2: {
                        value = new Long(baseItem.getDate(field, index));
                        break;
                    }
                    case 3: {
                        value = new Integer(baseItem.getInt(field, index));
                        break;
                    }
                    case 4: {
                        value = baseItem.getString(field, index);
                        break;
                    }
                    case 5: {
                        value = baseItem.getStringArray(field, index);
                        break;
                    }
                }
                try {
                    this.addValue(field, attributes, value, true);
                    continue;
                }
                catch (FieldFullException ffe) {
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
        }
        this.updateRevision();
    }

    PIMField getField(int field, boolean create, boolean check) {
        PIMField f = this.getField(field);
        if (f == null) {
            PIMHandler handler = PIMHandler.getInstance();
            if (check && !handler.isSupportedField(this.type, field)) {
                throw AbstractPIMItem.complaintAboutField(this.type, field);
            }
            if (create) {
                int dataType = handler.getFieldDataType(this.type, field);
                f = new EmptyPIMField();
                this.putField(field, f);
            }
        }
        return f;
    }

    private void setValue(int field, int index, int attributes, Object value, boolean force) {
        try {
            this.checkType(field, value);
            PIMField pimField = this.getField(field, false, true);
            if (pimField == null) {
                throw new IndexOutOfBoundsException("Empty field: " + field);
            }
            int currentValues = pimField.getValueCount();
            if (index < 0 || index >= currentValues) {
                throw new IndexOutOfBoundsException("0 <= index < " + currentValues + ", " + index + " not in range");
            }
            if (!force) {
                this.checkReadOnlyFields(field);
            }
            attributes = this.filterAttributes(field, attributes);
            pimField.setValue(attributes, value, index);
            this.modified = true;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Wrong type for field");
        }
    }

    private void addValue(int field, int attributes, Object value, boolean force) {
        this.checkType(field, value);
        PIMField pimField = this.getField(field, true, true);
        int maxValues = PIMHandler.getInstance().getMaximumValues(this.type, field);
        int currentValues = pimField.getValueCount();
        if (maxValues != -1 && currentValues >= maxValues) {
            throw new FieldFullException("Can only store " + maxValues + " in field", field);
        }
        if (!force) {
            this.checkReadOnlyFields(field);
        }
        if (pimField.isScalar()) {
            if (currentValues == 0) {
                pimField = new ScalarPIMField();
                this.putField(field, pimField);
            } else {
                Object value0 = pimField.getValue(0);
                int attributes0 = pimField.getAttributes(0);
                pimField = new VectorPIMField();
                pimField.addValue(attributes0, value0);
                this.putField(field, pimField);
            }
        }
        attributes = this.filterAttributes(field, attributes);
        pimField.addValue(attributes, value);
        this.modified = true;
    }

    private int filterAttributes(int field, int attributes) {
        if (attributes == 0) {
            return 0;
        }
        return attributes & PIMHandler.getInstance().getSupportedAttributesMask(this.type, field);
    }

    private Object getValue(int field, int index) {
        PIMField pimField = this.getField(field, false, true);
        if (pimField == null) {
            throw new IndexOutOfBoundsException("Empty field: " + field);
        }
        int currentValues = pimField.getValueCount();
        if (index < 0 || index >= currentValues) {
            throw new IndexOutOfBoundsException("0 <= index < " + currentValues + ", " + index + " not in range");
        }
        return pimField.getValue(index);
    }

    public void addStringArray(int field, int attributes, String[] value) {
        this.checkType(field, 5);
        this.validateStringArray(field, value);
        this.addValue(field, attributes, value, false);
    }

    public void addBoolean(int field, int attributes, boolean value) {
        this.addValue(field, attributes, new Boolean(value), false);
    }

    public void removeFromCategory(String category) {
        if (category == null) {
            throw new NullPointerException("Null category");
        }
        if (this.categories != null) {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!category.equals(this.categories[i])) continue;
                if (this.categories.length == 1) {
                    this.categories = null;
                } else {
                    String[] a = new String[this.categories.length - 1];
                    System.arraycopy(this.categories, 0, a, 0, i);
                    System.arraycopy(this.categories, i + 1, a, i, a.length - i);
                    this.categories = a;
                }
                this.modified = true;
                return;
            }
        }
    }

    public int[] getFields() {
        int emptyFields = 0;
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (this.fieldValues[i].getValueCount() != 0) continue;
            ++emptyFields;
        }
        int[] keys = new int[this.fieldKeys.length - emptyFields];
        int j = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (emptyFields == 0 || this.fieldValues[i].getValueCount() != 0) {
                keys[j++] = this.fieldKeys[i];
                continue;
            }
            --emptyFields;
        }
        return keys;
    }

    public boolean getBoolean(int field, int index) {
        this.checkType(field, 1);
        return (Boolean)this.getValue(field, index);
    }

    public void addDate(int field, int attributes, long value) {
        this.addValue(field, attributes, new Long(value), false);
    }

    public int maxCategories() {
        return -1;
    }

    public void setDate(int field, int index, int attributes, long value) {
        this.setValue(field, index, attributes, new Long(value), false);
    }

    public int getInt(int field, int index) {
        this.checkType(field, 3);
        try {
            return (Integer)this.getValue(field, index);
        }
        catch (ClassCastException e) {
            String message = "Cannot convert to integer on field " + field + ": " + this.getValue(field, index).getClass();
            throw new ClassCastException(message);
        }
    }

    public void setBinary(int field, int index, int attributes, byte[] value, int offset, int length) {
        this.validateBinaryValue(value, offset, length);
        length = Math.min(length, value.length - offset);
        byte[] b = new byte[length];
        System.arraycopy(value, offset, b, 0, length);
        this.setValue(field, index, attributes, b, false);
    }

    public int getAttributes(int field, int index) {
        return this.getField(field, true, true).getAttributes(index);
    }

    public int countValues(int field) {
        PIMField pimField = this.getField(field, false, true);
        return pimField == null ? 0 : pimField.getValueCount();
    }

    public void addString(int field, int attributes, String value) {
        this.validateString(value);
        this.addValue(field, attributes, value, false);
    }

    public String[] getCategories() {
        if (this.categories == null) {
            return new String[0];
        }
        String[] cs = new String[this.categories.length];
        System.arraycopy(this.categories, 0, cs, 0, this.categories.length);
        return cs;
    }

    String[] getCategoriesRaw() {
        return this.categories;
    }

    public void setInt(int field, int index, int attributes, int value) {
        this.setValue(field, index, attributes, new Integer(value), false);
    }

    public void setStringArray(int field, int index, int attributes, String[] value) {
        this.checkType(field, 5);
        this.validateStringArray(field, value);
        this.setValue(field, index, attributes, value, false);
    }

    private void validateStringArray(int field, String[] a) {
        int requiredLength = PIMHandler.getInstance().getStringArraySize(this.type, field);
        if (a.length != requiredLength) {
            throw new IllegalArgumentException("String array length incorrect: should be " + requiredLength);
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            return;
        }
        throw new IllegalArgumentException("No non-null elements in array");
    }

    private void validateString(String value) {
        if (value == null) {
            throw new NullPointerException("String field value should not be null");
        }
    }

    public long getDate(int field, int index) {
        this.checkType(field, 2);
        return (Long)this.getValue(field, index);
    }

    public void addToCategory(String category) throws PIMException {
        if (category == null) {
            throw new NullPointerException("Null category");
        }
        if (this.categories == null) {
            this.categories = new String[]{category};
            this.modified = true;
        } else {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!this.categories[i].equals(category)) continue;
                return;
            }
            String[] a = new String[this.categories.length + 1];
            System.arraycopy(this.categories, 0, a, 0, this.categories.length);
            a[this.categories.length] = category;
            this.categories = a;
            this.modified = true;
        }
    }

    public void addInt(int field, int attributes, int value) {
        this.addValue(field, attributes, new Integer(value), false);
    }

    public byte[] getBinary(int field, int index) {
        this.checkType(field, 0);
        return (byte[])this.getValue(field, index);
    }

    public void addBinary(int field, int attributes, byte[] value, int offset, int length) {
        this.validateBinaryValue(value, offset, length);
        length = Math.min(length, value.length - offset);
        byte[] b = new byte[length];
        System.arraycopy(value, offset, b, 0, length);
        this.addValue(field, attributes, b, false);
    }

    private void validateBinaryValue(byte[] value, int offset, int length) {
        if (value == null) {
            throw new NullPointerException("Binary field value should not be null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Negative offset");
        }
        if (offset >= value.length) {
            throw new IllegalArgumentException("Offset out of range");
        }
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be at least 1");
        }
        if (value.length == 0) {
            throw new IllegalArgumentException("Binary array value has zero length");
        }
    }

    public String[] getStringArray(int field, int index) {
        this.checkType(field, 5);
        return (String[])this.getValue(field, index);
    }

    public void setBoolean(int field, int index, int attributes, boolean value) {
        this.setValue(field, index, attributes, new Boolean(value), false);
    }

    public PIMList getPIMList() {
        return this.pimList;
    }

    void setPIMList(AbstractPIMList list) {
        this.pimList = list;
    }

    public void removeValue(int field, int index) {
        PIMField pimField = this.getField(field, false, true);
        if (pimField == null) {
            throw new IndexOutOfBoundsException("Empty field: " + field);
        }
        int currentValues = pimField.getValueCount();
        if (index < 0 || index >= currentValues) {
            throw new IndexOutOfBoundsException("0 <= index < " + currentValues + ", " + index + " not in range");
        }
        this.checkReadOnlyFields(field);
        pimField.removeValue(index);
        if (--currentValues == 0) {
            this.removeField(field);
        } else if (currentValues == 1) {
            Object value = pimField.getValue(0);
            int attributes = pimField.getAttributes(0);
            pimField = new ScalarPIMField();
            pimField.addValue(attributes, value);
            this.putField(field, pimField);
        }
        this.modified = true;
    }

    public String getString(int field, int index) {
        this.checkType(field, 4);
        return (String)this.getValue(field, index);
    }

    public void setString(int field, int index, int attributes, String value) {
        this.validateString(value);
        this.setValue(field, index, attributes, value, false);
    }

    public boolean isModified() {
        return this.modified;
    }

    void setModified(boolean modified) {
        this.modified = modified;
    }

    public void commit() throws PIMException {
        if (this.pimList == null) {
            throw new PIMException("Item is not in a list");
        }
        this.pimList.checkWritePermission();
        this.pimList.checkOpen();
        this.updateRevision();
        this.setDefaultValues();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PIMFormat format = this.getEncodingFormat();
            format.encode(baos, "UTF-8", this);
            Object newKey = this.pimList.commit(this.key, baos.toByteArray());
            if (this.key == null) {
                this.pimList.addItem(this);
            }
            this.setKey(newKey);
            this.updateUID();
            this.modified = false;
        }
        catch (IOException e) {
            throw new PIMException("Error persisting PIMItem");
        }
    }

    abstract PIMFormat getEncodingFormat();

    boolean isInCategory(String category) {
        if (this.categories == null) {
            return false;
        }
        for (int i = 0; i < this.categories.length; ++i) {
            if (!this.categories[i].equals(category)) continue;
            return true;
        }
        return false;
    }

    void setKey(Object key) {
        this.key = key;
        if (key != null) {
            this.updateUID();
        }
    }

    Object getKey() {
        return this.key;
    }

    void remove() throws PIMException {
        if (this.pimList == null) {
            throw new PIMException("Item is not in a list");
        }
        this.pimList.checkWritePermission();
        this.removed = true;
        this.pimList.commit(this.key, null);
        this.setKey(null);
        this.pimList = null;
    }

    protected void setDefaultValues() {
        int[] supportedFields = this.pimList.getSupportedFields();
        PIMHandler handler = PIMHandler.getInstance();
        block8: for (int i = 0; i < supportedFields.length; ++i) {
            int field = supportedFields[i];
            PIMField pimField = this.getField(field, false, true);
            if (pimField != null && pimField.getValueCount() != 0 || !handler.hasDefaultValue(this.type, field)) continue;
            Object value = null;
            switch (this.pimList.getFieldDataType(field)) {
                case 1: {
                    value = new Boolean(handler.getDefaultBooleanValue(this.type, field));
                    break;
                }
                case 0: {
                    value = handler.getDefaultBinaryValue(this.type, field);
                    break;
                }
                case 2: {
                    value = new Long(handler.getDefaultDateValue(this.type, field));
                    break;
                }
                case 3: {
                    value = new Integer(handler.getDefaultIntValue(this.type, field));
                    break;
                }
                case 4: {
                    value = handler.getDefaultStringValue(this.type, field);
                    break;
                }
                case 5: {
                    value = handler.getDefaultStringArrayValue(this.type, field);
                    break;
                }
                default: {
                    continue block8;
                }
            }
            this.addValue(field, 0, value, false);
        }
    }

    static boolean isValidPIMField(int type, int field) {
        switch (type) {
            case 1: {
                return ContactImpl.isValidPIMField(field);
            }
            case 2: {
                return EventImpl.isValidPIMField(field);
            }
            case 3: {
                return ToDoImpl.isValidPIMField(field);
            }
        }
        return false;
    }

    private void checkType(int field, Object value) {
        try {
            int dataType = PIMHandler.getInstance().getFieldDataType(this.type, field);
            switch (dataType) {
                case 0: {
                    byte[] b = (byte[])value;
                    break;
                }
                case 1: {
                    Boolean b = (Boolean)value;
                    break;
                }
                case 2: {
                    Long l = (Long)value;
                    break;
                }
                case 3: {
                    Integer i = (Integer)value;
                    break;
                }
                case 4: {
                    String s = (String)value;
                    break;
                }
                case 5: {
                    String[] s = (String[])value;
                    break;
                }
                default: {
                    throw AbstractPIMItem.complaintAboutField(this.type, field);
                }
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException(cce.getMessage());
        }
    }

    private void checkType(int field, int dataType) {
        int correctDataType = PIMHandler.getInstance().getFieldDataType(this.type, field);
        if (dataType != correctDataType && correctDataType != -1) {
            throw new IllegalArgumentException("Wrong data type");
        }
        if (correctDataType == -1) {
            throw AbstractPIMItem.complaintAboutField(this.type, field);
        }
    }

    static RuntimeException complaintAboutField(int type, int field) {
        if (AbstractPIMItem.isValidPIMField(type, field)) {
            return new UnsupportedFieldException(String.valueOf(field));
        }
        return new IllegalArgumentException("Invalid field " + field);
    }

    private int findFieldKey(int key) {
        int lowerBound = 0;
        int upperBound = this.fieldKeys.length;
        while (lowerBound != upperBound) {
            int index = lowerBound + (upperBound - lowerBound) / 2;
            int indexKey = this.fieldKeys[index];
            if (indexKey > key) {
                if (index == upperBound) {
                    --upperBound;
                    continue;
                }
                upperBound = index;
                continue;
            }
            if (indexKey == key) {
                return index;
            }
            if (index == lowerBound) {
                ++lowerBound;
                continue;
            }
            lowerBound = index;
        }
        return ~lowerBound;
    }

    public void putField(int key, PIMField field) {
        int index = this.findFieldKey(key);
        if (index >= 0) {
            this.fieldValues[index] = field;
        } else {
            int[] newKeys = new int[this.fieldKeys.length + 1];
            PIMField[] newFields = new PIMField[this.fieldValues.length + 1];
            System.arraycopy(this.fieldKeys, 0, newKeys, 0, index ^= 0xFFFFFFFF);
            System.arraycopy(this.fieldValues, 0, newFields, 0, index);
            newKeys[index] = key;
            newFields[index] = field;
            System.arraycopy(this.fieldKeys, index, newKeys, index + 1, this.fieldKeys.length - index);
            System.arraycopy(this.fieldValues, index, newFields, index + 1, this.fieldKeys.length - index);
            this.fieldKeys = newKeys;
            this.fieldValues = newFields;
        }
    }

    public PIMField getField(int key) {
        int index = this.findFieldKey(key);
        if (index >= 0) {
            return this.fieldValues[index];
        }
        return null;
    }

    public void removeField(int key) {
        int index = this.findFieldKey(key);
        if (index >= 0) {
            int[] newKeys = new int[this.fieldKeys.length - 1];
            PIMField[] newFields = new PIMField[this.fieldValues.length - 1];
            System.arraycopy(this.fieldKeys, 0, newKeys, 0, index);
            System.arraycopy(this.fieldValues, 0, newFields, 0, index);
            System.arraycopy(this.fieldKeys, index + 1, newKeys, index, newKeys.length - index);
            System.arraycopy(this.fieldValues, index + 1, newFields, index, newKeys.length - index);
            this.fieldKeys = newKeys;
            this.fieldValues = newFields;
        }
    }

    private void checkReadOnlyFields(int field) {
        if (this.key != null) {
            if (field == this.getRevisionField()) {
                throw new IllegalArgumentException("REVISION field is read only except on newly created PIMItems");
            }
            if (field == this.getUIDField()) {
                throw new IllegalArgumentException("UID field is read only except on newly created PIMItems");
            }
        }
    }

    private void updateRevision() {
        Long value = new Long(System.currentTimeMillis());
        int field = this.getRevisionField();
        if (this.countValues(field) == 0) {
            this.addValue(field, 0, value, true);
        } else {
            this.setValue(field, 0, 0, value, true);
        }
    }

    private void updateUID() {
        String value = this.key.toString();
        int field = this.getUIDField();
        if (this.countValues(field) == 0) {
            this.addValue(field, 0, value, true);
        } else {
            this.setValue(field, 0, 0, value, true);
        }
    }

    protected abstract int getRevisionField();

    protected abstract int getUIDField();

    protected String formatData() {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < this.fieldValues.length; ++i) {
            if (this.fieldValues[i].getValueCount() == 0) continue;
            PIMField pimField = this.fieldValues[i];
            int field = this.fieldKeys[i];
            int valueCount = pimField.getValueCount();
            if (valueCount == 0) continue;
            if (i != 0) {
                sb.append(", ");
            }
            String label = PIMHandler.getInstance().getFieldLabel(this.type, field);
            int dataType = PIMHandler.getInstance().getFieldDataType(this.type, field);
            block6: for (int j = 0; j < valueCount; ++j) {
                sb.append(label);
                if (valueCount != 1) {
                    sb.append("[");
                    sb.append(j);
                    sb.append("]");
                }
                sb.append("=");
                Object value = pimField.getValue(j);
                if (value == null) {
                    sb.append("null");
                    continue;
                }
                switch (dataType) {
                    case 5: {
                        String[] aValue = (String[])value;
                        sb.append("[");
                        for (int k = 0; k < aValue.length; ++k) {
                            if (k != 0) {
                                sb.append(",");
                            }
                            sb.append(aValue[k]);
                        }
                        sb.append("]");
                        continue block6;
                    }
                    case 0: {
                        byte[] bValue = (byte[])value;
                        sb.append("<" + bValue.length + " bytes>");
                        continue block6;
                    }
                    case 2: {
                        long dValue = (Long)value;
                        sb.append(PIMHandler.getInstance().composeDateTime(dValue));
                        continue block6;
                    }
                    default: {
                        sb.append(value);
                    }
                }
            }
        }
        if (this.categories != null && this.categories.length != 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("Categories=[");
            for (i = 0; i < this.categories.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.categories[i]);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    protected abstract String toDisplayableString();

    public String toString() {
        return "true".equals(System.getProperty("pim.debug")) ? this.toDisplayableString() : super.toString();
    }
}

