/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp;

import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Utils {
    public static final String BASE64 = "BASE64";
    public static final String PLAIN_TEXT = "PLAIN_TEXT";
    public static final String UTF8 = "UTF-8";

    public static String getCharSet(String[] attributes) {
        String charset = Utils.getAttributeValue(attributes, "CHARSET=", UTF8);
        try {
            "".getBytes(charset);
            return charset;
        }
        catch (UnsupportedEncodingException e) {
            return UTF8;
        }
    }

    public static String getAttributeValue(String[] attributes, String key, String defaultValue) {
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].startsWith(key)) continue;
            return attributes[i].substring(key.length());
        }
        return defaultValue;
    }

    public static String[] split(String data, char separatorChar, int startingPoint) {
        int i;
        if (startingPoint == data.length()) {
            return new String[0];
        }
        Vector<String> elementList = new Vector<String>();
        int startSearchAt = startingPoint;
        int startOfElement = startingPoint;
        while ((i = data.indexOf(separatorChar, startSearchAt)) != -1) {
            if (i != 0 && data.charAt(i - 1) == '\\') {
                startSearchAt = i + 1;
                continue;
            }
            String element = data.substring(startOfElement, i).trim();
            elementList.addElement(element);
            startSearchAt = startOfElement = i + 1;
        }
        if (elementList.size() == 0) {
            return new String[]{data.substring(startOfElement)};
        }
        elementList.addElement(data.substring(startOfElement));
        String[] elements = new String[elementList.size()];
        for (int i2 = 0; i2 < elements.length; ++i2) {
            elements[i2] = (String)elementList.elementAt(i2);
        }
        return elements;
    }

    public static String join(String[] elements, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(elements[i]);
        }
        return sb.toString();
    }

    public static void sort(int[] a) {
        for (int j = 1; j < a.length; ++j) {
            int v = a[j];
            for (int i = j - 1; i >= 0 && a[i] > v; --i) {
                a[i + 1] = a[i];
            }
            a[i + 1] = v;
        }
    }

    public static boolean contains(int[] a, int value) {
        int lowerBound = 0;
        int upperBound = a.length - 1;
        while (upperBound - lowerBound >= 0) {
            int i = lowerBound + (upperBound - lowerBound) / 2;
            int v = a[i];
            if (v > value) {
                upperBound = i - 1;
                continue;
            }
            if (v < value) {
                lowerBound = i + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public static class DataElement {
        String propertyName;
        String[] attributes;
        String data;
    }
}

