/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.location;

import com.sun.kvem.location.PortingLayer;
import java.util.Vector;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationListener;
import javax.microedition.location.LocationProvider;

public abstract class LocationProviderImpl
extends LocationProvider
implements Runnable {
    private static Vector proximityListeners = new Vector();
    private static Location LastKnownLocation;
    private static LocationProviderImpl Instance;
    protected LocationListener locationListener;
    private int interval;
    private int timeout;
    private int maxAge;
    private Location currentLocation;
    protected Criteria criteria;
    protected Thread locationThread;
    private boolean initial;

    public abstract boolean matchesCriteria(Criteria var1);

    public abstract int getDefaultInterval();

    public abstract int getDefaultMaxAge();

    public abstract int getDefaultTimeout();

    abstract String getName();

    public static Location getLastKnownLocation() {
        PortingLayer.getInstance().checkForPermission(36);
        return LocationProviderImpl.getLastKnownLocationImpl();
    }

    static Location getLastKnownLocationImpl() {
        return LastKnownLocation;
    }

    protected static void setLastKnownLocation(Location newLoc) {
        if (newLoc != null) {
            LastKnownLocation = newLoc;
        }
    }

    public Location getLocation(int timeout) throws LocationException, InterruptedException {
        PortingLayer.getInstance().checkForPermission(36);
        Location loc = this.getLocationImpl(timeout);
        LocationProviderImpl.setLastKnownLocation(loc);
        return loc;
    }

    protected abstract Location getLocationImpl(int var1) throws LocationException, InterruptedException;

    public static LocationProvider getInstance(Criteria criteria) throws LocationException {
        int oos = 0;
        LocationProviderImpl[] found = new LocationProviderImpl[3];
        if (criteria == null) {
            criteria = new Criteria();
        }
        LocationProviderImpl[] providers = PortingLayer.getInstance().getProviders();
        for (int i = 0; i < providers.length; ++i) {
            LocationProviderImpl provider = providers[i];
            if (provider.matchesCriteria(criteria)) {
                found[provider.getState() - 1] = provider;
            }
            if (provider.getState() != 3) continue;
            ++oos;
        }
        if (oos == providers.length) {
            throw new LocationException("All providers are out of service");
        }
        Instance = null;
        if (found[0] != null) {
            Instance = found[0];
        } else if (found[1] != null) {
            Instance = found[1];
        }
        return Instance;
    }

    public LocationListener getLocationListener() {
        return this.locationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocationListener(LocationListener listener, int interval, int timeout, int maxAge) {
        PortingLayer.getInstance().checkForPermission(36);
        PortingLayer.getInstance().registerLocationListener(listener, this);
        if (listener == null) {
            this.locationListener = null;
            return;
        }
        if (interval < -1 || interval != -1 && (timeout > interval || maxAge > interval || timeout < 1 && timeout != -1 || maxAge < 1 && maxAge != -1)) {
            throw new IllegalArgumentException();
        }
        if (interval == 0) {
            this.locationListener = listener;
            return;
        }
        if (interval == -1) {
            interval = this.getDefaultInterval();
            maxAge = this.getDefaultMaxAge();
            timeout = this.getDefaultTimeout();
        }
        if (maxAge == -1) {
            maxAge = this.getDefaultMaxAge();
        }
        if (timeout == -1) {
            timeout = this.getDefaultTimeout();
        }
        this.locationListener = listener;
        this.interval = interval;
        this.timeout = timeout;
        this.maxAge = maxAge;
        this.initial = true;
        LocationProviderImpl locationProviderImpl = this;
        synchronized (locationProviderImpl) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                while (true) {
                    long clock = this.interval * 1000;
                    if (this.locationListener != null && this.interval != 0) {
                        if (clock > 0L) {
                            LocationProviderImpl locationProviderImpl = this;
                            synchronized (locationProviderImpl) {
                                this.initialLocationNotification();
                                this.wait(clock);
                                if (this.locationListener == null || this.interval == 0) {
                                    continue;
                                }
                            }
                        }
                        long time = System.currentTimeMillis();
                        if (this.currentLocation != null) {
                            if (System.currentTimeMillis() - this.currentLocation.getTimestamp() > (long)(this.maxAge * 1000)) {
                                this.currentLocation = this.getLocation(this.timeout);
                            }
                        } else {
                            this.currentLocation = this.getLocation(this.timeout);
                        }
                        LastKnownLocation = this.currentLocation;
                        this.locationListener.locationUpdated((LocationProvider)this, this.currentLocation);
                        clock = (long)(this.interval * 1000) - (System.currentTimeMillis() - time);
                        continue;
                    }
                    LocationProviderImpl locationProviderImpl = this;
                    synchronized (locationProviderImpl) {
                        this.wait();
                    }
                    this.initialLocationNotification();
                }
            }
            catch (LocationException le) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void initialLocationNotification() throws LocationException, InterruptedException {
        if (this.initial) {
            LastKnownLocation = this.currentLocation = this.getLocation(this.timeout);
            this.locationListener.locationUpdated((LocationProvider)this, this.currentLocation);
            this.initial = false;
        }
    }
}

