/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ObexPacketStream;
import com.sun.kvem.jsr082.obex.ObexTransport;
import com.sun.kvem.jsr082.obex.ServerOperation;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.obex.Authenticator;
import javax.obex.HeaderSet;
import javax.obex.Operation;
import javax.obex.ServerRequestHandler;

class ServerConnectionImpl
extends ObexPacketStream
implements Connection,
Runnable {
    private static final boolean DEBUG = false;
    ServerRequestHandler handler;
    private int maxClientPacketSize;
    private int owner;
    private boolean isConnected;
    private long connId;
    boolean operationHeadersOverflow = false;
    boolean operationClosed;

    void headerTooLarge() throws IOException {
        this.operationHeadersOverflow = true;
        this.operationClosed = true;
    }

    ServerConnectionImpl(ObexTransport transport, ServerRequestHandler handler, Authenticator auth) throws IOException {
        super(transport);
        this.handler = handler;
        this.isClient = false;
        this.authenticator = auth;
        this.owner = 1;
        new Thread(this).start();
    }

    public void run() {
        try {
            while (this.processRequest() && !this.isClosed()) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.close();
    }

    private int sendResponsePacket(byte[] head, HeaderSetImpl headers) throws IOException {
        int status = head[0] & 0xFF;
        this.packetBegin(head);
        this.packetAddConnectionID(this.getConnectionID(), headers);
        this.packetAddAuthResponses();
        this.packetAddHeaders(headers);
        if (!this.queuedHeaders.isEmpty() || this.operationHeadersOverflow) {
            this.queuedHeaders.removeAllElements();
            this.setPacketType(206);
        }
        this.packetEnd();
        return status;
    }

    private void doConnect() throws IOException {
        byte[] head;
        HeaderSetImpl inputHeaderSet = new HeaderSetImpl(this.owner);
        HeaderSetImpl responseHeaderSet = new HeaderSetImpl(this.owner);
        if (this.buffer[3] != 16 || this.packetLength < 7) {
            throw new IOException("unsupported client obex version");
        }
        this.maxSendLength = this.decodeLength16(5);
        if (this.maxSendLength > this.OBEX_MAXIMUM_PACKET_LENGTH) {
            this.maxSendLength = this.OBEX_MAXIMUM_PACKET_LENGTH;
        }
        this.parsePacketHeaders(inputHeaderSet, 7);
        int status = 208;
        try {
            status = this.handler.onConnect((HeaderSet)inputHeaderSet, (HeaderSet)responseHeaderSet);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        status = ServerConnectionImpl.validateStatus(status);
        if (status != 160) {
            this.authResponses.removeAllElements();
        }
        if ((status = this.sendResponsePacket(head = new byte[]{(byte)status, 0, 0, 16, 0, (byte)(this.OBEX_MAXIMUM_PACKET_LENGTH / 256), (byte)(this.OBEX_MAXIMUM_PACKET_LENGTH % 256)}, responseHeaderSet)) == 160) {
            this.isConnected = true;
        }
    }

    private boolean notConnected() throws IOException {
        if (!this.isConnected) {
            HeaderSetImpl headers = new HeaderSetImpl(this.owner);
            headers.setHeader(5, "not connected");
            this.sendPacket(PACKET_BAD_REQUEST, this.getConnectionID(), headers, true);
            return true;
        }
        return false;
    }

    void onAuthenticationFailure(byte[] username) throws IOException {
        try {
            this.handler.onAuthenticationFailure(username);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.operationClosed = true;
    }

    private void doDisconnect() throws IOException {
        if (this.notConnected()) {
            return;
        }
        HeaderSetImpl inputHeaderSet = new HeaderSetImpl(this.owner);
        HeaderSetImpl responseHeaderSet = new HeaderSetImpl(this.owner);
        this.parsePacketHeaders(inputHeaderSet, 3);
        try {
            this.handler.onDisconnect((HeaderSet)inputHeaderSet, (HeaderSet)responseHeaderSet);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        byte[] head = new byte[]{-96, 0, 0};
        int status = this.sendResponsePacket(head, responseHeaderSet);
        if (status == 160) {
            this.isConnected = false;
        }
    }

    private void doPut(HeaderSetImpl inputHeaderSet) throws IOException {
        int status = 208;
        ServerOperation op = new ServerOperation(this, inputHeaderSet);
        try {
            status = this.handler.onPut((Operation)op);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        status = ServerConnectionImpl.validateStatus(status);
        if (this.operationHeadersOverflow) {
            status = 206;
        }
        op.destroy(status);
    }

    private void doDelete(HeaderSetImpl inputHeaderSet) throws IOException {
        HeaderSetImpl responseHeaderSet = new HeaderSetImpl(this.owner);
        int status = 208;
        try {
            status = this.handler.onDelete((HeaderSet)inputHeaderSet, (HeaderSet)responseHeaderSet);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        status = ServerConnectionImpl.validateStatus(status);
        byte[] head = new byte[]{(byte)status, 0, 0};
        this.sendResponsePacket(head, responseHeaderSet);
    }

    private void doPutOrDelete() throws IOException {
        if (this.notConnected()) {
            return;
        }
        HeaderSetImpl inputHeaderSet = new HeaderSetImpl(this.owner);
        int mode = ServerOperation.waitForData(this, inputHeaderSet, 2);
        switch (mode) {
            case 0: {
                this.sendPacket(PACKET_SUCCESS, this.getConnectionID(), null, true);
                return;
            }
            case 1: {
                this.doPut(inputHeaderSet);
                return;
            }
            case 2: {
                this.doDelete(inputHeaderSet);
                return;
            }
        }
    }

    private void doGet() throws IOException {
        if (this.notConnected()) {
            return;
        }
        int status = 208;
        ServerOperation op = new ServerOperation(this);
        try {
            status = this.handler.onGet((Operation)op);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        status = ServerConnectionImpl.validateStatus(status);
        if (this.operationHeadersOverflow) {
            status = 206;
        }
        op.destroy(status);
    }

    private void doSetPath() throws IOException {
        if (this.notConnected()) {
            return;
        }
        HeaderSetImpl inputHeaderSet = new HeaderSetImpl(this.owner);
        HeaderSetImpl responseHeaderSet = new HeaderSetImpl(this.owner);
        boolean create = (this.buffer[3] & 2) == 0;
        boolean backup = (this.buffer[3] & 1) == 1;
        this.parsePacketHeaders(inputHeaderSet, 5);
        int status = 208;
        try {
            status = this.handler.onSetPath((HeaderSet)inputHeaderSet, (HeaderSet)responseHeaderSet, backup, create);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        status = ServerConnectionImpl.validateStatus(status);
        byte[] head = new byte[]{(byte)status, 0, 0};
        this.sendResponsePacket(head, responseHeaderSet);
    }

    private boolean processRequest() throws IOException {
        try {
            this.recvPacket();
        }
        catch (IOException e) {
            return false;
        }
        HeaderSetImpl inputHeaderSet = new HeaderSetImpl(this.owner);
        HeaderSetImpl responseHeaderSet = new HeaderSetImpl(this.owner);
        this.operationHeadersOverflow = false;
        this.operationClosed = false;
        this.isEof = false;
        switch (this.packetType) {
            case 128: {
                this.doConnect();
                break;
            }
            case 129: {
                this.doDisconnect();
                break;
            }
            case 2: 
            case 130: {
                this.doPutOrDelete();
                break;
            }
            case 3: 
            case 131: {
                this.doGet();
                break;
            }
            case 133: {
                this.doSetPath();
                break;
            }
            case 255: {
                byte[] head = new byte[]{-96, 0, 0};
                this.sendResponsePacket(head, null);
                break;
            }
            default: {
                this.sendPacket(PACKET_NOT_IMPLEMENTED, this.getConnectionID(), null, true);
            }
        }
        return true;
    }

    public void setConnectionID(long id) {
        try {
            this.connId = id;
            this.handler.setConnectionID(id);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public long getConnectionID() {
        try {
            long id = this.handler.getConnectionID();
            if (this.connId == id) {
                return -1L;
            }
            this.connId = id;
            return id;
        }
        catch (Throwable e) {
            return -1L;
        }
    }
}

