/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BCC;
import com.sun.kvem.jsr082.bluetooth.BluetoothConnection;
import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.JSR082Controller;
import com.sun.kvem.jsr082.impl.PermissionsHandler;
import com.sun.kvem.jsr082.impl.Utilites;
import com.sun.kvem.jsr082.impl.bluetooth.BTDeviceDiscoverer;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityListener;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityState;
import com.sun.midp.io.j2me.btl2cap.Protocol;
import java.io.IOException;
import java.util.Hashtable;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.microedition.io.Connection;

public final class BluetoothController
implements BCC {
    private static final String cn = "BluetoothController";
    private static final boolean DEBUG = false;
    private static final String BLUETOOTH_DEVICE_ADDRESS = "bluetooth.device.address";
    private static final String BLUETOOTH_DEVICE_FRIENDLY_NAME = "bluetooth.device.friendlyName";
    private static final String BLUETOOTH_DEVICE_RECORD = "bluetooth.device.classRecord";
    private static final String BLUETOOTH_DEVICE_DISCOVERABLE = "bluetooth.device.discoverable";
    private static final String BLUETOOTH_DEVICE_DISCOVERY_TIMEOUT = "bluetooth.device.discovery.timeout";
    private static final String BLUETOOTH_ENABLE = "bluetooth.enable";
    private static final String BLUETOOTH_DEVICE_DISCOVERY_ENABLE = "bluetooth.device.discovery.enable";
    private static final String BLUETOOTH_DEVICE_ENCRYPTION = "bluetooth.device.encryption";
    private static final String BLUETOOTH_DEVICE_AUTHORIZATION = "bluetooth.device.authorization";
    private static final String BLUETOOTH_DEVICE_AUTHENTCATION = "bluetooth.device.authentication";
    private static final String UNDEFINED_FRIENDLY_NAME = "-u-n-d-e-f-i-n-e-d-";
    private DiscoveryAgentImpl agent;
    private JSR082Controller finalizerObj;
    static final String COMMAND_DISCOVER_DEVICES = "discoverBTDevices";
    static final String COMMAND_GET_DEVICE_ATTRIBUTES = "getBTDeviceAttributes";
    private static final String COMMAND_REGISTER_BTDEVICE = "registerBTDevice";
    private static final String COMMAND_UPDATE_DEVICE_CLASS = "updateDeviceClass";
    private static final String COMMAND_GET_FRIENDLY_NAME = "getFriendlyName";
    private static final String COMMAND_REGISTER_L2CAP_NOTIFIER = "registerBTL2CAPNotifier";
    private static final String COMMAND_UNREGISTER_L2CAP_NOTIFIER = "unregisterBTL2CAPNotifier";
    private static final String COMMAND_GET_L2CAP_NOTIFIER_PORT = "getBTL2CAPNotifierPort";
    private static final String COMMAND_SET_BTDEVICE_ACCESS_CODE = "setBTDeviceAccessCode";
    private static final String COMMAND_REGISTER_SPP_NOTIFIER = "registerBTSPPNotifier";
    private static final String COMMAND_UNREGISTER_SPP_NOTIFIER = "unregisterBTSPPNotifier";
    private static final String COMMAND_GET_SPP_NOTIFIER_PORT = "getBTSPPNotifierPort";
    private static final String COMMAND_REGISTER_SECURITY_LISTENER = "registerSecurityListener";
    private static final String COMMAND_GET_SECURITY_LISTENER_PORT = "getSecurityListenerPort";
    private static BluetoothController instance;
    private static final byte[] pinCode;
    private static final int DEFAULT_DEVICE_CLASS = 516;
    private static boolean isInitialized;
    private String bluetoothAddress;
    private String friendlyName;
    private int baseDeviceClass;
    private int deviceClass;
    private DeviceClass deviceClassObj;
    private int discoverable;
    private int discoveryTimeout;
    private Hashtable ldProperties = new Hashtable();
    private BTDeviceDiscoverer deviceDiscoverer;
    private boolean bluetoothEnable = true;
    private boolean discoveringEnable = true;
    boolean forceNoEncrypt = false;
    boolean forceEncrypt = false;
    boolean forceAuthenticate = false;
    boolean forceAuthorize = false;
    static /* synthetic */ Class class$com$sun$kvem$jsr082$impl$bluetooth$BluetoothController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothController() {
        Class clazz = class$com$sun$kvem$jsr082$impl$bluetooth$BluetoothController == null ? (class$com$sun$kvem$jsr082$impl$bluetooth$BluetoothController = BluetoothController.class$("com.sun.kvem.jsr082.impl.bluetooth.BluetoothController")) : class$com$sun$kvem$jsr082$impl$bluetooth$BluetoothController;
        synchronized (clazz) {
            if (instance != null) {
                throw new RuntimeException("BluetoothController is created already.");
            }
            instance = this;
        }
        this.deviceDiscoverer = new BTDeviceDiscoverer();
    }

    static BluetoothController getInstance() {
        if (instance == null || !isInitialized) {
            throw new RuntimeException("Not initialized...");
        }
        return instance;
    }

    public void registerBTL2CAPNotifier(int psm, int port) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_REGISTER_L2CAP_NOTIFIER);
        args.append('\n').append(this.bluetoothAddress).append('\n');
        args.append(Integer.toString(psm)).append('\n');
        args.append(Integer.toString(port)).append('\n');
        JSR082Controller.processCommand(2, args.toString());
    }

    public void unregisterBTL2CAPNotifier(int port) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_UNREGISTER_L2CAP_NOTIFIER);
        args.append('\n').append(this.bluetoothAddress).append('\n');
        args.append(Integer.toString(port)).append('\n');
        JSR082Controller.processCommand(2, args.toString());
    }

    public int getBTL2CAPNotifierPort(String btaddress, int psm) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_GET_L2CAP_NOTIFIER_PORT);
        args.append('\n').append(btaddress).append('\n');
        args.append(Integer.toString(psm)).append('\n');
        String res = JSR082Controller.processCommand(2, args.toString());
        if (res == null) {
            throw new IOException("Can't connect");
        }
        int port = 0;
        try {
            port = Integer.parseInt(res);
        }
        catch (NumberFormatException e) {
            System.err.println("Internal error: wrong tcp port format: " + res);
            throw new IOException("Can't connect");
        }
        return port;
    }

    public boolean isDeviceConnectable() {
        return true;
    }

    public boolean setBTDeviceAccessCode(int accessCode) throws BluetoothStateException {
        if (!this.discoveringEnable) {
            return false;
        }
        StringBuffer args = new StringBuffer(COMMAND_SET_BTDEVICE_ACCESS_CODE);
        args.append('\n').append(this.bluetoothAddress).append('\n');
        args.append(Integer.toString(accessCode)).append('\n');
        try {
            JSR082Controller.processCommand(2, args.toString());
        }
        catch (IOException e) {
            return false;
        }
        this.discoverable = accessCode;
        return true;
    }

    public void registerBTSPPNotifier(int channel, int port) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_REGISTER_SPP_NOTIFIER);
        args.append('\n').append(this.bluetoothAddress).append('\n');
        args.append(Integer.toString(channel)).append('\n');
        args.append(Integer.toString(port)).append('\n');
        JSR082Controller.processCommand(2, args.toString());
    }

    public void unregisterBTSPPNotifier(int port) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_UNREGISTER_SPP_NOTIFIER);
        args.append('\n').append(this.bluetoothAddress).append('\n');
        args.append(Integer.toString(port)).append('\n');
        JSR082Controller.processCommand(2, args.toString());
    }

    public int getBTSPPNotifierPort(String btaddress, int channel) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_GET_SPP_NOTIFIER_PORT);
        args.append('\n').append(btaddress).append('\n');
        args.append(Integer.toString(channel)).append('\n');
        String res = JSR082Controller.processCommand(2, args.toString());
        if (res == null) {
            throw new IOException("Can't connect");
        }
        int port = 0;
        try {
            port = Integer.parseInt(res);
        }
        catch (NumberFormatException e) {
            System.err.println("Internal error: wrong tcp port format: " + res);
            throw new IOException("Can't connect");
        }
        return port;
    }

    public void registerSecurityListener(int port) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_REGISTER_SECURITY_LISTENER);
        args.append('\n').append(this.bluetoothAddress).append('\n');
        args.append(Integer.toString(port)).append('\n');
        JSR082Controller.processCommand(2, args.toString());
    }

    public int getSecurityListenerPort(String btaddress) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_GET_SECURITY_LISTENER_PORT);
        args.append('\n').append(btaddress).append('\n');
        String res = JSR082Controller.processCommand(2, args.toString());
        if (res == null) {
            throw new IOException("Can't connect");
        }
        int port = 0;
        try {
            port = Integer.parseInt(res);
        }
        catch (NumberFormatException e) {
            System.err.println("Internal error: wrong tcp port format: " + res);
            throw new IOException("Can't connect");
        }
        return port;
    }

    public void startInquiry(DiscoveryAgentImpl agent, DiscoveryListener listener, int accessCode) {
        this.deviceDiscoverer.startDiscover(agent, listener, accessCode);
    }

    public void cancelInquiry() {
        this.deviceDiscoverer.cancelDiscover();
    }

    public synchronized void initialize() throws Exception {
        if (isInitialized) {
            throw new RuntimeException("BluetoothController is initialized already.");
        }
        try {
            String propsStr = JSR082Controller.getDeviceInfo(2, 17);
            Hashtable propsTable = new Hashtable();
            Utilites.parseInfo(propsStr, propsTable);
            this.extractFromProperties(propsTable);
            if (!this.bluetoothEnable) {
                throw new Exception("Bluetooth disabled");
            }
            propsStr = JSR082Controller.getDeviceInfo(2, 18);
            Utilites.parseInfo(propsStr, this.ldProperties);
            this.checkSystemProperties();
            this.registerBTDevice();
            this.updateDeviceClass(0);
            this.deviceDiscoverer.initialize(this.discoveryTimeout);
            this.finalizerObj = JSR082Controller.getInstance();
            SecurityListener.start(this);
        }
        catch (Throwable e) {
            throw new Exception(e.getMessage());
        }
        isInitialized = true;
    }

    public String getBluetoothAddress() {
        return this.bluetoothAddress;
    }

    public String getFriendlyName() {
        return this.friendlyName.equals(UNDEFINED_FRIENDLY_NAME) ? null : this.friendlyName;
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClassObj;
    }

    public void updateDeviceClass(int serviceSummaryClass) {
        this.deviceClass = this.baseDeviceClass | serviceSummaryClass;
        this.deviceClassObj = new DeviceClass(this.deviceClass);
        StringBuffer args = new StringBuffer(COMMAND_UPDATE_DEVICE_CLASS);
        args.append('\n').append(this.bluetoothAddress).append('\n');
        args.append(Integer.toString(this.deviceClass)).append('\n');
        try {
            JSR082Controller.processCommand(2, args.toString());
        }
        catch (IOException e) {
            String msg = "JSR082 engine is unreachable.";
            System.err.println("JSR082 engine is unreachable.");
            throw new RuntimeException("JSR082 engine is unreachable.");
        }
    }

    public String getFriendlyName(RemoteDeviceImpl rd) throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_GET_FRIENDLY_NAME);
        args.append('\n').append(rd.getBluetoothAddress()).append('\n');
        String res = JSR082Controller.processCommand(2, args.toString());
        if (res == null) {
            throw new IOException("device is not available");
        }
        if (res.equals(UNDEFINED_FRIENDLY_NAME)) {
            res = "";
        }
        return res;
    }

    public int getDiscoverable() {
        return this.discoverable;
    }

    public Hashtable getProperties() {
        return this.ldProperties;
    }

    public boolean isTrustedDevice(RemoteDeviceImpl remoteDevice) {
        return false;
    }

    public boolean authorize(RemoteDeviceImpl remoteDevice, BluetoothConnection conn) {
        PermissionsHandler ph = new PermissionsHandler();
        String friendlyName = null;
        try {
            friendlyName = remoteDevice.getFriendlyName(false);
        }
        catch (IOException e) {
            // empty catch block
        }
        String name = remoteDevice.getBluetoothAddress();
        if (friendlyName != null) {
            name = friendlyName + "(" + name + ")";
        }
        try {
            ph.checkForPermission(null, 35, name);
        }
        catch (Throwable ie) {
            return false;
        }
        return true;
    }

    public boolean authenticate(RemoteDeviceImpl remoteDevice) throws IOException {
        SecurityState state = SecurityState.getSecurityState(remoteDevice);
        return state.authenticate();
    }

    public boolean encrypt(RemoteDeviceImpl remoteDevice, BluetoothConnection btconn, boolean enable) throws IOException {
        SecurityState state = SecurityState.getSecurityState(remoteDevice);
        return state.encrypt(btconn, enable);
    }

    public boolean isEncrypted(RemoteDeviceImpl remoteDevice) {
        SecurityState state = SecurityState.getSecurityState(remoteDevice);
        return state.isEncrypted();
    }

    public boolean isAuthenticated(RemoteDeviceImpl remoteDevice) {
        SecurityState state = SecurityState.getSecurityState(remoteDevice);
        return state.isAuthenticated();
    }

    byte[] getDevicePinCode() {
        return pinCode;
    }

    DiscoveryAgentImpl getDiscoveryAgent() {
        return this.agent;
    }

    public void setDiscoveryAgent(DiscoveryAgentImpl agent) {
        this.agent = agent;
    }

    public Connection getL2CAPConnection(String name) throws IOException {
        Protocol protocol = new Protocol();
        return protocol.openPrim(this, name, 3, false);
    }

    private void registerBTDevice() throws IOException {
        StringBuffer args = new StringBuffer(COMMAND_REGISTER_BTDEVICE);
        args.append('\n').append(this.bluetoothAddress).append('\n');
        args.append(Integer.toString(this.deviceClass)).append('\n');
        args.append(this.friendlyName).append('\n');
        String res = JSR082Controller.processCommand(2, args.toString());
        if (res == null) {
            throw new IOException("null server respose");
        }
        if (res.equals("OK")) {
            return;
        }
        if (!Utilites.checkBluetoothAddress(res)) {
            throw new RuntimeException("Internal error: unexpected address response: " + res);
        }
        this.bluetoothAddress = res;
    }

    private void extractFromProperties(Hashtable props) {
        this.bluetoothAddress = (String)props.get(BLUETOOTH_DEVICE_ADDRESS);
        this.friendlyName = (String)props.get(BLUETOOTH_DEVICE_FRIENDLY_NAME);
        this.baseDeviceClass = Utilites.getIntProperty(cn, props, BLUETOOTH_DEVICE_RECORD, 16, 516);
        this.deviceClassObj = new DeviceClass(this.baseDeviceClass);
        this.discoverable = Utilites.getIntProperty(cn, props, BLUETOOTH_DEVICE_DISCOVERABLE, 16, 0);
        this.discoveryTimeout = Utilites.getIntProperty(cn, props, BLUETOOTH_DEVICE_DISCOVERY_TIMEOUT, 10000);
        this.bluetoothEnable = Utilites.getBooleanProperty(cn, props, BLUETOOTH_ENABLE, true);
        this.discoveringEnable = Utilites.getBooleanProperty(cn, props, BLUETOOTH_DEVICE_DISCOVERY_ENABLE, true);
        String encryptionStateStr = (String)props.get(BLUETOOTH_DEVICE_ENCRYPTION);
        if (encryptionStateStr == null) {
            System.err.println("BluetoothController: Internal error: Can't get property: bluetooth.device.encryption");
        } else if (encryptionStateStr.equals("off")) {
            this.forceNoEncrypt = true;
            this.forceEncrypt = false;
        } else if (encryptionStateStr.equals("on")) {
            this.forceNoEncrypt = false;
            this.forceEncrypt = false;
        } else if (encryptionStateStr.equals("force")) {
            this.forceNoEncrypt = false;
            this.forceEncrypt = true;
        } else {
            System.err.println("BluetoothController: Internal error: wrong value: bluetooth.device.encryption=" + encryptionStateStr);
        }
        String authenticationStateStr = (String)props.get(BLUETOOTH_DEVICE_AUTHENTCATION);
        if (authenticationStateStr == null) {
            System.err.println("BluetoothController: Internal error: Can't get property: bluetooth.device.authentication");
        } else if (authenticationStateStr.equals("on")) {
            this.forceAuthenticate = false;
        } else if (authenticationStateStr.equals("force")) {
            this.forceAuthenticate = true;
        } else {
            System.err.println("BluetoothController: Internal error: wrong value: bluetooth.device.encryption=" + encryptionStateStr);
        }
        String authorizationStateStr = (String)props.get(BLUETOOTH_DEVICE_AUTHORIZATION);
        if (authorizationStateStr == null) {
            System.err.println("BluetoothController: Internal error: Can't get property: bluetooth.device.authorization");
        } else if (authorizationStateStr.equals("on")) {
            this.forceAuthorize = false;
        } else if (authorizationStateStr.equals("force")) {
            this.forceAuthorize = true;
        } else {
            System.err.println("BluetoothController: Internal error: wrong value: bluetooth.device.encryption=" + encryptionStateStr);
        }
    }

    private void checkSystemProperties() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        pinCode = new byte[]{1, 2, 3, 4, 5, 6};
    }
}

