/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.jsr082.bluetooth.BluetoothConnection;
import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BTHandlerBase;
import com.sun.kvem.jsr082.impl.bluetooth.BTNotifierBase;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityListener;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityState;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import java.io.IOException;
import javax.bluetooth.BluetoothConnectionException;

public abstract class BTConnectionBase
extends BTHandlerBase
implements BluetoothConnection {
    private static final boolean DEBUG = false;
    private RemoteDeviceImpl remoteDevice;
    private SecurityState securityState;
    private boolean isAuthorized;
    private boolean isEncrypted;
    private boolean isServerSide;
    private boolean isFinished;
    protected JSR082Connection conn;

    protected BTConnectionBase() {
    }

    public RemoteDeviceImpl getRemoteDevice() throws IOException {
        if (this.isFinished) {
            throw new IOException("connection closed");
        }
        if (this.remoteDevice == null) {
            throw new IllegalArgumentException("is notifier");
        }
        return this.remoteDevice;
    }

    public boolean isAuthorized() {
        return this.isAuthorized;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isServerSide() {
        return this.isServerSide;
    }

    public void setEncrypted(boolean on) {
        this.isEncrypted = on;
    }

    public void setAuthorized() {
        this.isAuthorized = true;
    }

    protected void waitSecurityExchange() {
        this.securityState.waitSecurityExchange();
    }

    void setRemoteAddress(String remoteAddress) {
        DiscoveryAgentImpl agent = this.control.getDiscoveryAgent();
        this.remoteDevice = agent.getRemoteDevice(remoteAddress);
        this.securityState = SecurityState.getSecurityState(this.remoteDevice);
        this.securityState.addConnection(this);
    }

    protected void initClientConnection(JSR082Connection conn, int mode, boolean master, boolean authenticate, boolean encrypt) throws BluetoothConnectionException, IOException {
        this.conn = conn;
        this.mode = mode;
        SecurityListener.writeBTAddress(conn, this.control.getBluetoothAddress());
        boolean success = true;
        int error = 0;
        byte[] buf = new byte[1];
        conn.read(buf);
        if (buf[0] != 0) {
            success = false;
            error = buf[0];
        }
        if (success && master) {
            error = 4;
            success = this.securityState.requestMaster();
        }
        if ((authenticate || this.control.forceAuthenticate) && success) {
            error = 2;
            success = this.remoteDevice.authenticate();
        }
        if ((encrypt || this.control.forceEncrypt) && success) {
            error = 3;
            success = this.remoteDevice.encrypt(this, encrypt);
        }
        buf[0] = success ? (byte)0 : (byte)error;
        conn.write(buf);
        if (!success) {
            this.securityState.removeConnection(this);
            throw new BluetoothConnectionException(2, this.getErrorMessage(error));
        }
    }

    protected void initServerConnection(JSR082Connection conn, BTNotifierBase parent, int mode, boolean master, boolean authorize, boolean authenticate, boolean encrypt) throws BluetoothConnectionException, IOException {
        this.conn = conn;
        this.mode = mode;
        this.isServerSide = true;
        String remoteAddress = SecurityListener.readBTAddress(conn);
        this.setRemoteAddress(remoteAddress);
        int error = 0;
        boolean success = true;
        byte[] buf = new byte[1];
        if (master) {
            error = 4;
            success = this.securityState.requestMaster();
        }
        if ((authorize || this.control.forceAuthorize) && success) {
            error = 1;
            success = this.remoteDevice.authorize(this);
            authenticate = true;
        }
        if ((authenticate || this.control.forceAuthenticate) && success) {
            error = 2;
            success = this.remoteDevice.authenticate();
        }
        if ((encrypt || this.control.forceEncrypt) && success) {
            error = 3;
            success = this.remoteDevice.encrypt(this, true);
        }
        buf[0] = success ? (byte)0 : (byte)error;
        conn.write(buf);
        conn.read(buf);
        if (success && buf[0] != 0) {
            error = buf[0];
            success = false;
        }
        if (!success) {
            this.securityState.removeConnection(this);
            throw new BluetoothConnectionException(2, this.getErrorMessage(error));
        }
    }

    protected final void finish() throws IOException {
        this.securityState.encrypt(this, false);
        this.securityState.removeConnection(this);
        this.isFinished = true;
        this.conn.close();
    }

    private final String getErrorMessage(int code) {
        switch (code) {
            case 1: {
                return "not authorized";
            }
            case 2: {
                return "not authenticated";
            }
            case 3: {
                return "not encrypted";
            }
            case 4: {
                return "unable to switch master";
            }
        }
        return null;
    }

    protected abstract int clientConnectionGetTransportPort(String var1, int var2) throws IOException;
}

