/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.SDPClient;
import com.sun.kvem.jsr082.bluetooth.ServiceRecordImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceSearcherBase;
import java.io.IOException;
import javax.bluetooth.DataElement;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

class ServiceSelector
extends ServiceSearcherBase {
    private static final boolean DEBUG = false;
    private static final String cn = "ServiceSelector";
    private DataElement[] attrValues = null;
    private IOException ioExcpt = null;

    ServiceSelector(int[] attrSet, UUID[] uuidSet, RemoteDevice btDev) {
        super(attrSet, uuidSet, btDev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorResponse(int errorCode, String info, int transactionID) {
        ServiceSelector serviceSelector = this;
        synchronized (serviceSelector) {
            this.ioExcpt = new IOException(info);
            this.notify();
        }
    }

    public void serviceSearchResponse(int[] handleList, int transactionID) {
        throw new RuntimeException("unexpected call");
    }

    public void serviceAttributeResponse(int[] attrIDs, DataElement[] attributeValues, int transactionID) {
        throw new RuntimeException("unexpected call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchAttributeResponse(int[] attrIDs, DataElement[] attributeValues, int transactionID) {
        ServiceSelector serviceSelector = this;
        synchronized (serviceSelector) {
            this.attrSet = attrIDs;
            this.attrValues = attributeValues;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRecord getServiceRecord() {
        SDPClient sdp = null;
        short transactionID = SDPClient.newTransactionID();
        try {
            sdp = new SDPClient(this.btDev.getBluetoothAddress());
            if (sdp != null) {
                sdp.serviceSearchAttributeRequest(this.attrSet, this.uuidSet, transactionID, this);
            }
        }
        catch (IOException ioe) {
            this.ioExcpt = ioe;
        }
        ServiceSelector ioe = this;
        synchronized (ioe) {
            if (this.ioExcpt == null && this.attrValues == null && sdp != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        SDPClient.freeTransactionID(transactionID);
        try {
            if (sdp != null) {
                sdp.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.ioExcpt != null) {
            return null;
        }
        if (this.attrValues == null) {
            return null;
        }
        if (this.attrValues.length == 0) {
            return null;
        }
        return new ServiceRecordImpl(this.btDev, this.attrSet, this.attrValues);
    }
}

