/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.ServiceSelector;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

final class SelectServiceHandler
implements DiscoveryListener {
    private static final boolean DEBUG = false;
    private Vector btDevs;
    private Hashtable btDevsHash;
    private Object btDevsLock = new Object();
    private boolean selectDevDisStarted;
    private boolean selectDevDisStopped;
    private DiscoveryAgentImpl agent;

    SelectServiceHandler(DiscoveryAgentImpl agent) {
        this.agent = agent;
    }

    public void deviceDiscovered(RemoteDevice btDevice, DeviceClass cod) {
        if (this.btDevsHash.put(btDevice, btDevice) == null) {
            this.btDevs.addElement(btDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        Object object = this.btDevsLock;
        synchronized (object) {
            this.selectDevDisStopped = true;
            this.btDevsLock.notify();
        }
    }

    public void servicesDiscovered(int transID, ServiceRecord[] servRecord) {
        throw new RuntimeException("unexpected call");
    }

    public void serviceSearchCompleted(int transID, int respCode) {
        throw new RuntimeException("unexpected call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String selectService(UUID uuid, int security, boolean master) throws BluetoothStateException {
        Vector disDevsVector = null;
        Hashtable disDevsHash = new Hashtable();
        if (uuid == null) {
            throw new NullPointerException("uuid is null");
        }
        String url = this.selectFromDevicesList(this.agent.retrieveDevices(1), uuid, security, master, disDevsHash);
        if (url != null) {
            return url;
        }
        url = this.selectFromDevicesList(this.agent.retrieveDevices(0), uuid, security, master, disDevsHash);
        if (url != null) {
            return url;
        }
        Object object = this.btDevsLock;
        synchronized (object) {
            if (this.selectDevDisStarted) {
                throw new BluetoothStateException("The previous device discovery is running...");
            }
            this.selectDevDisStarted = true;
            this.btDevs = new Vector();
            this.btDevsHash = disDevsHash;
        }
        try {
            this.agent.startInquiry(10390323, this);
        }
        catch (BluetoothStateException btse) {
            Object object2 = this.btDevsLock;
            synchronized (object2) {
                this.selectDevDisStarted = false;
                this.btDevs = null;
                this.btDevsHash = null;
            }
            throw btse;
        }
        Object btse = this.btDevsLock;
        synchronized (btse) {
            if (!this.selectDevDisStopped) {
                try {
                    this.btDevsLock.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                disDevsVector = this.btDevs;
                this.btDevs = null;
                this.btDevsHash = null;
                this.selectDevDisStarted = false;
                this.selectDevDisStopped = false;
            }
        }
        for (int i = 0; i < disDevsVector.size(); ++i) {
            RemoteDevice btDev = (RemoteDevice)disDevsVector.elementAt(i);
            url = this.selectService(btDev, uuid, security, master);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private String selectFromDevicesList(RemoteDevice[] devs, UUID uuid, int security, boolean master, Hashtable disDevsHash) {
        if (devs == null) {
            return null;
        }
        for (int i = 0; i < devs.length; ++i) {
            String url;
            if (disDevsHash.put(devs[i], devs[i]) != null || (url = this.selectService(devs[i], uuid, security, master)) == null) continue;
            return url;
        }
        return null;
    }

    private String selectService(RemoteDevice btDev, UUID uuid, int security, boolean master) {
        UUID[] uuidSet = new UUID[]{uuid};
        ServiceSelector selector = new ServiceSelector(null, uuidSet, btDev);
        ServiceRecord serRec = selector.getServiceRecord();
        if (serRec == null) {
            return null;
        }
        return serRec.getConnectionURL(security, master);
    }
}

