/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.bluetooth;

import java.io.IOException;
import java.util.Enumeration;
import javax.bluetooth.DataElement;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.UUID;

class DataL2CAPReaderWriter {
    private static final byte NULL_DATA = 0;
    private static final byte BOOLEAN_DATA = 40;
    private static final byte INT1_SIGNED = 16;
    private static final byte INT2_SIGNED = 17;
    private static final byte INT4_SIGNED = 18;
    private static final byte INT8_SIGNED = 19;
    private static final byte INT16_SIGNED = 20;
    private static final byte INT1_UNSIGNED = 8;
    private static final byte INT2_UNSIGNED = 9;
    private static final byte INT4_UNSIGNED = 10;
    private static final byte INT8_UNSIGNED = 11;
    private static final byte INT16_UNSIGNED = 12;
    private static final byte UUID_2 = 25;
    private static final byte UUID_4 = 26;
    private static final byte UUID_16 = 28;
    private static final byte TYPE_MASK = -8;
    private static final byte SIZE_MASK = 7;
    private static final byte SEQUENCE_TYPE = 48;
    private static final byte ALTERNATIVE_TYPE = 56;
    private static final byte STRING_TYPE = 64;
    private static final byte SHORT_SIZE = 5;
    private static final byte NORMAL_SIZE = 6;
    private static final byte LONG_SIZE = 7;
    private L2CAPConnection con = null;
    private byte[] writeBuffer = null;
    private long writePos = 0L;
    private byte[] readBuffer = null;
    private long readSize = 0L;
    private long readPos = 0L;

    DataL2CAPReaderWriter(L2CAPConnection con) throws IOException {
        this.con = con;
        this.writeBuffer = new byte[con.getTransmitMTU()];
        this.readBuffer = new byte[con.getReceiveMTU()];
    }

    long getDataSize(DataElement data) {
        int type = data.getDataType();
        long size = this.getPureDataSize(data);
        if (type == 0 || type == 40 || type == 16 || type == 8 || type == 17 || type == 9 || type == 18 || type == 10 || type == 19 || type == 11 || type == 20 || type == 12) {
            return size + 1L;
        }
        if (type == 48 || type == 56 || type == 32 || type == 64 || type == 24) {
            if (size <= 255L) {
                return size + 2L;
            }
            if (size <= 65535L) {
                return size + 3L;
            }
            if (size <= 0xFFFFFFFFL) {
                return size + 5L;
            }
            throw new RuntimeException("Unexpected too large size.");
        }
        throw new RuntimeException("Unexpected Data Type");
    }

    long getPureDataSize(DataElement data) {
        switch (data.getDataType()) {
            case 0: {
                return 0L;
            }
            case 8: 
            case 16: 
            case 40: {
                return 1L;
            }
            case 9: 
            case 17: {
                return 2L;
            }
            case 10: 
            case 18: {
                return 4L;
            }
            case 11: 
            case 19: {
                return 8L;
            }
            case 12: 
            case 20: {
                return 16L;
            }
            case 48: 
            case 56: {
                long size = 0L;
                Enumeration elements = (Enumeration)data.getValue();
                while (elements.hasMoreElements()) {
                    size += this.getDataSize((DataElement)elements.nextElement());
                }
                return size;
            }
            case 32: 
            case 64: {
                return ((String)data.getValue()).length();
            }
            case 24: {
                return ((UUID)data.getValue()).toString().length();
            }
        }
        throw new RuntimeException("Unexpected Data Type");
    }

    void writeDataElement(DataElement data) throws IOException {
        long size = this.getPureDataSize(data);
        int type = data.getDataType();
        int typeBits = 0;
        if (type == 0 || type == 40 || type == 16 || type == 8 || type == 17 || type == 9 || type == 18 || type == 10 || type == 19 || type == 11 || type == 20 || type == 12) {
            switch (type) {
                case 0: {
                    this.writeByte(0L);
                    break;
                }
                case 40: {
                    this.writeByte(40L);
                    this.writeBoolean(data.getBoolean());
                    break;
                }
                case 16: {
                    this.writeByte(16L);
                    this.writeByte((byte)data.getLong());
                    break;
                }
                case 8: {
                    this.writeByte(8L);
                    this.writeByte((byte)data.getLong());
                    break;
                }
                case 17: {
                    this.writeByte(17L);
                    this.writeShort((short)data.getLong());
                    break;
                }
                case 9: {
                    this.writeByte(9L);
                    this.writeShort((short)data.getLong());
                    break;
                }
                case 18: {
                    this.writeByte(18L);
                    this.writeInteger((int)data.getLong());
                    break;
                }
                case 10: {
                    this.writeByte(10L);
                    this.writeInteger((int)data.getLong());
                    break;
                }
                case 19: {
                    this.writeByte(19L);
                    this.writeLong(data.getLong());
                    break;
                }
                case 11: {
                    this.writeByte(11L);
                    this.writeBytes((byte[])data.getValue());
                    break;
                }
                case 20: {
                    this.writeByte(20L);
                    this.writeBytes((byte[])data.getValue());
                    break;
                }
                case 12: {
                    this.writeByte(12L);
                    this.writeBytes((byte[])data.getValue());
                }
            }
        } else if (type == 48 || type == 56 || type == 32 || type == 64) {
            switch (type) {
                case 48: {
                    typeBits = 48;
                    break;
                }
                case 56: {
                    typeBits = 56;
                    break;
                }
                case 32: 
                case 64: {
                    typeBits = 64;
                    break;
                }
            }
            if (size <= 255L) {
                this.writeByte(typeBits | 5);
                this.writeByte((byte)size);
            } else if (size <= 65535L) {
                this.writeByte(typeBits | 6);
                this.writeShort((short)size);
            } else {
                this.writeByte(typeBits | 7);
                this.writeInteger((int)size);
            }
            if (type == 48 || type == 56) {
                Enumeration elements = (Enumeration)data.getValue();
                while (elements.hasMoreElements()) {
                    this.writeDataElement((DataElement)elements.nextElement());
                }
            } else {
                this.writeBytes(((String)data.getValue()).getBytes());
            }
        } else if (type == 24) {
            this.writeByte(28L);
            this.writeByte(size);
            this.writeBytes(data.getValue().toString().getBytes());
        } else {
            throw new RuntimeException("Unexpected Data Type");
        }
    }

    void writeBoolean(boolean data) throws IOException {
        this.writeByte(data ? 1L : 0L);
    }

    void writeByte(long data) throws IOException {
        if (this.writePos < 0L || this.writePos >= (long)this.writeBuffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.writeBuffer[(int)this.writePos] = (byte)data;
        ++this.writePos;
        if (this.writePos == (long)this.writeBuffer.length) {
            this.con.send(this.writeBuffer);
            this.writePos = 0L;
        }
    }

    void writeShort(short data) throws IOException {
        this.writeByte((byte)(data >>> 8 & 0xFF));
        this.writeByte((byte)(data >>> 0 & 0xFF));
    }

    void writeInteger(int data) throws IOException {
        this.writeShort((short)(data >>> 16 & 0xFFFF));
        this.writeShort((short)(data >>> 0 & 0xFFFF));
    }

    void writeLong(long data) throws IOException {
        this.writeInteger((int)(data >>> 32 & 0xFFFFFFFFFFFFFFFFL));
        this.writeInteger((int)(data >>> 0 & 0xFFFFFFFFFFFFFFFFL));
    }

    void writeBytes(byte[] data) throws IOException {
        int length;
        if (this.writePos < 0L || this.writePos >= (long)this.writeBuffer.length) {
            throw new IndexOutOfBoundsException();
        }
        int dataPos = 0;
        while ((long)(data.length - dataPos) >= (long)this.writeBuffer.length - this.writePos) {
            length = this.writeBuffer.length - (int)this.writePos;
            System.arraycopy(data, dataPos, this.writeBuffer, (int)this.writePos, length);
            this.con.send(this.writeBuffer);
            this.writePos = 0L;
            dataPos += length;
        }
        length = data.length - dataPos;
        if (length > 0) {
            System.arraycopy(data, dataPos, this.writeBuffer, (int)this.writePos, length);
        }
        this.writePos += (long)length;
    }

    void flush() throws IOException {
        if (this.writePos < 0L || this.writePos >= (long)this.writeBuffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.writePos == 0L) {
            return;
        }
        byte[] tempBuffer = new byte[(int)this.writePos];
        System.arraycopy(this.writeBuffer, 0, tempBuffer, 0, (int)this.writePos);
        this.con.send(tempBuffer);
        this.writePos = 0L;
    }

    DataElement readDataElement() throws IOException {
        byte header = this.readByte();
        if (header == 0 || header == 40 || header == 16 || header == 8 || header == 17 || header == 9 || header == 18 || header == 10 || header == 19 || header == 11 || header == 20 || header == 12) {
            switch (header) {
                case 0: {
                    return new DataElement(0);
                }
                case 40: {
                    return new DataElement(this.readBoolean());
                }
                case 16: {
                    return new DataElement(16, (long)this.readByte());
                }
                case 8: {
                    return new DataElement(8, (long)this.readByte() & 0xFFL);
                }
                case 17: {
                    return new DataElement(17, (long)this.readShort());
                }
                case 9: {
                    return new DataElement(9, (long)this.readShort() & 0xFFFFL);
                }
                case 18: {
                    return new DataElement(18, (long)this.readInteger());
                }
                case 10: {
                    return new DataElement(10, (long)this.readInteger() & 0xFFFFFFFFL);
                }
                case 19: {
                    return new DataElement(19, this.readLong());
                }
                case 11: {
                    return new DataElement(11, (Object)this.readBytes(8));
                }
                case 20: {
                    return new DataElement(20, (Object)this.readBytes(16));
                }
                case 12: {
                    return new DataElement(12, (Object)this.readBytes(16));
                }
            }
        } else {
            if ((header & 0xFFFFFFF8) == 64 || (header & 0xFFFFFFF8) == 48 || (header & 0xFFFFFFF8) == 56) {
                long size = 0L;
                if ((header & 7) == 5) {
                    size = (long)this.readByte() & 0xFFL;
                } else if ((header & 7) == 6) {
                    size = (long)this.readShort() & 0xFFFFL;
                } else if ((header & 7) == 7) {
                    size = (long)this.readInteger() & 0xFFFFFFFFL;
                } else {
                    System.err.println("Unknown Size Mask");
                }
                if ((header & 0xFFFFFFF8) == 64) {
                    return new DataElement(32, (Object)new String(this.readBytes((int)size)));
                }
                DataElement data = null;
                DataElement dataElement = null;
                data = (header & 0xFFFFFFF8) == 48 ? new DataElement(48) : new DataElement(56);
                for (long dataPos = 0L; dataPos < size; dataPos += this.getDataSize(dataElement)) {
                    dataElement = this.readDataElement();
                    data.addElement(dataElement);
                }
                return data;
            }
            if (header == 28) {
                int size = this.readByte() & 0xFF;
                String uuidString = new String(this.readBytes(size));
                UUID uuid = new UUID(uuidString, false);
                return new DataElement(24, (Object)uuid);
            }
            throw new RuntimeException("Unknown Data Type");
        }
        return null;
    }

    boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    byte readByte() throws IOException {
        if (this.readPos == 0L || this.readPos == this.readSize) {
            this.readSize = this.con.receive(this.readBuffer);
            this.readPos = 0L;
        } else if (this.readPos < 0L || this.readPos > this.readSize) {
            throw new IndexOutOfBoundsException();
        }
        byte data = this.readBuffer[(int)this.readPos];
        ++this.readPos;
        return data;
    }

    short readShort() throws IOException {
        int data1 = this.readByte() & 0xFF;
        int data2 = this.readByte() & 0xFF;
        return (short)((data1 << 8) + (data2 << 0));
    }

    int readInteger() throws IOException {
        int data1 = this.readShort() & 0xFFFF;
        int data2 = this.readShort() & 0xFFFF;
        return (data1 << 16) + (data2 << 0);
    }

    long readLong() throws IOException {
        long data1 = (long)this.readInteger() & 0xFFFFFFFFL;
        long data2 = (long)this.readInteger() & 0xFFFFFFFFL;
        return (data1 << 32) + (data2 << 0);
    }

    byte[] readBytes(int size) throws IOException {
        int length;
        byte[] data = new byte[size];
        int dataPos = 0;
        if (this.readPos == 0L || this.readPos == this.readSize) {
            this.readSize = this.con.receive(this.readBuffer);
            this.readPos = 0L;
        } else if (this.readPos < 0L || this.readPos > this.readSize) {
            throw new IndexOutOfBoundsException();
        }
        while ((long)(data.length - dataPos) > this.readSize - this.readPos) {
            length = (int)(this.readSize - this.readPos);
            System.arraycopy(this.readBuffer, (int)this.readPos, data, dataPos, length);
            this.readSize = this.con.receive(this.readBuffer);
            this.readPos = 0L;
        }
        length = data.length - dataPos;
        System.arraycopy(this.readBuffer, (int)this.readPos, data, dataPos, length);
        this.readPos += (long)length;
        return data;
    }
}

