/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.Text;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Screen;

public abstract class Item {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_TOP = 16;
    public static final int LAYOUT_BOTTOM = 32;
    public static final int LAYOUT_VCENTER = 48;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    public static final int LAYOUT_SHRINK = 1024;
    public static final int LAYOUT_EXPAND = 2048;
    public static final int LAYOUT_VSHRINK = 4096;
    public static final int LAYOUT_VEXPAND = 8192;
    public static final int LAYOUT_2 = 16384;
    public static final int PLAIN = 0;
    public static final int HYPERLINK = 1;
    public static final int BUTTON = 2;
    static final int X = 0;
    static final int Y = 1;
    static final int WIDTH = 2;
    static final int HEIGHT = 3;
    static final int VALID_LAYOUT;
    int[] bounds;
    boolean hasFocus;
    boolean visible;
    boolean sizeChanged;
    ItemCommandListener commandListener;
    String label;
    Screen owner;
    int layout;
    Command defaultCommand;
    int numCommands;
    int lockedWidth = -1;
    int lockedHeight = -1;
    static final boolean LABEL_BOLD_ON_TRAVERSE = false;
    static final int BUTTON_PAD = 2;
    static final int BUTTON_BORDER = 3;
    static final int LIGHT_GRAY_COLOR = 0xAFAFAF;
    static final int DARK_GRAY_COLOR = 0x606060;
    static final Font LABEL_FONT;
    static final int LABEL_PAD = 2;
    static final int LABEL_HEIGHT;
    static final int DEFAULT_WIDTH;
    private Command[] commands;
    private int lastRequestedLabelW = 0;
    private int lastLabelWidth = 0;
    private int lastLabelHeight = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Item(String label) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.label = label;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.label = label;
            this.lastLabelHeight = 0;
            this.lastLabelWidth = 0;
            this.invalidate();
        }
    }

    public String getLabel() {
        return this.label;
    }

    public int getLayout() {
        return this.layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayout(int layout) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setLayoutImpl(layout);
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command cmd) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.addCommandImpl(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command cmd) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.removeCommandImpl(cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItemCommandListener(ItemCommandListener l) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setItemCommandListenerImpl(l);
        }
    }

    void setItemCommandListenerImpl(ItemCommandListener l) {
        this.commandListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferredWidth() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.lockedWidth != -1 ? this.lockedWidth : this.callPreferredWidth(this.lockedHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPreferredHeight() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.lockedHeight != -1 ? this.lockedHeight : this.callPreferredHeight(this.lockedWidth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredSize(int width, int height) {
        if (width < -1 || height < -1) {
            throw new IllegalArgumentException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.owner != null && this.owner instanceof Alert) {
                throw new IllegalStateException();
            }
            int minWidth = this.getMinimumWidth();
            int minHeight = this.getMinimumHeight();
            this.lockedWidth = width != -1 && width < minWidth ? minWidth : width;
            int n = this.lockedHeight = height != -1 && height < minHeight ? minHeight : height;
            if (this.visible && (this.lockedWidth != this.bounds[2] || this.lockedHeight != this.bounds[3])) {
                this.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumWidth() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.callMinimumWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMinimumHeight() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            return this.callMinimumHeight();
        }
    }

    public void setDefaultCommand(Command cmd) {
        if (cmd != null) {
            this.addCommand(cmd);
        }
        this.defaultCommand = cmd;
    }

    public void notifyStateChanged() {
        Screen owner = this.owner;
        if (owner == null || !(owner instanceof Form)) {
            throw new IllegalStateException();
        }
        owner.itemStateChanged(this);
    }

    void commitPendingInteraction() {
    }

    int getLabelHeight(int w) {
        if (this.label == null || this.label.length() == 0) {
            return 0;
        }
        if (w == -1) {
            w = DEFAULT_WIDTH;
        }
        if (this.lastRequestedLabelW != w || this.lastLabelHeight == 0) {
            this.lastRequestedLabelW = w;
            this.lastLabelHeight = Text.getHeightForWidth(this.label, LABEL_FONT, w, 0);
        }
        return this.lastLabelHeight;
    }

    int getLabelWidth() {
        if (this.label == null || this.label.length() == 0) {
            return 0;
        }
        if (this.lastLabelWidth == 0) {
            this.lastLabelWidth = Text.getWidestLineWidth(this.label.toCharArray(), 0, DEFAULT_WIDTH, LABEL_FONT);
        }
        return this.lastLabelWidth;
    }

    abstract int callPreferredWidth(int var1);

    abstract int callPreferredHeight(int var1);

    abstract int callMinimumWidth();

    abstract int callMinimumHeight();

    boolean shouldHShrink() {
        return (this.layout & 0x400) == 1024;
    }

    boolean shouldHExpand() {
        return (this.layout & 0x800) == 2048;
    }

    boolean shouldVShrink() {
        return (this.layout & 0x1000) == 4096;
    }

    boolean shouldVExpand() {
        return (this.layout & 0x2000) == 8192;
    }

    boolean equateNLA() {
        return (this.layout & 0x200) == 512;
    }

    boolean equateNLB() {
        return (this.layout & 0x100) == 256;
    }

    boolean shouldSkipTraverse() {
        return false;
    }

    abstract void callPaint(Graphics var1, int var2, int var3);

    void repaint() {
        if (this.bounds != null) {
            this.repaint(0, 0, this.bounds[2], this.bounds[3]);
        }
    }

    void repaint(int x, int y, int w, int h) {
        if (this.owner != null) {
            if (x < 0) {
                x = 0;
            } else if (x > this.bounds[2]) {
                return;
            }
            if (y < 0) {
                y = 0;
            } else if (y > this.bounds[3]) {
                return;
            }
            if (w < 0) {
                w = 0;
            } else if (w > this.bounds[2]) {
                w = this.bounds[2];
            }
            if (h < 0) {
                h = 0;
            } else if (h > this.bounds[3]) {
                h = this.bounds[3];
            }
            this.owner.repaintItem(this, x, y, w, h);
        }
    }

    int paintLabel(Graphics g, int width) {
        int labelHeight = this.getLabelHeight(width);
        Text.paint(this.label, LABEL_FONT, g, width, labelHeight, 0, 0, null);
        return labelHeight;
    }

    void callSizeChanged(int w, int h) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidate() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.owner != null) {
                this.owner.invalidate(this);
            }
        }
    }

    boolean callTraverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        this.hasFocus = true;
        return false;
    }

    void callTraverseOut() {
        this.hasFocus = false;
    }

    void callKeyPressed(int keyCode) {
    }

    void callKeyTyped(char c) {
    }

    void callKeyReleased(int keyCode) {
    }

    void callKeyRepeated(int keyCode) {
    }

    void callPointerPressed(int x, int y) {
    }

    void callPointerReleased(int x, int y) {
    }

    void callPointerDragged(int x, int y) {
    }

    void callShowNotify() {
        this.visible = true;
    }

    void callHideNotify() {
        this.visible = false;
    }

    void drawButtonBorder(Graphics g, int x, int y, int w, int h, boolean hasFocus) {
        g.setColor(hasFocus ? 0x606060 : 0xAFAFAF);
        g.fillRect(x, y, w, 3);
        g.fillRect(x, y, 3, h);
        g.setColor(hasFocus ? 0xAFAFAF : 0x606060);
        g.fillTriangle(x, y + h, x + 3, y + h - 3, x + 3, y + h);
        g.fillRect(x + 3, y + h - 3, w - 3, 3);
        g.fillTriangle(x + w, y, x + w - 3, y + 3, x + w, y + 3);
        g.fillRect(x + w - 3, y + 3, 3, h - 3);
        g.setColor(Display.FG_COLOR);
    }

    void addCommandImpl(Command cmd) {
        if (cmd == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.numCommands; ++i) {
            if (this.commands[i] != cmd) continue;
            return;
        }
        if (this.commands == null || this.numCommands == this.commands.length) {
            Command[] newCommands = new Command[this.numCommands + 4];
            if (this.commands != null) {
                System.arraycopy(this.commands, 0, newCommands, 0, this.numCommands);
            }
            this.commands = newCommands;
        }
        this.commands[this.numCommands] = cmd;
        ++this.numCommands;
        if (this.owner != null) {
            this.owner.updateCommandSet();
        }
    }

    void removeCommandImpl(Command cmd) {
        for (int i = 0; i < this.numCommands; ++i) {
            if (this.commands[i] != cmd) continue;
            this.commands[i] = this.commands[--this.numCommands];
            this.commands[this.numCommands] = null;
            if (cmd == this.defaultCommand) {
                this.defaultCommand = null;
            }
            if (this.owner == null) break;
            this.owner.updateCommandSet();
            break;
        }
    }

    Command[] getCommands() {
        return this.commands;
    }

    int getCommandCount() {
        return this.numCommands;
    }

    ItemCommandListener getItemCommandListener() {
        return this.commandListener;
    }

    final Screen getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOwner(Screen owner) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.owner != null && owner != null) {
                throw new IllegalStateException();
            }
            this.owner = owner;
        }
    }

    void setLayoutImpl(int layout) {
        if ((layout & ~VALID_LAYOUT) != 0) {
            throw new IllegalArgumentException();
        }
        this.layout = layout;
    }

    int callGetLayout() {
        int l = this.layout;
        if (l == 0) {
            return 17;
        }
        return l;
    }

    static {
        LABEL_FONT = Font.getFont(Screen.CONTENT_FONT.getFace(), 1, Screen.CONTENT_FONT.getSize());
        LABEL_HEIGHT = LABEL_FONT.getHeight() + 2;
        DEFAULT_WIDTH = Display.WIDTH - 4 - 4;
        VALID_LAYOUT = 32563;
    }
}

