/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.kvem.DeviceConfiguration;
import com.sun.midp.io.j2me.socket.Protocol;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.ImplicitlyTrustedClass;
import com.sun.midp.security.SecurityToken;
import com.sun.mmedia.EvtQLocal;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import javax.microedition.media.control.FramePositioningControl;
import javax.microedition.media.control.GUIControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.StopTimeControl;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.media.protocol.DataSource;
import javax.microedition.media.protocol.SourceStream;

public class VideoPlayer2
implements Player,
TimeBase,
StopTimeControl,
RateControl,
Runnable,
ImplicitlyTrustedClass {
    private static int pcount = -1;
    private static Hashtable mplayers = new Hashtable(4);
    private static Object idLock = new Object();
    private static int REALIZING = 150;
    Object syncObject = new Object();
    protected static final String pkgName = "javax.microedition.media.control.";
    protected static final String fpcName = "FramePositioningControl";
    protected static final String mdcName = "MetaDataControl";
    protected static final String micName = "MIDIControl";
    protected static final String picName = "PitchControl";
    protected static final String racName = "RateControl";
    protected static final String recName = "RecordControl";
    protected static final String stcName = "StopTimeControl";
    protected static final String tecName = "TempoControl";
    protected static final String tocName = "ToneControl";
    protected static final String guiName = "GUIControl";
    protected static final String vicName = "VideoControl";
    protected static final String vocName = "VolumeControl";
    private static final String[] allCtrls = new String[]{"FramePositioningControl", "MetaDataControl", "MIDIControl", "PitchControl", "RateControl", "RecordControl", "StopTimeControl", "TempoControl", "ToneControl", "GUIControl", "VideoControl", "VolumeControl"};
    protected DataSource source;
    protected SourceStream stream;
    private TimeBase timeBase = this;
    protected int state = 100;
    boolean EOM = false;
    boolean loopAfterEOM = false;
    int loopCountSet = 1;
    int loopCount;
    protected Vector listeners = new Vector(2);
    protected long stopTime = Long.MAX_VALUE;
    EvtQLocal evtQ = null;
    Object evtLock = new Object();
    protected int pID = 0;
    private static boolean mmapiEnabled;
    static boolean Debug;
    private long origin = 0L;
    private long offset = 0L;
    private long time = 0L;
    private long sysOffset = 0L;
    private boolean useSystemTime = true;
    static Object mmc;
    private String contentType;
    private long contentLength;
    public static final boolean DEBUG = true;
    private long duration = -1L;
    private boolean interrupted;
    private Thread eventThread;
    private boolean started;
    private static int bufferSize;
    private static byte[] buffer;
    private static Object realizeLock;
    private int instance;
    private long socket = 0L;
    private boolean IS_LINUX = DeviceConfiguration.getProperty("com.sun.kvem.midp.MIDP.OS_NAME").indexOf("Linux") != -1;
    private boolean IS_SUNOS = DeviceConfiguration.getProperty("com.sun.kvem.midp.MIDP.OS_NAME").indexOf("SunOS") != -1;
    private static int SCREEN_WIDTH;
    private static int SCREEN_HEIGHT;
    private static int SCREEN_OFFSET_X;
    private static int SCREEN_OFFSET_Y;
    private static int CANVAS_HEIGHT;
    private static int DISPLAY_WIDTH;
    private static int DISPLAY_HEIGHT;
    private static final int END_OF_MEDIA = -1;
    private static final int STOPPED_AT_TIME = -2;
    private static final int ERROR = -3;
    private Protocol sc;
    private DataOutputStream dos;
    private DataInputStream eventDis;
    private MMItem mmItem = null;
    int videoWidth;
    int videoHeight;
    int dw;
    int dh;
    int dx;
    int dy;
    int sw;
    int sh;
    final int JPEG_FORMAT;
    final int PNG_FORMAT;
    private boolean abort = false;
    private boolean fsmode;
    private boolean visible = false;
    private static SecurityToken classSecurityToken;
    private VolumeControl volumeControl;
    private VideoControl videoControl;
    private FramePositioningControl framePositionControl;
    private StopTimeControl stopTimeControl;

    private static native void nNoSuchMethod();

    public void setSource(DataSource source) throws IOException, MediaException {
        this.source = source;
    }

    protected void chkClosed(boolean unrealized) {
        if (this.state == 0 || unrealized && this.state == 100) {
            throw new IllegalStateException("Can't invoke the method at the " + (this.state == 0 ? "closed" : "unrealized") + " state");
        }
    }

    public void setLoopCount(int count) {
        this.chkClosed(false);
        if (this.state == 400) {
            throw new IllegalStateException("setLoopCount");
        }
        if (count == 0 || count < -1) {
            throw new IllegalArgumentException("setLoopCount");
        }
        this.loopCountSet = count;
        this.loopCount = count;
    }

    public void setTimeBase(TimeBase master) throws MediaException {
        if (!mmapiEnabled) {
            VideoPlayer2.noSuchMethod("setTimeBase()");
        }
        this.chkClosed(true);
        if (this.state == 400) {
            throw new IllegalStateException("Cannot call setTimeBase on a player in the STARTED state");
        }
        if (master == null) {
            return;
        }
        if (master != this) {
            throw new MediaException("Incompatible TimeBase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void realize() throws MediaException {
        this.chkClosed(false);
        Object object = this.syncObject;
        synchronized (object) {
            if (this.state >= 200) {
                return;
            }
            this.state = REALIZING;
            if (this.source != null && this.stream == null) {
                this.stream = this.source.getStreams()[0];
            }
            if (this.source != null && this.stream == null) {
                this.stream = this.source.getStreams()[0];
            }
        }
        try {
            this.doRealize();
        }
        catch (MediaException e) {
            this.state = 100;
            throw e;
        }
        if (this.state == REALIZING) {
            this.state = 200;
        }
    }

    public synchronized void prefetch() throws MediaException {
        this.chkClosed(false);
        if (this.state >= 300) {
            return;
        }
        if (this.state < 200) {
            this.realize();
        }
        this.doPrefetch();
        this.state = 300;
    }

    public synchronized void start() throws MediaException {
        this.chkClosed(false);
        if (this.state >= 400) {
            return;
        }
        if (this.state < 200) {
            this.realize();
        }
        if (this.state < 300) {
            this.prefetch();
        }
        if (this.EOM) {
            this.setMediaTime(0L);
        }
        this.updateTimeBase(true);
        if (this.stopTime != Long.MAX_VALUE && this.stopTime <= this.getMediaTime()) {
            this.satev();
            return;
        }
        if (!this.doStart()) {
            throw new MediaException("start");
        }
        this.state = 400;
        this.sendEvent("started", new Long(this.getMediaTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws MediaException {
        this.chkClosed(false);
        if (this.state < 400) {
            return;
        }
        this.loopAfterEOM = false;
        VideoPlayer2 videoPlayer2 = this;
        synchronized (videoPlayer2) {
            this.doStop();
            this.updateTimeBase(false);
            this.state = 300;
            this.sendEvent("stopped", new Long(this.getMediaTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate() {
        this.loopAfterEOM = false;
        if (this.state == REALIZING) {
            this.state = 100;
            Object object = this.syncObject;
            synchronized (object) {
                this.doAbortRealize();
                if (this.stream == null || this.stream.getSeekType() == 0) {
                    this.closeStream();
                } else {
                    try {
                        this.stream.seek(0L);
                    }
                    catch (IOException e) {
                        this.closeStream();
                    }
                }
            }
            return;
        }
        VideoPlayer2 videoPlayer2 = this;
        synchronized (videoPlayer2) {
            this.chkClosed(false);
            if (this.state <= 200) {
                return;
            }
            if (this.state == 400) {
                try {
                    this.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
            }
            this.doDeallocate();
            this.state = 200;
        }
    }

    private void closeStream() {
        if (this.source != null) {
            this.source.disconnect();
        }
        this.stream = null;
        this.source = null;
    }

    public void close() {
        if (this.state == 0) {
            return;
        }
        this.deallocate();
        this.doClose();
        this.state = 0;
        if (this.source != null) {
            this.source.disconnect();
        }
        this.sendEvent("closed", null);
        mplayers.remove(new Integer(this.pID));
    }

    public synchronized long setMediaTime(long now) throws MediaException {
        long theDur;
        this.chkClosed(true);
        if (now < 0L) {
            now = 0L;
        }
        if ((theDur = this.doGetDuration()) != -1L && now > theDur) {
            now = theDur;
        }
        long rtn = this.doSetMediaTime(now);
        this.EOM = false;
        return rtn;
    }

    public long getMediaTime() {
        this.chkClosed(false);
        return this.doGetMediaTime();
    }

    public TimeBase getTimeBase() {
        if (!mmapiEnabled) {
            VideoPlayer2.noSuchMethod("getTimeBase()");
        }
        this.chkClosed(true);
        return this.timeBase;
    }

    public int getState() {
        int currentState = this.state;
        if (currentState != REALIZING) {
            return currentState;
        }
        return 100;
    }

    public String getContentType() {
        this.chkClosed(true);
        return this.source != null ? this.source.getContentType() : "";
    }

    public long getDuration() {
        this.chkClosed(false);
        return this.doGetDuration();
    }

    public void addPlayerListener(PlayerListener playerListener) {
        this.chkClosed(false);
        if (playerListener != null) {
            this.listeners.addElement(playerListener);
        }
    }

    public void removePlayerListener(PlayerListener playerListener) {
        this.chkClosed(false);
        this.listeners.removeElement(playerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(String evt, Object evtData) {
        if (this.listeners.size() == 0 && evt != "endOfMedia") {
            return;
        }
        Object object = this.evtLock;
        synchronized (object) {
            if (this.evtQ == null) {
                this.evtQ = new EvtQLocal(this);
            }
            this.evtQ.sendEvent(evt, evtData);
        }
    }

    synchronized void doLoop() {
        if (this.loopCount > 1 || this.loopCount == -1) {
            try {
                if (this.loopCount > 1) {
                    --this.loopCount;
                }
                this.start();
            }
            catch (MediaException ex) {
                this.loopCount = 1;
            }
        } else if (this.loopCountSet > 1) {
            this.loopCount = this.loopCountSet;
        }
        this.loopAfterEOM = false;
    }

    public final Control[] getControls() {
        this.chkClosed(true);
        Vector<Control> v = new Vector<Control>(3);
        for (int i = 0; i < allCtrls.length; ++i) {
            Control c = this.getControl(allCtrls[i]);
            if (c == null || v.contains(c)) continue;
            v.addElement(c);
        }
        Object[] ret = new Control[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public Control getControl(String type) {
        this.chkClosed(true);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (type.indexOf(46) < 0) {
            return this.doGetControl(pkgName + type);
        }
        return this.doGetControl(type);
    }

    private static void noSuchMethod(String m) {
        System.err.println("ALERT: No such method " + m);
        VideoPlayer2.nNoSuchMethod();
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public synchronized void setStopTime(long time) {
        if (this.state == 400) {
            if (this.stopTime != Long.MAX_VALUE && time != Long.MAX_VALUE) {
                throw new IllegalStateException("StopTime already set");
            }
            if (time < this.getMediaTime()) {
                try {
                    this.doStop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.satev();
                return;
            }
        }
        this.stopTime = time;
        this.doSetStopTime(this.stopTime);
    }

    protected void satev() {
        this.updateTimeBase(false);
        this.state = 300;
        this.stopTime = Long.MAX_VALUE;
        this.sendEvent("stoppedAtTime", new Long(this.getMediaTime()));
    }

    public static VideoPlayer2 get(int pid) {
        return (VideoPlayer2)mplayers.get(new Integer(pid));
    }

    int doSetLevel(int ll) {
        return ll;
    }

    protected void readFully(byte[] b, int off, int len) throws IOException, MediaException {
        int count;
        for (int n = 0; n < len; n += count) {
            count = this.stream.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new MediaException("premature end of stream");
        }
    }

    protected void skipFully(int numBytes) throws IOException, MediaException {
        long target = this.stream.tell() + (long)numBytes;
        if (this.stream.getSeekType() == 2) {
            if (this.stream.seek(target) != target) {
                throw new MediaException("skipped past end");
            }
            return;
        }
        if (numBytes < 0) {
            throw new MediaException("bad param");
        }
        byte[] temp = new byte[numBytes];
        if (this.stream.read(temp, 0, numBytes) < numBytes) {
            throw new MediaException("skipped past end");
        }
    }

    public synchronized long getTime() {
        this.time = this.useSystemTime ? this.origin + (System.currentTimeMillis() * 1000L - this.sysOffset) - this.offset : this.origin + this.getMediaTime() - this.offset;
        return this.time;
    }

    public synchronized void updateTimeBase(boolean started) {
        this.origin = this.getTime();
        this.useSystemTime = !started;
        this.offset = started ? this.getMediaTime() : System.currentTimeMillis() * 1000L - this.sysOffset;
    }

    public static void setMMCreator(Object m) {
        if (mmc == null) {
            mmc = m;
        }
    }

    private native int nOpen(int var1, String var2, long var3, int var5);

    private native boolean nInit(int var1);

    private native boolean nRealize(int var1);

    private native boolean nPrefetch(int var1);

    private native boolean nStart(int var1);

    private native boolean nStop(int var1);

    private native boolean nDeallocate(int var1);

    private native boolean nClose(int var1, long var2);

    private native int nGetEvent(long var1);

    private native void nSetMute(int var1, boolean var2);

    private native boolean nIsMuted(int var1);

    private native int nSetLevel(int var1, int var2);

    private native int nGetLevel(int var1);

    private native int nGetPort();

    private native boolean nInitDisplayMode(int var1, int var2, String var3);

    private native void nSetVisible(int var1, boolean var2);

    private native int nGetWidth(int var1);

    private native int nGetHeight(int var1);

    private native int nSetBounds(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private native int nGetSnapshot(int var1, int var2, int var3, int var4, byte[] var5);

    private native int nGetScreenWidth();

    private native int nGetScreenHeight();

    private native int nGetScreenOffsetX();

    private native int nGetScreenOffsetY();

    private native int nGetDisplayWidth();

    private native int nGetDisplayHeight();

    private native int nSetMediaTimeMilliSeconds(int var1, long var2);

    private native int nGetMediaTimeMilliSeconds(int var1);

    private native int nSeek(int var1, int var2);

    private native int nSkip(int var1, int var2);

    private native int nMapFrameToTimeMilliSec(int var1, int var2);

    private native int nMapTimeToFrame(int var1, long var2);

    private native int nGetDurationMilliSeconds(int var1);

    private native void nSetStopTime(int var1, long var2);

    private native int nGetStopTimeMilliSec(int var1);

    private native int nSetRate(int var1, int var2);

    private native int nGetRate(int var1);

    private native int nGetMaxRate(int var1);

    private native int nGetMinRate(int var1);

    public final void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public VideoPlayer2() {
        this.JPEG_FORMAT = 0;
        this.PNG_FORMAT = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoPlayer2(String contentType) {
        this.JPEG_FORMAT = 0;
        this.PNG_FORMAT = 1;
        if (SCREEN_WIDTH == -1) {
            SCREEN_WIDTH = this.nGetScreenWidth();
            SCREEN_HEIGHT = this.nGetScreenHeight();
            SCREEN_OFFSET_X = this.nGetScreenOffsetX();
            SCREEN_OFFSET_Y = this.nGetScreenOffsetY();
            CANVAS_HEIGHT = SCREEN_HEIGHT;
            DISPLAY_WIDTH = this.nGetDisplayWidth();
            DISPLAY_HEIGHT = this.nGetDisplayHeight();
        }
        this.sysOffset = System.currentTimeMillis() * 1000L;
        Object object = idLock;
        synchronized (object) {
            this.pID = pcount = (pcount + 1) % Short.MAX_VALUE;
        }
        mplayers.put(new Integer(this.pID), this);
        this.contentType = contentType;
        this.instance = this.hashCode();
    }

    private void abortRealize() throws MediaException {
        Object object = this.syncObject;
        synchronized (object) {
            this.doClose();
            this.abort = false;
            throw new MediaException("realize aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRealize() throws MediaException {
        Object object = realizeLock;
        synchronized (object) {
            Object object2 = this.syncObject;
            synchronized (object2) {
                if (this.abort) {
                    this.abortRealize();
                }
                this.contentLength = this.stream.getContentLength();
                if (this.contentLength == -1L) {
                    this.contentLength = Long.MAX_VALUE;
                }
            }
            int port = this.nOpen(this.instance, this.contentType, this.contentLength, bufferSize);
            if (this.abort) {
                this.abortRealize();
            }
            if (port > 0) {
                try {
                    this.sc = new Protocol();
                    this.sc.openPrim(classSecurityToken, "//127.0.0.1:" + port, 3, false);
                    this.sc.setSocketOption((byte)0, 1);
                    this.dos = new DataOutputStream(this.sc.openOutputStream());
                    this.eventDis = new DataInputStream(this.sc.openInputStream());
                }
                catch (Exception e) {
                    throw new MediaException("Unable to open socket connection");
                }
            } else {
                throw new MediaException("Unable to open socket connection");
            }
            if (this.abort) {
                this.abortRealize();
            }
            if (!this.nInit(this.instance)) {
                throw new MediaException("Unable to realize");
            }
            if (this.abort) {
                this.abortRealize();
            }
            try {
                this.source.start();
            }
            catch (Exception ex) {
                throw new MediaException(ex.getMessage());
            }
            if (buffer == null) {
                buffer = new byte[bufferSize];
            }
            int offset = 0;
            try {
                int actualRead;
                for (long remaining = this.contentLength; remaining > 0L; remaining -= (long)actualRead) {
                    int toRead = remaining >= (long)bufferSize ? bufferSize : (int)remaining;
                    Object object3 = this.syncObject;
                    synchronized (object3) {
                        if (this.abort) {
                            this.abortRealize();
                        }
                        actualRead = this.stream.read(buffer, offset, toRead);
                    }
                    if (actualRead == -1) {
                        this.contentLength -= remaining;
                        this.dos.close();
                        break;
                    }
                    this.dos.write(buffer, 0, actualRead);
                }
            }
            catch (Exception e) {
                throw new MediaException("Unable to realize. error reading from DataSource");
            }
        }
        if (this.abort) {
            this.abortRealize();
        }
        if (!this.nRealize(this.instance)) {
            throw new MediaException("Unable to realize");
        }
        this.videoWidth = this.nGetWidth(this.instance);
        if (this.videoWidth != 0) {
            this.videoHeight = this.nGetHeight(this.instance);
        }
        if (this.eventThread == null) {
            this.eventThread = new Thread(this);
            this.eventThread.start();
        }
    }

    protected void doAbortRealize() {
        this.abort = true;
    }

    protected void doPrefetch() throws MediaException {
        if (!this.nPrefetch(this.instance)) {
            throw new MediaException("Unable to prefetch");
        }
    }

    protected boolean doStart() {
        if (this.started) {
            return true;
        }
        this.nStart(this.instance);
        this.started = true;
        if (this.IS_LINUX || this.IS_SUNOS) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
            }
        }
        return true;
    }

    private void sleep(int msec) {
        try {
            Thread.currentThread();
            Thread.sleep(msec);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        while (this.state != 0 && this.eventDis != null) {
            try {
                int event = this.eventDis.readInt();
                long mediaTime = this.eventDis.readLong();
                if (event >= 0 || mediaTime < 0L) continue;
                if (event == -1) {
                    this.started = false;
                    this.sendEvent("endOfMedia", new Long(mediaTime));
                    continue;
                }
                if (event == -2) {
                    this.started = false;
                    this.updateTimeBase(false);
                    this.state = 300;
                    this.stopTime = Long.MAX_VALUE;
                    this.sendEvent("stoppedAtTime", new Long(mediaTime));
                    continue;
                }
                if (event != -3) continue;
                this.sendEvent("error", "Error playing video");
            }
            catch (IOException e) {
                this.eventDis = null;
            }
            catch (Exception exception) {}
        }
        this.eventThread = null;
    }

    protected void doStop() throws MediaException {
        if (!this.started) {
            return;
        }
        this.nStop(this.instance);
        this.started = false;
    }

    protected void doDeallocate() {
        this.nDeallocate(this.instance);
    }

    protected void doClose() {
        this.mmItem = null;
        this.nClose(this.instance, this.socket);
        try {
            if (this.dos != null) {
                this.dos.close();
                this.dos = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.eventDis != null) {
                this.eventDis.close();
                this.eventDis = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.sc != null) {
                this.sc.close();
                this.sc = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected long doSetMediaTime(long now) throws MediaException {
        long mediaTime = (long)this.nSetMediaTimeMilliSeconds(this.instance, now) * 1000L;
        if (mediaTime < 0L) {
            throw new MediaException("Error setting media time");
        }
        return mediaTime;
    }

    protected long doGetMediaTime() {
        int mediaTime = this.nGetMediaTimeMilliSeconds(this.instance);
        if (mediaTime >= 0) {
            return (long)mediaTime * 1000L;
        }
        return -1L;
    }

    protected long doGetDuration() {
        int duration = this.nGetDurationMilliSeconds(this.instance);
        if (duration >= 0) {
            return (long)duration * 1000L;
        }
        return -1L;
    }

    protected Control doGetControl(String type) {
        if (type.equals("javax.microedition.media.control.StopTimeControl")) {
            return this;
        }
        if (type.equals("javax.microedition.media.control.RateControl")) {
            return this;
        }
        if (type.equals("javax.microedition.media.control.GUIControl")) {
            if (this.videoControl == null) {
                this.videoControl = new VidCtrl();
            }
            return this.videoControl;
        }
        if (type.equals("javax.microedition.media.control.VideoControl")) {
            if (this.videoControl == null) {
                this.videoControl = new VidCtrl();
            }
            return this.videoControl;
        }
        if (type.equals("javax.microedition.media.control.FramePositioningControl")) {
            if (this.framePositionControl == null) {
                this.framePositionControl = new FramePositioningCrl();
            }
            return this.framePositionControl;
        }
        if (type.equals("javax.microedition.media.control.VolumeControl")) {
            if (this.volumeControl == null) {
                this.volumeControl = new VolumeCtrl();
            }
            return this.volumeControl;
        }
        return null;
    }

    void sendSCE() {
        this.sendEvent("sizeChanged", this.videoControl);
    }

    public void doSetStopTime(long stopTime) {
        this.nSetStopTime(this.instance, stopTime);
    }

    public int setRate(int millirate) {
        return this.nSetRate(this.instance, millirate);
    }

    public int getRate() {
        return this.nGetRate(this.instance);
    }

    public int getMaxRate() {
        return this.nGetMaxRate(this.instance);
    }

    public int getMinRate() {
        return this.nGetMinRate(this.instance);
    }

    static {
        String s = Configuration.getPropertyDefault("mmapi_enabled", "true");
        mmapiEnabled = "true".equals(s);
        Debug = false;
        mmc = null;
        bufferSize = 64000;
        realizeLock = new Object();
        SCREEN_WIDTH = -1;
    }

    class FramePositioningCrl
    implements FramePositioningControl {
        FramePositioningCrl() {
        }

        public int seek(int frameNumber) {
            return VideoPlayer2.this.nSeek(VideoPlayer2.this.instance, frameNumber);
        }

        public int skip(int framesToSkip) {
            return VideoPlayer2.this.nSkip(VideoPlayer2.this.instance, framesToSkip);
        }

        public long mapFrameToTime(int frameNumber) {
            long time = -1L;
            if (frameNumber >= 0 && (time = (long)VideoPlayer2.this.nMapFrameToTimeMilliSec(VideoPlayer2.this.instance, frameNumber)) != -1L) {
                time *= 1000L;
            }
            return time;
        }

        public int mapTimeToFrame(long mediaTime) {
            if (mediaTime >= 0L) {
                return VideoPlayer2.this.nMapTimeToFrame(VideoPlayer2.this.instance, mediaTime);
            }
            return -1;
        }
    }

    class VidCtrl
    implements VideoControl {
        private Canvas canvas;
        private boolean closed;
        private int mode = -1;
        private boolean cvis;
        private boolean pvis;

        VidCtrl() {
            VideoPlayer2.this.sw = VideoPlayer2.this.videoWidth;
            VideoPlayer2.this.sh = VideoPlayer2.this.videoHeight;
            VideoPlayer2.this.dw = VideoPlayer2.this.sw;
            VideoPlayer2.this.dh = VideoPlayer2.this.sh;
            if (VideoPlayer2.this.dw > SCREEN_WIDTH) {
                VideoPlayer2.this.dw = SCREEN_WIDTH;
            }
            if (VideoPlayer2.this.dh > SCREEN_HEIGHT) {
                VideoPlayer2.this.dh = SCREEN_HEIGHT;
            }
        }

        public Object initDisplayMode(int mode, Object container) {
            if (this.mode != -1) {
                throw new IllegalStateException("mode already set");
            }
            if (mode != 1 && mode != 0) {
                throw new IllegalArgumentException("unsupported mode");
            }
            if (mode == 1 && !(container instanceof Canvas)) {
                throw new IllegalArgumentException("container needs to be a Canvas");
            }
            this.mode = mode;
            if (mode == 1) {
                this.canvas = (Canvas)container;
                VideoPlayer2.this.nInitDisplayMode(VideoPlayer2.this.instance, mode, "Canvas" + Integer.toHexString(container.hashCode()));
                this.setDisplayLocation(VideoPlayer2.this.dx, VideoPlayer2.this.dy);
                return container;
            }
            if (!(container == null || container instanceof String && container.equals("javax.microedition.lcdui.Item"))) {
                throw new IllegalArgumentException("container not valid");
            }
            VideoPlayer2.this.mmItem = new MMItem();
            VideoPlayer2.this.nInitDisplayMode(VideoPlayer2.this.instance, mode, ":" + Integer.toHexString(VideoPlayer2.this.mmItem.hashCode()));
            VideoPlayer2.this.nSetBounds(VideoPlayer2.this.instance, 0, 0, 0, 0, 0, 0, 0, 0);
            this.setVisible(true);
            return VideoPlayer2.this.mmItem;
        }

        public void setDisplayLocation(int x, int y) {
            this.checkState();
            if (this.mode == 1) {
                VideoPlayer2.this.dx = x;
                VideoPlayer2.this.dy = y;
                this.clipAndDraw(VideoPlayer2.this.dx, VideoPlayer2.this.dy, VideoPlayer2.this.dw, VideoPlayer2.this.dh);
            }
        }

        private void checkState() {
            if (this.mode == -1) {
                throw new IllegalStateException("initDisplayMode not called yet");
            }
        }

        private void checkPermission() {
            try {
                Scheduler scheduler = Scheduler.getScheduler();
                MIDletSuite midletSuite = scheduler.getMIDletSuite();
                midletSuite.checkForPermission(17, null);
            }
            catch (InterruptedException e) {
                throw new SecurityException("Interrupted while trying to ask the user permission");
            }
        }

        private void clipAndDraw(int dx, int dy, int dw, int dh) {
            int diff;
            int srcX = 0;
            int srcY = 0;
            int srcW = VideoPlayer2.this.sw;
            int srcH = VideoPlayer2.this.sh;
            int dstX = dx;
            int dstY = dy;
            int dstW = dw;
            int dstH = dh;
            if (dstX < 0) {
                srcX = -dstX * VideoPlayer2.this.sw / dw;
                srcW -= srcX;
                dstW += dstX;
                dstX = 0;
            }
            if (dstY < 0) {
                srcY = -dstY * VideoPlayer2.this.sh / dh;
                srcH -= srcY;
                dstH += dstY;
                dstY = 0;
            }
            if (dstX + dstW > SCREEN_WIDTH) {
                diff = dstW + dstX - SCREEN_WIDTH;
                srcW -= diff * VideoPlayer2.this.sw / dw;
                dstW -= diff;
            }
            if (dstY + dstH > CANVAS_HEIGHT) {
                diff = dstH + dstY - CANVAS_HEIGHT;
                srcH -= diff * VideoPlayer2.this.sh / dh;
                dstH -= diff;
            }
            if (!VideoPlayer2.this.fsmode) {
                VideoPlayer2.this.nSetBounds(VideoPlayer2.this.instance, srcX, srcY, srcW, srcH, dstX, dstY, dstW, dstH);
            }
        }

        public int getDisplayX() {
            return VideoPlayer2.this.dx;
        }

        public int getDisplayY() {
            return VideoPlayer2.this.dy;
        }

        public void setVisible(boolean v) {
            this.checkState();
            VideoPlayer2.this.visible = v;
            VideoPlayer2.this.nSetVisible(VideoPlayer2.this.instance, v);
            if (this.canvas != null) {
                this.canvas.repaint();
            }
        }

        public void setDisplaySize(int width, int height) throws MediaException {
            this.checkState();
            if (width < 1 || height < 1) {
                throw new IllegalArgumentException("Invalid size");
            }
            if (this.mode == 0 && width > SCREEN_WIDTH) {
                width = SCREEN_WIDTH;
            }
            if (VideoPlayer2.this.mmItem != null && !VideoPlayer2.this.fsmode) {
                VideoPlayer2.this.mmItem.mmRepaint();
            } else {
                this.setDisplayLocation(VideoPlayer2.this.dx, VideoPlayer2.this.dy);
            }
            boolean sizeChanged = false;
            if (VideoPlayer2.this.dw != width || VideoPlayer2.this.dh != height) {
                sizeChanged = true;
            }
            VideoPlayer2.this.dw = width;
            VideoPlayer2.this.dh = height;
            if (sizeChanged) {
                VideoPlayer2.this.sendSCE();
            }
        }

        public void setDisplayFullScreen(boolean fullScreenMode) throws MediaException {
            this.checkState();
            if (fullScreenMode) {
                throw new MediaException("No fullscreen mode");
            }
        }

        public int getDisplayWidth() {
            this.checkState();
            if (VideoPlayer2.this.fsmode) {
                return SCREEN_WIDTH;
            }
            return VideoPlayer2.this.dw;
        }

        public int getDisplayHeight() {
            this.checkState();
            if (VideoPlayer2.this.fsmode) {
                return SCREEN_HEIGHT;
            }
            return VideoPlayer2.this.dh;
        }

        public int getSourceWidth() {
            return VideoPlayer2.this.sw;
        }

        public int getSourceHeight() {
            return VideoPlayer2.this.sh;
        }

        public byte[] getSnapshot(String imageType) throws MediaException {
            int encodingFormat;
            byte[] snapshot;
            int len;
            this.checkState();
            this.checkPermission();
            int quality = 80;
            String encoding = "none";
            int reqWidth = VideoPlayer2.this.videoWidth;
            int reqHeight = VideoPlayer2.this.videoHeight;
            if (imageType == null) {
                encoding = "jpeg";
            } else {
                while (imageType.length() > 1) {
                    int i;
                    len = imageType.length();
                    for (i = 0; i < len && imageType.charAt(i) != '&'; ++i) {
                    }
                    if (i < 2) break;
                    String tok = imageType.substring(0, i);
                    if (tok.startsWith("encoding=")) {
                        encoding = tok.substring(9, tok.length());
                    } else {
                        reqWidth = this.tryParam(tok, "width=", reqWidth);
                        reqHeight = this.tryParam(tok, "height=", reqHeight);
                    }
                    if (i >= len - 1) break;
                    imageType = imageType.substring(i + 1);
                }
            }
            if (reqWidth != VideoPlayer2.this.videoWidth || reqHeight != VideoPlayer2.this.videoHeight || !encoding.equals("png") && !encoding.equals("jpeg")) {
                throw new MediaException("Invalid property");
            }
            if (encoding.equals("jpeg")) {
                snapshot = new byte[VideoPlayer2.this.videoWidth * VideoPlayer2.this.videoHeight * 4];
                encodingFormat = 0;
            } else {
                snapshot = new byte[63 + (VideoPlayer2.this.videoWidth * 3 + 6) * VideoPlayer2.this.videoHeight];
                encodingFormat = 1;
            }
            len = VideoPlayer2.this.nGetSnapshot(VideoPlayer2.this.instance, VideoPlayer2.this.videoWidth, VideoPlayer2.this.videoHeight, encodingFormat, snapshot);
            if (len > 0) {
                return snapshot;
            }
            return null;
        }

        private int tryParam(String tok, String prop, int def) {
            if (tok.startsWith(prop)) {
                tok = tok.substring(prop.length(), tok.length());
                try {
                    return Integer.parseInt(tok);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return def;
        }

        synchronized void close() {
            this.closed = true;
        }
    }

    class GUICtrl
    implements GUIControl {
        GUICtrl() {
        }

        public Object initDisplayMode(int mode, Object arg) {
            return VideoPlayer2.this.videoControl.initDisplayMode(mode, arg);
        }
    }

    class VolumeCtrl
    implements VolumeControl {
        VolumeCtrl() {
        }

        public void setMute(boolean mute) {
            VideoPlayer2.this.nSetMute(VideoPlayer2.this.instance, mute);
        }

        public boolean isMuted() {
            return VideoPlayer2.this.nIsMuted(VideoPlayer2.this.instance);
        }

        public int setLevel(int level) {
            if (level < 0) {
                level = 0;
            } else if (level > 100) {
                level = 100;
            }
            int currentLevel = this.getLevel();
            int newLevel = VideoPlayer2.this.nSetLevel(VideoPlayer2.this.instance, level);
            if (currentLevel != newLevel) {
                VideoPlayer2.this.sendEvent("volumeChanged", this);
            }
            return newLevel;
        }

        public int getLevel() {
            return VideoPlayer2.this.nGetLevel(VideoPlayer2.this.instance);
        }
    }

    class MMItem
    extends CustomItem {
        private int savedX;
        private int savedY;
        private int savedW;
        private int savedH;

        public MMItem() {
            super("");
        }

        void mmRepaint() {
            try {
                this.invalidate();
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void paint(Graphics g, int w, int h) {
            int tx = g.getTranslateX();
            int ty = g.getTranslateY();
            int cx = g.getClipX();
            int cy = g.getClipY();
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            int dstY = 0;
            int dstH = VideoPlayer2.this.dh;
            int srcX = 0;
            int srcY = 0;
            int srcW = VideoPlayer2.this.videoWidth;
            int srcH = VideoPlayer2.this.videoHeight;
            if (cy > VideoPlayer2.this.dh) {
                return;
            }
            if (-cy > ch) {
                return;
            }
            dstY = ty;
            if (cy > 0) {
                dstY += cy;
                if ((dstH -= cy) > ch) {
                    dstH = ch;
                }
                if (dstY + dstH > CANVAS_HEIGHT) {
                    dstH = CANVAS_HEIGHT - dstY;
                }
                srcY = VideoPlayer2.this.sh - dstH * VideoPlayer2.this.sh / VideoPlayer2.this.dh;
                srcH -= srcY;
            } else if (dstH > cy + ch) {
                dstH = cy + ch;
                if (dstY + dstH > CANVAS_HEIGHT) {
                    dstH = CANVAS_HEIGHT - dstY;
                }
                srcY = -(VideoPlayer2.this.sh - dstH * VideoPlayer2.this.sh / VideoPlayer2.this.dh);
                srcH += srcY;
                srcY = 0;
            }
            if (VideoPlayer2.this.dw > SCREEN_WIDTH) {
                VideoPlayer2.this.dw = SCREEN_WIDTH;
            }
            if (dstH == 0) {
                return;
            }
            if (dstY + dstH > CANVAS_HEIGHT) {
                dstH = CANVAS_HEIGHT - dstY;
            }
            if (!VideoPlayer2.this.fsmode) {
                VideoPlayer2.this.nSetBounds(VideoPlayer2.this.instance, srcX, srcY, srcW, srcH, tx, dstY, VideoPlayer2.this.dw, dstH);
            } else {
                VideoPlayer2.this.nSetBounds(VideoPlayer2.this.instance, 0, 0, VideoPlayer2.this.videoWidth, VideoPlayer2.this.videoHeight, 0, 0, DISPLAY_WIDTH, DISPLAY_HEIGHT);
            }
            VideoPlayer2.this.nSetVisible(VideoPlayer2.this.instance, VideoPlayer2.this.visible);
            if (tx != this.savedX || ty != this.savedY || w != this.savedW || h != this.savedH) {
                this.savedX = tx;
                this.savedY = ty;
                this.savedW = w;
                this.savedH = h;
                this.invalidate();
            }
        }

        protected int getMinContentWidth() {
            return 16;
        }

        protected int getMinContentHeight() {
            return 16;
        }

        protected int getPrefContentWidth(int h) {
            return VideoPlayer2.this.dw;
        }

        protected int getPrefContentHeight(int w) {
            return VideoPlayer2.this.dh;
        }

        protected void hideNotify() {
            VideoPlayer2.this.nSetVisible(VideoPlayer2.this.instance, false);
            VideoPlayer2.this.nSetBounds(VideoPlayer2.this.instance, 0, 0, 0, 0, 0, 0, 0, 0);
            super.hideNotify();
        }
    }
}

