/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.MMHelper;
import com.sun.mmedia.VidCtrlCanvasBuddy;
import com.sun.mmedia.VidCtrlPainter;
import com.sun.mmedia.protocol.LocatorParser;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.CustomItem;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.VideoControl;

public final class VidCtrl
implements VideoControl,
VidCtrlPainter {
    private MMItem mmItem;
    private Canvas canvas;
    private boolean fsmode;
    private boolean closed;
    private int mode = -1;
    private boolean cvis;
    private boolean pvis;
    private BasicPlayer player;
    private int dx;
    private int dy;
    private int dw;
    private int dh;
    private int sw;
    private int sh;
    private byte[] tempSnapData;
    private static final boolean TRACE_FRAMERATE = false;
    private int frameCount;
    private long frameStartTime = 0L;
    private static final String UNSUP_PARAMS = "Unsupported parameters";
    private static final int SNAP_JPEG = 1;
    private static final int SNAP_PNG = 2;
    private Object dispBoundsLock = new Object();
    public static final int RGB565 = 1;
    public static final int RGB888 = 2;
    public static final int XRGB888 = 3;
    public static final int XBGR888 = 4;
    public static final int RGBX888 = 5;
    public static final int YUV420_PLANAR = 6;
    public static final int YUV422_PLANAR = 7;
    public static final int YUYV = 8;
    public static final int UYVY = 9;
    public static final int YVYU = 10;
    public static final int NATIVE_RENDER = 128;
    public static final int USE_ALPHA = 256;
    int rgbMode;
    int pWidth;
    int pHeight;
    int[] rgbData;
    int[] scaledRGB;
    byte[] pngData;
    int pngDataLength;
    boolean nativeRender;
    boolean useAlpha;
    private Image image;
    private MMHelper mmh = null;

    VidCtrl(BasicPlayer player, int sourceWidth, int sourceHeight) {
        this.setSourceSize(sourceWidth, sourceHeight);
        this.player = player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSourceSize(int sourceWidth, int sourceHeight) {
        this.sw = sourceWidth;
        this.sh = sourceHeight;
        Object object = this.dispBoundsLock;
        synchronized (object) {
            this.dw = this.sw;
            this.dh = this.sh;
        }
    }

    public Object initDisplayMode(int mode, Object container) {
        if (this.mode != -1) {
            throw new IllegalStateException("mode already set");
        }
        if (mode != 1 && mode != 0) {
            throw new IllegalArgumentException("unsupported mode");
        }
        if (mode == 1 && !(container instanceof Canvas)) {
            throw new IllegalArgumentException("container needs to be a Canvas");
        }
        this.mode = mode;
        if (mode == 1) {
            this.canvas = (Canvas)container;
            if (this.mmh == null) {
                this.mmh = VidCtrlCanvasBuddy.getMMHelper();
                if (this.mmh == null) {
                    throw new RuntimeException("initDisplayMode: unable to set the display mode");
                }
            }
            this.setDisplayLocation(this.dx, this.dy);
            this.mmh.registerPlayer(this.canvas, this);
            return container;
        }
        if (!(container == null || container instanceof String && container.equals("javax.microedition.lcdui.Item"))) {
            throw new IllegalArgumentException("container not valid");
        }
        this.mmItem = new MMItem(this.sw, this.sh);
        this.setVisible(true);
        return this.mmItem;
    }

    public void setDisplayLocation(int x, int y) {
        this.checkState();
        if (this.mode == 1) {
            this.dx = x;
            this.dy = y;
            this.canvas.repaint();
        }
    }

    private void checkState() {
        if (this.mode == -1) {
            throw new IllegalStateException("initDisplayMode not called yet");
        }
    }

    private static void checkPermission() {
        try {
            Scheduler scheduler = Scheduler.getScheduler();
            MIDletSuite midletSuite = scheduler.getMIDletSuite();
            midletSuite.checkForPermission(17, null);
        }
        catch (InterruptedException e) {
            throw new SecurityException("Interrupted while trying to ask the user permission");
        }
    }

    public int getDisplayX() {
        return this.dx;
    }

    public int getDisplayY() {
        return this.dy;
    }

    public void setVisible(boolean visible) {
        this.checkState();
        this.pvis = visible;
        if (this.mmItem != null) {
            this.mmItem.forcePaint(null);
        } else if (this.canvas != null) {
            this.canvas.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplaySize(int width, int height) throws MediaException {
        this.checkState();
        boolean sizeChanged = false;
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Invalid size");
        }
        Object object = this.dispBoundsLock;
        synchronized (object) {
            if (this.dw != width || this.dh != height) {
                sizeChanged = true;
            }
            this.dw = width;
            this.dh = height;
        }
        if (this.mmItem != null && !this.fsmode) {
            this.mmItem.forcePaint(null);
        } else {
            this.setDisplayLocation(this.dx, this.dy);
        }
        if (sizeChanged) {
            this.player.sendEvent("sizeChanged", this);
        }
    }

    public void setDisplayFullScreen(boolean fullScreenMode) throws MediaException {
        this.checkState();
        if (fullScreenMode) {
            throw new MediaException("No Fullscreen mode");
        }
    }

    public int getDisplayWidth() {
        this.checkState();
        return this.dw;
    }

    public int getDisplayHeight() {
        this.checkState();
        return this.dh;
    }

    public int getSourceWidth() {
        return this.sw;
    }

    public int getSourceHeight() {
        return this.sh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSnapshot(String imageType) throws MediaException {
        this.checkState();
        VidCtrl.checkPermission();
        VidCtrl vidCtrl = this;
        synchronized (vidCtrl) {
            int quality;
            int encType;
            String enc;
            block34: {
                String value;
                String key;
                LocatorParser lp;
                boolean interlaced;
                boolean progressive;
                String colors;
                int height;
                int width;
                block35: {
                    block36: {
                        enc = "jpeg";
                        encType = 1;
                        width = this.sw;
                        height = this.sh;
                        quality = 100;
                        String video_type = null;
                        colors = "rgb888";
                        progressive = false;
                        interlaced = false;
                        if (imageType == null) break block34;
                        String imgTypeLC = imageType.toLowerCase();
                        lp = new LocatorParser(imgTypeLC);
                        key = lp.getParameter();
                        if (key != null) {
                            if (!key.equals("encoding")) {
                                throw new MediaException(UNSUP_PARAMS);
                            }
                            enc = lp.getValue();
                        }
                        if (!enc.equals("jpeg")) break block35;
                        video_type = "jfif";
                        quality = 80;
                        while ((key = lp.getParameter()) != null) {
                            value = lp.getValue();
                            try {
                                if (key.equals("width")) {
                                    width = Integer.parseInt(value);
                                    continue;
                                }
                                if (key.equals("height")) {
                                    height = Integer.parseInt(value);
                                    continue;
                                }
                                if (key.equals("type")) {
                                    video_type = value;
                                    continue;
                                }
                                if (key.equals("progressive")) {
                                    progressive = value.equals("true");
                                    continue;
                                }
                                if (key.equals("interlaced")) {
                                    interlaced = value.equals("true");
                                    continue;
                                }
                                if (key.equals("quality")) {
                                    quality = Integer.parseInt(value);
                                    continue;
                                }
                                if (key.equals("fps")) continue;
                                if (key.equals("colors")) continue;
                                throw new MediaException("Illegal option");
                            }
                            catch (NumberFormatException nfe) {
                                throw new MediaException("Number format error");
                            }
                        }
                        if (lp.hasMore()) break block36;
                        if (video_type.equals("jfif") && width == this.sw && height == this.sh && !progressive && !interlaced) break block34;
                    }
                    throw new MediaException(UNSUP_PARAMS);
                }
                if (enc.equals("png")) {
                    encType = 2;
                    while ((key = lp.getParameter()) != null) {
                        value = lp.getValue();
                        try {
                            if (key.equals("width")) {
                                width = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("height")) {
                                height = Integer.parseInt(value);
                                continue;
                            }
                            if (key.equals("colors")) {
                                colors = value;
                                continue;
                            }
                            if (key.equals("fps")) continue;
                            if (key.equals("quality")) continue;
                            throw new MediaException("Illegal option");
                        }
                        catch (NumberFormatException nfe) {
                            throw new MediaException("Number format error");
                        }
                    }
                    if (lp.hasMore() || !colors.equals("rgb888") || width != this.sw || height != this.sh || progressive || interlaced) {
                        throw new MediaException(UNSUP_PARAMS);
                    }
                } else {
                    throw new MediaException(UNSUP_PARAMS);
                }
            }
            int snapLength = 0;
            if (this.tempSnapData == null) {
                this.tempSnapData = new byte[this.sw * this.sh * 4];
            }
            if (this.pngData != null) {
                Image pngImage = Image.createImage(this.pngData, 0, this.pngDataLength);
                int[] tempRGBData = new int[this.sw * this.sh];
                pngImage.getRGB(tempRGBData, 0, this.sw, 0, 0, this.sw, this.sh);
                snapLength = this.nCompress(tempRGBData, this.sw, this.sh, quality, this.tempSnapData, encType);
            } else if (this.rgbData != null) {
                snapLength = this.nCompress(this.rgbData, this.sw, this.sh, quality, this.tempSnapData, encType);
                if (snapLength <= 0) {
                    throw new MediaException("Error encoding to " + enc);
                }
            } else {
                int[] blank = new int[this.sw * this.sh];
                for (int i = 0; i < this.sw * this.sh; ++i) {
                    blank[i] = 0;
                }
                snapLength = this.nCompress(blank, this.sw, this.sh, quality, this.tempSnapData, encType);
            }
            if (snapLength <= 0) {
                throw new MediaException("Error encoding to " + enc);
            }
            byte[] snap = new byte[snapLength];
            System.arraycopy(this.tempSnapData, 0, snap, 0, snapLength);
            return snap;
        }
    }

    private int tryParam(String tok, String prop, int def) {
        if (tok.startsWith(prop)) {
            tok = tok.substring(prop.length(), tok.length());
            try {
                return Integer.parseInt(tok);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return def;
    }

    synchronized void close() {
        if (!this.closed && this.canvas != null) {
            this.mmh.unregisterPlayer(this);
        }
        this.rgbData = null;
        this.scaledRGB = null;
        this.pngData = null;
        this.closed = true;
    }

    void initRendering(int mode, int width, int height) {
        this.rgbMode = mode & 0x7F;
        this.nativeRender = (mode & 0x80) > 0;
        this.useAlpha = (mode & 0x100) > 0;
        this.pWidth = width;
        this.pHeight = height;
    }

    void setMode(int mode) {
        this.rgbMode = mode & 0x7F;
        this.nativeRender = mode >= 128;
    }

    int getPreferredRGBMode() {
        return 2;
    }

    Item getCustomItem() {
        if (this.mmItem == null) {
            this.mmItem = new MMItem(this.pWidth, this.pHeight);
        }
        return this.mmItem;
    }

    void setSize(int width, int height) {
    }

    synchronized boolean render(Object data) {
        if (!this.pvis) {
            return false;
        }
        if (data == null) {
            return false;
        }
        if (!(data instanceof int[])) {
            return false;
        }
        this.update((int[])data);
        return true;
    }

    synchronized boolean render(int pointer) {
        return pointer != 0 && this.pvis;
    }

    synchronized boolean renderImage(byte[] imageData, int imageLength) {
        this.pngData = imageData;
        this.pngDataLength = imageLength;
        if (!this.pvis) {
            return false;
        }
        if (this.mmItem != null) {
            this.mmItem.renderImage(imageData, imageLength);
        } else if (this.canvas != null && this.pvis) {
            this.canvas.repaint(this.dx, this.dy, this.dw, this.dh);
        }
        return true;
    }

    private void update(int[] frame) {
        if (this.rgbMode != 4) {
            return;
        }
        this.rgbData = frame;
        if (this.mmItem != null) {
            this.mmItem.forcePaint(frame);
        } else if (this.canvas != null) {
            this.canvas.repaint(this.dx, this.dy, this.dw, this.dh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] scaleToDest(int[] source) {
        int ldw = 0;
        int ldh = 0;
        Object object = this.dispBoundsLock;
        synchronized (object) {
            ldw = this.dw;
            ldh = this.dh;
        }
        object = this;
        synchronized (object) {
            if (this.scaledRGB == null || this.scaledRGB.length < ldw * ldh) {
                this.scaledRGB = new int[ldw * ldh];
            }
            int dp = 0;
            for (int y = 0; y < ldh; ++y) {
                for (int x = 0; x < ldw; ++x) {
                    this.scaledRGB[dp++] = source[y * this.sh / ldh * this.sw + x * this.sw / ldw];
                }
            }
            return this.scaledRGB;
        }
    }

    private int[] scaleToDest(Image img) {
        if (this.rgbData == null) {
            this.rgbData = new int[this.sw * this.sh];
        }
        int width = img.getWidth();
        int height = img.getHeight();
        img.getRGB(this.rgbData, 0, this.sw, 0, 0, width, height);
        return this.scaleToDest(this.rgbData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintVideo(MMHelper mmh, Graphics g) {
        block18: {
            if (mmh != this.mmh) {
                return;
            }
            int cx = g.getClipX();
            int cy = g.getClipY();
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            g.clipRect(this.dx, this.dy, this.dw, this.dh);
            if (g.getClipWidth() > 0 && g.getClipHeight() > 0 && this.pvis) {
                int w = this.dw;
                int h = this.dh;
                if (w > this.sw) {
                    w = this.sw;
                }
                if (h > this.sh) {
                    h = this.sh;
                }
                try {
                    VidCtrl vidCtrl = this;
                    synchronized (vidCtrl) {
                        if (this.pngData != null) {
                            if (this.image != null) {
                                // empty if block
                            }
                            this.image = Image.createImage(this.pngData, 0, this.pngDataLength);
                            if (this.dw != this.sw || this.dh != this.sh) {
                                int[] scaledRGB = this.scaleToDest(this.image);
                                g.drawRGB(scaledRGB, 0, this.dw, this.dx, this.dy, this.dw, this.dh, this.useAlpha);
                            } else {
                                g.drawImage(this.image, this.dx, this.dy, 20);
                            }
                        } else if (this.rgbData != null) {
                            if (this.dw != this.sw || this.dh != this.sh) {
                                int[] scaledRGB = this.scaleToDest(this.rgbData);
                                g.drawRGB(scaledRGB, 0, this.dw, this.dx, this.dy, this.dw, this.dh, this.useAlpha);
                            } else {
                                g.drawRGB(this.rgbData, 0, this.sw, this.dx, this.dy, w, h, this.useAlpha);
                            }
                        }
                        break block18;
                    }
                }
                finally {
                    g.setClip(cx, cy, cw, ch);
                }
            }
            g.setClip(cx, cy, cw, ch);
        }
    }

    private native int nCompress(int[] var1, int var2, int var3, int var4, byte[] var5, int var6);

    final class MMItem
    extends CustomItem {
        int ody;
        int odh;
        int odw;
        int[] frame;
        Image image;
        Object imageLock = new Object();

        public MMItem(int w, int h) {
            super("");
        }

        void forcePaint(int[] frame) {
            if (frame != null) {
                this.frame = frame;
            } else {
                this.invalidate();
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void renderImage(byte[] imageData, int imageLength) {
            Object object = this.imageLock;
            synchronized (object) {
                if (this.image != null) {
                    // empty if block
                }
                this.image = Image.createImage(imageData, 0, imageLength);
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paint(Graphics g, int w, int h) {
            if (!VidCtrl.this.pvis) {
                return;
            }
            if (this.frame != null) {
                if (VidCtrl.this.dw != VidCtrl.this.sw || VidCtrl.this.dh != VidCtrl.this.sh) {
                    int[] scaledRGB = VidCtrl.this.scaleToDest(this.frame);
                    g.drawRGB(scaledRGB, 0, VidCtrl.this.dw, 0, 0, VidCtrl.this.dw, VidCtrl.this.dh, VidCtrl.this.useAlpha);
                } else {
                    g.drawRGB(this.frame, 0, VidCtrl.this.sw, 0, 0, VidCtrl.this.sw, VidCtrl.this.sh, VidCtrl.this.useAlpha);
                }
            } else {
                Object object = this.imageLock;
                synchronized (object) {
                    if (this.image != null) {
                        if (VidCtrl.this.dw != VidCtrl.this.sw || VidCtrl.this.dh != VidCtrl.this.sh) {
                            int[] scaledRGB = VidCtrl.this.scaleToDest(this.image);
                            g.drawRGB(scaledRGB, 0, VidCtrl.this.dw, 0, 0, VidCtrl.this.dw, VidCtrl.this.dh, VidCtrl.this.useAlpha);
                        } else {
                            g.drawImage(this.image, 0, 0, 20);
                        }
                    }
                }
            }
        }

        protected int getMinContentWidth() {
            return 1;
        }

        protected int getMinContentHeight() {
            return 1;
        }

        protected int getPrefContentWidth(int h) {
            return VidCtrl.this.dw;
        }

        protected int getPrefContentHeight(int w) {
            return VidCtrl.this.dh;
        }

        protected void hideNotify() {
            super.hideNotify();
        }
    }
}

