/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.FileIO;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.RecordControl;

abstract class RecordCtrl
implements RecordControl {
    private String locator;
    private String fileName;
    private int filePointer;
    private String localFileName = null;
    private OutputStream httpOutputStream;
    private int localFilePointer;
    private OutputStream stream;
    private byte[] localBuffer;
    private int CHUNK_SIZE = 8192;
    protected BasicPlayer player;
    private boolean recordRequested;
    private boolean recording;
    private int sizeLimit = Integer.MAX_VALUE;
    protected int headerSize;
    private int dataSize;
    private FileConnection fileCon;
    private OutputStream fileOutputStream;

    RecordCtrl() {
    }

    static void writeInt(byte[] buf, int value, int offset, boolean bigEndian) {
        int inc;
        int start;
        if (!bigEndian) {
            start = 3;
            inc = -1;
        } else {
            start = 0;
            inc = 1;
        }
        buf[start += offset] = (byte)(value >>> 24 & 0xFF);
        buf[start + inc] = (byte)(value >>> 16 & 0xFF);
        buf[start + inc + inc] = (byte)(value >>> 8 & 0xFF);
        buf[start + inc + inc + inc] = (byte)(value >>> 0 & 0xFF);
    }

    static void writeShort(byte[] buf, int value, int offset, boolean bigEndian) {
        int inc;
        int start;
        if (!bigEndian) {
            start = 1;
            inc = -1;
        } else {
            start = 0;
            inc = 1;
        }
        buf[start += offset] = (byte)(value >> 8 & 0xFF);
        buf[start + inc] = (byte)(value >> 0 & 0xFF);
    }

    public final void setRecordStream(OutputStream stream) {
        if (this.recordRequested) {
            throw new IllegalStateException("setRecordStream cannot be called after startRecord is called");
        }
        if (this.locator != null) {
            throw new IllegalStateException("setRecordStream: setRecordLocation has been called and commit has not been called");
        }
        if (stream == null) {
            throw new IllegalArgumentException("setRecordStream: null stream specified");
        }
        RecordCtrl.checkPermission();
        this.stream = stream;
        if (this.localFileName == null) {
            this.localFileName = FileIO.getTempFileName();
        }
        this.localFilePointer = FileIO.nOpen(this.localFileName.getBytes(), 1);
    }

    public final void setRecordLocation(String locator) throws IOException, MediaException {
        FileIO.removeTempFiles();
        if (this.recordRequested) {
            throw new IllegalStateException("setRecordLocation cannot be called after startRecord is called");
        }
        if (this.stream != null) {
            throw new IllegalStateException("setRecordLocation: setRecordStream has been called and commit has not been called");
        }
        if (locator == null) {
            throw new IllegalArgumentException("setRecordLocation: null locator specified");
        }
        RecordCtrl.checkPermission();
        int colonIndex = locator.indexOf(":");
        if (colonIndex < 0) {
            throw new MediaException("setRecordLocation: invalid locator " + locator);
        }
        if (!locator.startsWith("file:")) {
            throw new MediaException("Only file protocol is supported");
        }
        if (!locator.endsWith(".wav")) {
            throw new SecurityException("can only write .wav files");
        }
        this.fileName = locator.substring(colonIndex + 1);
        if (this.fileName.length() <= 0) {
            throw new MediaException("setRecordLocation: invalid locator " + locator);
        }
        this.fileName = this.extractFileNameFromURL(this.fileName);
        if (this.fileName == null) {
            throw new MediaException("setRecordLocation: invalid locator " + locator);
        }
        this.fileName = null;
        try {
            this.fileCon = (FileConnection)Connector.open((String)locator, (int)3);
        }
        catch (IllegalArgumentException e) {
            throw new MediaException(e.getMessage());
        }
        catch (ConnectionNotFoundException e) {
            throw new IOException(e.getMessage());
        }
        if (this.fileCon.exists()) {
            this.fileCon.truncate(0L);
        } else {
            this.fileCon.create();
        }
        this.fileOutputStream = this.fileCon.openOutputStream();
        this.fileOutputStream.write(new byte[this.headerSize], 0, this.headerSize);
        this.locator = locator;
    }

    protected abstract byte[] getHeader(int var1) throws IOException;

    public final void startRecord() {
        if (this.locator == null && this.stream == null) {
            throw new IllegalStateException("Should call setRecordLocation or setRecordStream before calling startRecord");
        }
        if (this.stream != null && this.localFilePointer == 0) {
            this.player.sendEvent("recordError", "Unable to create temporary file for local buffering. Check if environment variable TEMP points to writable directory");
            return;
        }
        if (this.recordRequested) {
            return;
        }
        this.recordRequested = true;
        if (this.player.getState() == 400) {
            this.recording = true;
            this.player.sendEvent("recordStarted", new Long(this.player.getMediaTime()));
        }
    }

    final void playerStart() {
        if (this.recordRequested && !this.recording) {
            this.recording = true;
            this.player.sendEvent("recordStarted", new Long(this.player.getMediaTime()));
        }
    }

    public final void stopRecord() {
        if (this.recordRequested) {
            this.recordRequested = false;
            if (this.recording) {
                this.player.sendEvent("recordStopped", new Long(this.player.getMediaTime()));
                this.recording = false;
            }
        }
    }

    public final void commit() throws IOException {
        if (this.stream == null && (this.locator == null || this.filePointer == 0 && this.httpOutputStream == null && this.fileOutputStream == null)) {
            return;
        }
        try {
            this.stopRecord();
            if (this.dataSize == 0) {
                return;
            }
            byte[] header = this.getHeader(this.dataSize);
            if (this.stream != null) {
                this.stream.write(header);
                this.stream.flush();
                if (!FileIO.nClose(this.localFilePointer)) {
                    throw new IOException("I/O error");
                }
                this.localFilePointer = FileIO.nOpen(this.localFileName.getBytes(), 0);
                if (this.localFilePointer == 0) {
                    throw new IOException("I/O error");
                }
                int numChunks = this.dataSize / this.CHUNK_SIZE;
                int remaining = this.dataSize;
                boolean offset = false;
                if (this.localBuffer == null) {
                    if (this.dataSize < this.CHUNK_SIZE) {
                        this.CHUNK_SIZE = this.dataSize;
                    }
                    this.localBuffer = new byte[this.CHUNK_SIZE];
                }
                while (remaining > 0) {
                    int toWrite;
                    int n = toWrite = remaining > this.CHUNK_SIZE ? this.CHUNK_SIZE : remaining;
                    if (FileIO.nRead(this.localFilePointer, this.localBuffer, 0, toWrite) != toWrite) {
                        throw new IOException("I/O error");
                    }
                    this.stream.write(this.localBuffer, 0, toWrite);
                    this.stream.flush();
                    remaining -= toWrite;
                }
            } else {
                this.fileOutputStream.flush();
                this.fileOutputStream.close();
                this.fileOutputStream = this.fileCon.openOutputStream(0L);
                this.fileOutputStream.write(header, 0, this.headerSize);
                this.fileOutputStream.flush();
                this.fileOutputStream.close();
                this.fileOutputStream = null;
                this.fileCon.close();
                this.fileCon = null;
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        finally {
            this.cleanup(null);
        }
    }

    public final void close() {
        this.localBuffer = null;
        this.cleanup(null);
    }

    public final int setRecordSizeLimit(int size) throws MediaException {
        if (size <= 0) {
            throw new IllegalArgumentException("setRecordSizeLimit: record size limit cannot be 0 or negative");
        }
        this.sizeLimit = size;
        return size;
    }

    public final void reset() throws IOException {
        try {
            this.stopRecord();
            if (this.filePointer != 0) {
                if (!FileIO.nClose(this.filePointer)) {
                    throw new IOException("reset: unable to erase current recording");
                }
                this.filePointer = FileIO.nOpen(this.fileName.getBytes(), 1);
                if (this.filePointer == 0) {
                    throw new IOException("reset: unable to erase current recording");
                }
                this.skipHeader(this.filePointer, "reset: unable to erase current recording");
            } else if (this.stream != null || this.httpOutputStream != null) {
                if (!FileIO.nClose(this.localFilePointer) || (this.localFilePointer = FileIO.nOpen(this.localFileName.getBytes(), 1)) == 0) {
                    throw new IOException("I/O error");
                }
            } else if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
                this.fileCon.truncate(0L);
                this.fileOutputStream = this.fileCon.openOutputStream(0L);
                this.fileOutputStream.write(new byte[this.headerSize], 0, this.headerSize);
            }
            this.dataSize = 0;
        }
        catch (IOException e) {
            this.cleanup(null);
            throw e;
        }
    }

    public void record(byte[] buf, int offset, int length) {
        try {
            if (this.recordRequested) {
                int actualWritten = this.write(buf, offset, length);
                if (actualWritten != length) {
                    this.cleanup("I/O Error while recording");
                    return;
                }
                this.dataSize += actualWritten;
                if (this.headerSize + this.dataSize >= this.sizeLimit) {
                    this.stopRecord();
                    this.commit();
                }
            }
        }
        catch (Exception e) {
            this.cleanup("I/O Error while recording");
        }
    }

    private void cleanup(String errorMessage) {
        this.stopRecord();
        if (this.filePointer != 0) {
            if (!FileIO.nClose(this.filePointer) || !FileIO.nDelete(this.fileName.getBytes())) {
                // empty if block
            }
            this.filePointer = 0;
        }
        this.fileName = null;
        this.locator = null;
        if (!(this.localFilePointer == 0 || FileIO.nClose(this.localFilePointer) && FileIO.nDelete(this.localFileName.getBytes()))) {
            this.localFileName = null;
        }
        this.localFilePointer = 0;
        this.stream = null;
        try {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
            if (this.fileCon != null) {
                this.fileCon.delete();
                this.fileCon.close();
            }
            this.fileOutputStream = null;
            this.fileCon = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.dataSize = 0;
        if (errorMessage != null) {
            this.player.sendEvent("recordError", errorMessage);
        }
    }

    private int write(byte[] buf, int offset, int length) {
        int actualWritten = -1;
        if (this.locator != null && this.locator.startsWith("file:")) {
            try {
                this.fileOutputStream.write(buf, offset, length);
                actualWritten = length;
            }
            catch (IOException ioe) {
                return -1;
            }
        } else if (this.localFilePointer != 0) {
            actualWritten = FileIO.nWrite(this.localFilePointer, buf, offset, length);
        }
        return actualWritten;
    }

    private void skipHeader(int fp, String message) throws IOException {
        if (!this.seek(fp, this.headerSize)) {
            throw new IOException(message);
        }
    }

    private boolean seek(int fp, int offset) {
        return FileIO.nSeek(fp, offset);
    }

    private String extractFileNameFromURL(String url) {
        try {
            int idx = 0;
            while ((idx = url.indexOf("%", idx)) >= 0) {
                if (url.length() > idx + 2) {
                    byte[] bytes = new byte[1];
                    try {
                        bytes[0] = (byte)Integer.valueOf(url.substring(idx + 1, idx + 3), 16).intValue();
                        url = url.substring(0, idx) + new String(bytes) + url.substring(idx + 3);
                    }
                    catch (NumberFormatException ne) {
                        // empty catch block
                    }
                }
                ++idx;
            }
            int startindex = 0;
            int length = url.length();
            while (length - startindex > 2 && url.charAt(startindex) == '/' && (url.charAt(startindex + 1) == '/' || url.charAt(startindex + 2) == ':')) {
                ++startindex;
            }
            return url.substring(startindex);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void checkPermission() {
        try {
            Scheduler scheduler = Scheduler.getScheduler();
            MIDletSuite midletSuite = scheduler.getMIDletSuite();
            midletSuite.checkForPermission(16, null);
        }
        catch (InterruptedException e) {
            throw new SecurityException("Interrupted while trying to ask the user permission");
        }
    }
}

