/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mmedia;

import com.sun.mmedia.MIDIPlayer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Stack;
import javax.microedition.media.Control;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.ToneControl;

public final class MidiTonePlayer
extends MIDIPlayer
implements ToneControl {
    private int tchnl = 15;
    private int[] toneSeq = null;

    public String getContentType() {
        this.chkClosed(true);
        return "audio/x-tone-seq";
    }

    protected void doRealize() throws MediaException {
        if (this.source == null) {
            this.setToneSequence(new int[0], 0, 60, 64);
        } else {
            int chunksize = 128;
            byte[] tmpseqs = new byte[chunksize];
            byte[] seqs = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(chunksize);
            try {
                int read;
                this.source.start();
                while ((read = this.stream.read(tmpseqs, 0, chunksize)) != -1) {
                    baos.write(tmpseqs, 0, read);
                }
                seqs = baos.toByteArray();
                baos.close();
                tmpseqs = null;
            }
            catch (IOException ex) {
                throw new MediaException("fail to read from source");
            }
            try {
                this.setSequence(seqs);
            }
            catch (Exception e) {
                throw new MediaException(e.getMessage());
            }
            baos = null;
            seqs = null;
            System.gc();
        }
        this.midiOut.setTone();
    }

    protected void doPrefetch() throws MediaException {
        super.doPrefetch();
        if (this.tchnl != this.midiOut.getToneChnl() && this.toneSeq != null) {
            this.tchnl = this.midiOut.getToneChnl() & 0xF;
            for (int i = 0; i < this.toneSeq.length; i += 2) {
                this.toneSeq[i + 1] = this.toneSeq[i + 1] & 0xFFFFFFF0 | this.tchnl;
            }
        }
        this.midiOut.shortMsg(0xC0 | this.tchnl & 0xF, 75, 0);
    }

    protected Control doGetControl(String type) {
        if (type.startsWith("javax.microedition.media.control.")) {
            if (type.endsWith("ToneControl")) {
                return this;
            }
            if (type.endsWith("MIDIControl") || type.endsWith("PitchControl") || type.endsWith("TempoControl")) {
                return null;
            }
        }
        return super.doGetControl(type);
    }

    public synchronized void setSequence(byte[] sequence) {
        if (this.getState() >= 300) {
            throw new IllegalStateException("cannot set seq when player is in PREFECTCHED or STARTED state");
        }
        this.toneSeq = null;
        int tempo = 120;
        int resolution = 64;
        int volume = 100;
        int p = 0;
        try {
            byte note;
            int i;
            Stack<Integer> sp = new Stack<Integer>();
            Hashtable<Integer, Integer> blens = new Hashtable<Integer, Integer>();
            Hashtable<Integer, Integer> pblks = new Hashtable<Integer, Integer>();
            boolean inblk = false;
            byte found = 0;
            int thisblen = 0;
            int startseq = 2;
            int len = 0;
            int tmp = 0;
            if (sequence[0] != -2 || sequence[1] != 1) {
                this.reportErr(6);
            }
            if (sequence[startseq] == -3) {
                if (sequence[startseq + 1] < 5) {
                    this.reportErr(5);
                }
                tempo = (sequence[startseq + 1] & 0x7F) << 2;
                startseq += 2;
            }
            if (sequence[startseq] == -4) {
                if (sequence[startseq + 1] <= 0) {
                    this.reportErr(8);
                }
                resolution = sequence[startseq + 1];
                startseq += 2;
            }
            block19: for (i = startseq; i < sequence.length; i += 2) {
                note = sequence[i];
                if (note < -9 || (note >= 0 || note == -1) && sequence[i + 1] <= 0) {
                    this.reportErr(4);
                }
                switch (note) {
                    case -5: {
                        if (!inblk) {
                            if (sequence[i + 1] < 0) {
                                this.reportErr(7);
                            }
                            found = sequence[i + 1];
                            inblk = true;
                            pblks.put(new Integer(found), new Integer(i));
                            thisblen = 0;
                            continue block19;
                        }
                        this.reportErr(3);
                        continue block19;
                    }
                    case -6: {
                        if (inblk) {
                            if (sequence[i + 1] == found) {
                                inblk = false;
                                blens.put(new Integer(found), new Integer(thisblen));
                                continue block19;
                            }
                            this.reportErr(1);
                            continue block19;
                        }
                        this.reportErr(1);
                        continue block19;
                    }
                    case -9: {
                        if (sequence[i + 1] < 2) {
                            this.reportErr(9);
                        }
                        if ((note = sequence[i + 2]) == -1 || note >= 0) continue block19;
                        this.reportErr(11);
                        continue block19;
                    }
                    case -8: {
                        if (sequence[i + 1] >= 0 && sequence[i + 1] <= 100) continue block19;
                        this.reportErr(10);
                        continue block19;
                    }
                    case -7: {
                        if (blens.get(new Integer(sequence[i + 1])) == null) {
                            this.reportErr(2);
                        }
                        tmp = (Integer)blens.get(new Integer(sequence[i + 1]));
                        if (inblk) {
                            thisblen += tmp;
                            continue block19;
                        }
                        len += tmp;
                        continue block19;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        this.reportErr(12);
                        continue block19;
                    }
                    default: {
                        if (inblk) {
                            thisblen += 2;
                            continue block19;
                        }
                        len += 2;
                    }
                }
            }
            if (inblk) {
                this.reportErr(1);
            }
            len = len * 2 + 2;
            this.toneSeq = new int[len];
            int curTime = 0;
            p = 0;
            i = startseq;
            byte mul = 1;
            block20: while (i < sequence.length) {
                note = sequence[i];
                switch (note) {
                    case -5: {
                        while (sequence[i += 2] != -6) {
                        }
                        break;
                    }
                    case -7: {
                        sp.push(new Integer(i + 2));
                        i = (Integer)pblks.get(new Integer(sequence[i + 1])) + 2;
                        continue block20;
                    }
                    case -6: {
                        i = (Integer)sp.pop();
                        continue block20;
                    }
                    case -8: {
                        volume = (sequence[i + 1] & 0x7F) * 127 / 100;
                        break;
                    }
                    case -9: {
                        mul = sequence[i + 1];
                        break;
                    }
                    case -1: {
                        curTime += ((sequence[i + 1] & 0x7F) << 2) * mul;
                        mul = 1;
                        break;
                    }
                    default: {
                        if (volume != 0) {
                            this.toneSeq[p++] = curTime;
                            int evt = 0x90 | this.tchnl & 0xF | (sequence[i] & 0xFF) << 8 | (volume & 0xFF) << 16;
                            this.toneSeq[p++] = evt;
                            this.toneSeq[p++] = curTime += ((sequence[i + 1] & 0x7F) << 2) * mul;
                            this.toneSeq[p++] = evt & 0xFFFF;
                        } else {
                            curTime += ((sequence[i + 1] & 0x7F) << 2) * mul;
                        }
                        mul = 1;
                    }
                }
                i += 2;
            }
            this.toneSeq[p++] = curTime;
            this.toneSeq[p++] = 0;
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.setToneSequence(this.toneSeq, p, tempo, resolution);
    }

    private void reportErr(int code) {
        throw new IllegalArgumentException("bad tone param: err code " + code);
    }
}

