/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.ssl;

class Utils {
    static final byte LOG_CRIT = 5;
    static final byte LOG_ERR = 4;
    static final byte LOG_WARN = 3;
    static final byte LOG_NOTICE = 2;
    static final byte LOG_INFO = 1;
    static final byte LOG_DEBUG = 0;
    private static byte logLevel = (byte)3;
    private static char[] hc = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    Utils() {
    }

    static String hexEncode(byte[] byArray, int n, int n2) {
        return new String(Utils.hexEncodeToChars(byArray, n, n2));
    }

    static char[] hexEncodeToChars(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return new char[0];
        }
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        char[] cArray = n2 == 1 ? new char[n2 * 2] : new char[n2 * 3 - 1];
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = byArray[n + n3] & 0xFF;
            cArray[n4++] = hc[n5 >>> 4];
            cArray[n4++] = hc[n5 & 0xF];
            if (++n3 >= n2) break;
            cArray[n4++] = 58;
        }
        return cArray;
    }

    static String hexEncode(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return Utils.hexEncode(byArray, 0, byArray.length);
    }

    static byte[] longToBytes(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 64) {
            byArray[n >> 3] = (byte)(l >> 56 - n & 0xFFL);
            n += 8;
        }
        return byArray;
    }

    static boolean byteMatch(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray.length < n + n3 || byArray2.length < n2 + n3) {
            return false;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n4 + n] != byArray2[n4 + n2]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    static void log(byte by, String string) {
        if (by < logLevel) {
            return;
        }
        try {
            System.out.print(string);
        }
        catch (Exception exception) {
            System.out.println("log() caught <" + exception + ">");
        }
    }

    static void logln(byte by, String string) {
        if (by < logLevel) {
            return;
        }
        try {
            System.out.println(string);
        }
        catch (Exception exception) {
            System.out.println("logln() caught <" + exception + ">");
        }
    }
}

