/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.ssl;

import com.sun.midp.ssl.Cipher;
import com.sun.midp.ssl.Key;
import com.sun.midp.ssl.KeyBuilder;
import com.sun.midp.ssl.MessageDigest;
import com.sun.midp.ssl.SecretKey;
import com.sun.midp.ssl.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Record {
    static final byte CCS = 20;
    static final byte ALRT = 21;
    static final byte HNDSHK = 22;
    static final byte APP = 23;
    static final byte WARNING = 1;
    static final byte FATAL = 2;
    static final byte CLOSE_NTFY = 0;
    static final byte UNEXP_MSG = 10;
    static final byte BAD_MAC = 20;
    static final byte HNDSHK_FAIL = 40;
    static final byte NO_CERT = 41;
    static final byte BAD_CERT = 42;
    static final byte UNSUP_CERT = 43;
    static final byte CERT_REVKD = 44;
    static final byte CERT_EXPRD = 45;
    static final byte CERT_UNKWN = 46;
    static final byte BAD_PARAM = 47;
    static final byte SERVER = 0;
    static final byte CLIENT = 1;
    static final byte[] PAD1 = new byte[]{54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54};
    static final byte[] PAD2 = new byte[]{92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92};
    private final int HEADER_SIZE;
    private InputStream in;
    private OutputStream out;
    private byte[] cMACKey;
    private byte[] sMACKey;
    private byte[] cKey;
    private byte[] sKey;
    private byte[] cIV;
    private byte[] sIV;
    private long cSeq = 0L;
    private long sSeq = 0L;
    private byte role;
    private byte rActive = 0;
    private byte wActive = 0;
    private MessageDigest d = null;
    private byte dLen = 0;
    private int padLen = 0;
    private Cipher cc = null;
    private Cipher sc = null;
    private SecretKey cBulkKey = null;
    private SecretKey sBulkKey = null;
    private byte ver;
    private byte isBlk = 0;
    private int cblk = 1;
    private byte[] inputHeader = new byte[5];
    private int headerBytesRead;
    private int dataLen;
    private int dataBytesRead;
    private boolean shutdown;
    byte[] inputData;
    int plainTextLength;

    Record(byte by, InputStream inputStream, OutputStream outputStream) {
        this.HEADER_SIZE = 5;
        this.in = inputStream;
        this.out = outputStream;
        this.ver = (byte)48;
        this.role = by;
    }

    private void bump(byte by) throws IOException {
        if (by == 1) {
            if (++this.cSeq == 0L) {
                throw new IOException("Clnt seq rolled over");
            }
        } else if (++this.sSeq == 0L) {
            throw new IOException("Srvr seq rolled over");
        }
    }

    void init(byte[] byArray, byte[] byArray2, byte by, byte[] byArray3) throws Exception {
        byte[] byArray4;
        byte[][] byArrayArray = new byte[][]{{65}, {66, 66}, {67, 67, 67}, {68, 68, 68, 68}, {69, 69, 69, 69, 69}, {70, 70, 70, 70, 70, 70}, {71, 71, 71, 71, 71, 71, 71}};
        int n = 5;
        switch (by) {
            case 4: {
                n = 16;
            }
            case 3: {
                this.d = MessageDigest.getInstance((byte)1, false);
                this.dLen = (byte)16;
                this.padLen = 48;
                break;
            }
            case 5: {
                n = 16;
                this.d = MessageDigest.getInstance((byte)2, false);
                this.dLen = (byte)20;
                this.padLen = 40;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported suite");
            }
        }
        byte[] byArray5 = new byte[byArray3.length + byArray2.length + byArray.length];
        System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray5, byArray3.length, byArray2.length);
        System.arraycopy(byArray, 0, byArray5, byArray3.length + byArray2.length, byArray.length);
        int n2 = 0;
        int n3 = this.dLen + n + n2 << 1;
        byte[] byArray6 = new byte[n3 + 15 >>> 4 << 4];
        MessageDigest messageDigest = MessageDigest.getInstance((byte)1, false);
        MessageDigest messageDigest2 = MessageDigest.getInstance((byte)2, false);
        n3 = 0;
        while (n3 < byArray6.length >>> 4) {
            messageDigest.update(byArray3, 0, byArray3.length);
            messageDigest2.update(byArrayArray[n3], 0, byArrayArray[n3].length);
            byArray4 = new byte[20];
            messageDigest2.doFinal(byArray5, 0, byArray5.length, byArray4, 0);
            messageDigest.doFinal(byArray4, 0, 20, byArray6, n3 << 4);
            ++n3;
        }
        this.cMACKey = new byte[this.dLen];
        this.sMACKey = new byte[this.dLen];
        System.arraycopy(byArray6, 0, this.cMACKey, 0, this.cMACKey.length);
        System.arraycopy(byArray6, this.cMACKey.length, this.sMACKey, 0, this.sMACKey.length);
        this.cKey = new byte[n];
        this.sKey = new byte[n];
        System.arraycopy(byArray6, 2 * this.cMACKey.length, this.cKey, 0, this.cKey.length);
        System.arraycopy(byArray6, 2 * this.cMACKey.length + this.cKey.length, this.sKey, 0, this.sKey.length);
        this.cIV = new byte[n2];
        this.sIV = new byte[n2];
        if (by != 4 && by != 5) {
            byArray4 = new byte[16];
            messageDigest.update(this.cKey, 0, this.cKey.length);
            messageDigest.update(byArray, 0, byArray.length);
            messageDigest.doFinal(byArray2, 0, byArray2.length, byArray4, 0);
            byte[] byArray7 = new byte[16];
            System.arraycopy(byArray4, 0, byArray7, 0, byArray7.length);
            messageDigest.update(this.sKey, 0, this.sKey.length);
            messageDigest.update(byArray2, 0, byArray2.length);
            messageDigest.doFinal(byArray, 0, byArray.length, byArray4, 0);
            byte[] byArray8 = new byte[byArray7.length];
            System.arraycopy(byArray4, 0, byArray8, 0, byArray8.length);
            this.cKey = byArray7;
            this.sKey = byArray8;
        }
        this.cBulkKey = (SecretKey)KeyBuilder.buildKey((byte)3, (short)(this.cKey.length << 3), false);
        this.cBulkKey.setKey(this.cKey, (short)0);
        this.cc = Cipher.getInstance((byte)3, (boolean)false);
        this.cc.init((Key)this.cBulkKey, (byte)1);
        this.sBulkKey = (SecretKey)KeyBuilder.buildKey((byte)3, (short)(this.sKey.length << 3), false);
        this.sBulkKey.setKey(this.sKey, (short)0);
        this.sc = Cipher.getInstance((byte)3, (boolean)false);
        this.sc.init((Key)this.sBulkKey, (byte)2);
        this.cblk = 1;
        this.isBlk = 0;
    }

    private byte[] getMAC(byte by, byte by2, byte[] byArray, int n, int n2) {
        byte[] byArray2;
        byte[] byArray3 = null;
        if (by == 1) {
            this.d.update(this.cMACKey, 0, this.cMACKey.length);
            this.d.update(PAD1, 0, this.padLen);
            byArray3 = Utils.longToBytes(this.cSeq);
            this.d.update(byArray3, 0, byArray3.length);
            byArray2 = this.cMACKey;
        } else {
            this.d.update(this.sMACKey, 0, this.sMACKey.length);
            this.d.update(PAD1, 0, this.padLen);
            byArray3 = Utils.longToBytes(this.sSeq);
            this.d.update(byArray3, 0, byArray3.length);
            byArray2 = this.sMACKey;
        }
        byArray3 = new byte[]{by2, (byte)(n2 >>> 8), (byte)(n2 & 0xFF)};
        this.d.update(byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[this.d.getLength()];
        this.d.doFinal(byArray, n, n2, byArray4, 0);
        this.d.update(byArray2, 0, byArray2.length);
        this.d.update(PAD2, 0, this.padLen);
        byte[] byArray5 = new byte[byArray4.length];
        this.d.doFinal(byArray4, 0, byArray4.length, byArray5, 0);
        return byArray5;
    }

    private byte[] encode(byte[] byArray) throws IOException {
        byte[] byArray2 = null;
        if (this.d != null) {
            byArray2 = new byte[byArray.length - 5 + this.dLen];
            System.arraycopy(byArray, 5, byArray2, 0, byArray.length - 5);
            System.arraycopy(this.getMAC(this.role, byArray[0], byArray, 5, byArray.length - 5), 0, byArray2, byArray.length - 5, this.dLen);
        } else {
            byArray2 = new byte[byArray.length - 5];
            System.arraycopy(byArray, 5, byArray2, 0, byArray.length - 5);
        }
        byte[] byArray3 = null;
        if (this.cc != null) {
            try {
                byArray3 = byArray2;
                this.cc.update(byArray2, 0, byArray2.length, byArray3, 0);
            }
            catch (Exception exception) {
                throw new IOException("Encode caught " + exception);
            }
        } else {
            byArray3 = byArray2;
        }
        byte[] byArray4 = new byte[byArray3.length + 5];
        System.arraycopy(byArray, 0, byArray4, 0, 3);
        byArray4[3] = (byte)(byArray3.length >>> 8);
        byArray4[4] = (byte)(byArray3.length & 0xFF);
        System.arraycopy(byArray3, 0, byArray4, 5, byArray3.length);
        this.bump(this.role);
        return byArray4;
    }

    private int decode() throws IOException {
        int n = 0;
        if (this.sc != null) {
            try {
                this.sc.update(this.inputData, 0, this.inputData.length, this.inputData, 0);
            }
            catch (Exception exception) {
                throw new IOException("Decode caught " + exception);
            }
        }
        int n2 = this.inputData.length - this.dLen - n;
        if (this.d != null) {
            byte[] byArray = null;
            byArray = this.getMAC((byte)(1 - this.role), this.inputHeader[0], this.inputData, 0, n2);
            if (!Utils.byteMatch(byArray, 0, this.inputData, this.inputData.length - n - this.dLen, this.dLen)) {
                this.alert((byte)2, (byte)20);
                throw new IOException("Bad MAC");
            }
        }
        this.bump((byte)(1 - this.role));
        return n2;
    }

    void rdRec(boolean bl, byte by) throws IOException {
        if (!this.rdRec(bl)) {
            return;
        }
        if (this.inputHeader[0] == by) {
            return;
        }
        this.plainTextLength = -1;
        switch (this.inputHeader[0]) {
            default: {
                this.alert((byte)2, (byte)10);
                throw new IOException("Unexpected SSL record, type: " + this.inputHeader[0]);
            }
            case 21: 
        }
        if (this.inputData.length < 2) {
            throw new IOException("Bad alert length");
        }
        if (this.inputData[0] == 1 && this.inputData[1] == 0 && by == 23) {
            this.shutdownConnection();
            return;
        }
        if (this.inputData[0] < 1 || this.inputData[0] > 2) {
            throw new IOException("Bad alert level");
        }
        throw new IOException("Alert (" + this.inputData[0] + "," + this.inputData[1] + ")");
    }

    private boolean rdRec(boolean bl) throws IOException {
        int n;
        this.plainTextLength = 0;
        if (!bl && this.in.available() == 0) {
            return false;
        }
        if (this.headerBytesRead == 0) {
            n = this.in.read(this.inputHeader, 0, 1);
            if (n == -1) {
                this.plainTextLength = -1;
                return false;
            }
            this.headerBytesRead = 1;
            this.dataBytesRead = 0;
            this.dataLen = 0;
        }
        while (this.headerBytesRead < this.inputHeader.length) {
            if (!bl && this.in.available() == 0) {
                return false;
            }
            n = this.in.read(this.inputHeader, this.headerBytesRead, this.inputHeader.length - this.headerBytesRead);
            if (n == -1) {
                throw new IOException("SSL connection ended abnormally while reading record header");
            }
            this.headerBytesRead += n;
        }
        if (this.dataLen == 0) {
            if (this.inputHeader[0] < 20 || this.inputHeader[0] > 23 || this.inputHeader[1] != (byte)(this.ver >>> 4) || this.inputHeader[2] != (byte)(this.ver & 0xF)) {
                this.alert((byte)2, (byte)10);
                throw new IOException("Bad record type (" + this.inputHeader[0] + ") or version (" + this.inputHeader[1] + "." + this.inputHeader[2] + ")");
            }
            this.dataLen = ((this.inputHeader[3] & 0xFF) << 8) + (this.inputHeader[4] & 0xFF);
            this.inputData = new byte[this.dataLen];
        }
        while (this.dataBytesRead < this.dataLen) {
            if (!bl && this.in.available() == 0) {
                return false;
            }
            n = this.in.read(this.inputData, this.dataBytesRead, this.dataLen - this.dataBytesRead);
            if (n == -1) {
                throw new IOException("SSL connection ended abnormally after reading record byte " + (this.dataBytesRead + this.headerBytesRead));
            }
            this.dataBytesRead += n;
        }
        this.plainTextLength = this.rActive == 1 ? this.decode() : this.dataBytesRead;
        if (this.inputHeader[0] == 20) {
            this.rActive = 1;
        }
        this.headerBytesRead = 0;
        return true;
    }

    void wrRec(byte by, byte[] byArray, int n, int n2) throws IOException {
        if (this.shutdown) {
            throw new IOException("Server has shutdown the connection");
        }
        byte[] byArray2 = new byte[n2 + 5];
        byArray2[0] = by;
        byArray2[1] = (byte)(this.ver >>> 4);
        byArray2[2] = (byte)(this.ver & 0xF);
        byArray2[3] = (byte)(n2 >>> 8);
        byArray2[4] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray, n, byArray2, 5, n2);
        if (this.wActive == 1) {
            this.out.write(this.encode(byArray2));
        } else {
            this.out.write(byArray2);
        }
        if (by == 20) {
            this.wActive = 1;
        }
    }

    public void alert(byte by, byte by2) {
        byte[] byArray = new byte[]{by, by2};
        try {
            this.wrRec((byte)21, byArray, 0, 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void shutdownConnection() {
        if (this.shutdown) {
            return;
        }
        this.alert((byte)1, (byte)0);
        this.shutdown = true;
        try {
            try {
                this.out.close();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

