/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.lcdui;

import com.sun.midp.lcdui.RecordedEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

public class EventSequence {
    private byte[] capture;
    private ByteArrayInputStream inputStream;
    private byte[] byteArray;
    private ByteArrayOutputStream outputStream;
    static final int EVENT_START_MARKER = 0;
    static final int CAPTURE_START_MARKER = 1;
    static final int END_OF_EVENT_SEQUENCE = -1;

    EventSequence() {
        this.byteArray = new byte[0];
        this.inputStream = new ByteArrayInputStream(this.byteArray);
        this.outputStream = new ByteArrayOutputStream();
    }

    void appendEvent(RecordedEvent event) {
        try {
            this.outputStream.write(0);
            this.outputStream.write(event.lengthOfByteRep());
            this.outputStream.write(event.getAsByte());
        }
        catch (IOException e) {
            System.out.println("EXCEPTION!");
        }
    }

    void setScreenCapture(byte[] capture) {
        this.capture = capture;
        this.outputStream.write(1);
        this.outputStream.write(capture.length);
        for (int byteCounter = 0; byteCounter < capture.length; ++byteCounter) {
            this.outputStream.write(capture[byteCounter]);
        }
    }

    public EventSequence(byte[] input) {
        this.byteArray = input;
        this.inputStream = new ByteArrayInputStream(this.byteArray);
        this.outputStream = new ByteArrayOutputStream();
    }

    public EventSequence(EventSequence[] sequences) {
        try {
            for (int i = 0; i < sequences.length; ++i) {
                this.outputStream.write(sequences[i].toByteArray());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public EventSequence(Vector sequences) {
        int length = sequences.size();
        try {
            for (int i = 0; i < length; ++i) {
                EventSequence q = (EventSequence)sequences.elementAt(i);
                this.outputStream.write(q.toByteArray());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public byte[] toByteArray() {
        byte[] tempByteArray = new byte[this.byteArray.length + this.outputStream.toByteArray().length];
        System.arraycopy(this.byteArray, 0, tempByteArray, 0, this.byteArray.length);
        System.arraycopy(this.outputStream.toByteArray(), 0, tempByteArray, this.byteArray.length, this.outputStream.toByteArray().length);
        this.byteArray = tempByteArray;
        this.outputStream.reset();
        return this.byteArray;
    }

    public void appendSequence(EventSequence sequence) {
        try {
            this.outputStream.write(sequence.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void initializeReplay() {
        byte[] tempByteArray = new byte[this.byteArray.length + this.outputStream.toByteArray().length];
        System.arraycopy(this.byteArray, 0, tempByteArray, 0, this.byteArray.length);
        System.arraycopy(this.outputStream.toByteArray(), 0, tempByteArray, this.byteArray.length, this.outputStream.toByteArray().length);
        this.byteArray = tempByteArray;
        this.outputStream.reset();
        this.inputStream = new ByteArrayInputStream(this.byteArray);
    }

    int getNextObjectType() {
        return this.inputStream.read();
    }

    RecordedEvent getNextEvent() {
        RecordedEvent event = null;
        int length = this.inputStream.read();
        if (length == 255) {
            // empty if block
        }
        byte[] eventByteArray = new byte[length];
        this.inputStream.read(eventByteArray, 0, length);
        event = RecordedEvent.recreateRecordedEvent(eventByteArray, 0, length);
        return event;
    }

    byte[] getCapture() {
        int length = this.inputStream.read();
        byte[] captureByteArray = new byte[length];
        this.inputStream.read(captureByteArray, 0, length);
        return captureByteArray;
    }
}

