/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.lcdui;

import com.sun.midp.lcdui.AutomatedEventHandler;
import com.sun.midp.lcdui.DisplayManager;
import com.sun.midp.lcdui.DisplayManagerFactory;
import com.sun.midp.lcdui.SystemEventDispatcher;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;

public class EmulEventHandler
extends AutomatedEventHandler {
    static final int SPECIAL_COPYTEXT = 10;
    static final int SPECIAL_PASTETEXT = 11;
    static final int SPECIAL_CUTTEXT = 12;
    private DisplayManager displayManager = DisplayManagerFactory.getDisplayManager();
    private Displayable currentWidget = null;
    private Item currentItem = null;
    private String currentWidgetStr = "None";
    private String currentItemStr = "None";

    public int getSystemKey(int keyCode) {
        return EmulEventHandler.getSystemKeyImpl(keyCode);
    }

    public int getGameAction(int keyCode) {
        return EmulEventHandler.getGameActionImpl(keyCode);
    }

    static native int getSystemKeyImpl(int var0);

    static native int getGameActionImpl(int var0);

    private native void addToCommandSet(Command var1, boolean var2);

    private native void closeCommandSet();

    private native void setCopyText(String var1);

    private native String getPasteText();

    public void updateCommandSet(Command[] itemCommands, int numItemCommands, Command[] commands, int numCommands) {
        this.updateCommandSet(itemCommands, numItemCommands, commands, numCommands, null, null);
    }

    public void updateCommandSet(Command[] itemCommands, int numItemCommands, Command[] commands, int numCommands, Displayable disp, Item item) {
        int i;
        for (i = 0; i < numCommands; ++i) {
            this.addToCommandSet(commands[i], true);
        }
        for (i = 0; i < numItemCommands; ++i) {
            this.addToCommandSet(itemCommands[i], false);
        }
        this.closeCommandSet();
        this.updateWidget(disp, item);
    }

    private native void setCurrentWidget(String var1, String var2);

    boolean menuKeyEvent(int type, int code) {
        return true;
    }

    boolean menuPointerEvent(int type, int x, int y) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void screenChangeEvent(Display parent, Displayable d) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                this.updateWidget(d, null);
                this.displayManager.screenChange(parent, d);
            }
        }
        catch (Throwable t) {
            EmulEventHandler.handleThrowable(t);
        }
    }

    void systemEvent(int type) {
        if (type == 10) {
            this.setCopyText(this.getCopyText());
        } else if (type == 11) {
            this.setPasteText(this.getPasteText());
        } else if (type == 12) {
            this.setCopyText(this.getCutText());
        } else if (!SystemEventDispatcher.handleEvent(type)) {
            super.systemEvent(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCopyText() {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                if (this.currentItemStr.equals("StringItem")) {
                    return ((StringItem)this.currentItem).getText();
                }
                if (this.currentItemStr.equals("TextField")) {
                    return ((TextField)this.currentItem).getString();
                }
                if (this.currentWidgetStr.equals("TextBox")) {
                    return ((TextBox)this.currentWidget).getString();
                }
                if (this.currentWidgetStr.equals("Alert")) {
                    return ((Alert)this.currentWidget).getString();
                }
            }
        }
        catch (Throwable t) {
            EmulEventHandler.handleThrowable(t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCutText() {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                if (this.currentItemStr.equals("TextField")) {
                    TextField tf = (TextField)this.currentItem;
                    String text = tf.getString();
                    tf.setString(null);
                    return text;
                }
                if (this.currentWidgetStr.equals("TextBox")) {
                    TextBox tb = (TextBox)this.currentWidget;
                    String text = tb.getString();
                    tb.setString(null);
                    return text;
                }
            }
        }
        catch (Throwable t) {
            EmulEventHandler.handleThrowable(t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPasteText(String str) {
        char[] text = new char[str.length()];
        str.getChars(0, str.length(), text, 0);
        try {
            Object object = this.eventLock;
            synchronized (object) {
                if (this.currentItemStr.equals("TextField")) {
                    TextField tf = (TextField)this.currentItem;
                    int inlen = tf.getMaxSize() - tf.size() > text.length ? text.length : tf.getMaxSize() - tf.size();
                    tf.insert(text, 0, inlen, tf.getCaretPosition());
                } else if (this.currentWidgetStr.equals("TextBox")) {
                    TextBox tb = (TextBox)this.currentWidget;
                    int inlen = tb.getMaxSize() - tb.size() > text.length ? text.length : tb.getMaxSize() - tb.size();
                    tb.insert(text, 0, inlen, tb.getCaretPosition());
                }
            }
        }
        catch (IllegalArgumentException iae) {
        }
        catch (Throwable t) {
            EmulEventHandler.handleThrowable(t);
        }
    }

    private synchronized void updateWidget(Displayable widget, Item item) {
        if (widget == null) {
            if (this.currentWidget != null) {
                this.currentWidget = null;
                this.currentWidgetStr = "None";
                this.currentItemStr = "None";
            }
        } else {
            if (this.currentItem != item) {
                this.currentItem = item;
                this.currentItemStr = this.currentItem != null ? (this.currentItem instanceof TextField ? "TextField" : (this.currentItem instanceof StringItem ? "StringItem" : item.getClass().toString())) : "None";
            }
            if (this.currentWidget != widget || widget instanceof Form) {
                this.currentWidget = widget;
                if (widget instanceof TextBox) {
                    this.currentWidgetStr = "TextBox";
                } else if (widget instanceof Canvas) {
                    this.currentWidgetStr = "Canvas" + Integer.toHexString(widget.hashCode());
                } else if (widget instanceof Form) {
                    Form form = (Form)widget;
                    int numItems = form.size();
                    String mmitemstr = "";
                    for (int i = 0; i < numItems; ++i) {
                        Item fitem = form.get(i);
                        if (!fitem.getClass().getName().endsWith("2$MMItem")) continue;
                        mmitemstr = mmitemstr + ":" + Integer.toHexString(fitem.hashCode());
                    }
                    this.currentWidgetStr = !mmitemstr.equals("") ? mmitemstr : widget.getClass().toString();
                } else {
                    this.currentWidgetStr = widget instanceof Alert ? "Alert" : widget.getClass().toString();
                }
            }
        }
        this.setCurrentWidget(this.currentWidgetStr, this.currentItemStr);
    }
}

