/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.ssl;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.publickeystore.WebPublicKeyStore;
import com.sun.midp.security.SecurityToken;
import com.sun.midp.ssl.SSLStreamConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.SecureConnection;
import javax.microedition.io.SecurityInfo;

public class Protocol
implements SecureConnection,
ConnectionBaseInterface {
    private static SecurityToken classSecurityToken;
    private static final int SECURE_HTTP_PORT = 443;
    private com.sun.midp.io.j2me.socket.Protocol tcpConnection;
    private SSLStreamConnection sslConnection;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite midletSuite = scheduler.getMIDletSuite();
        try {
            midletSuite.checkForPermission(5, "ssl:" + name);
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException("Interrupted while trying to ask the user permission");
        }
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\"");
        }
        HttpUrl url = new HttpUrl("ssl", name);
        if (!midletSuite.isTrusted() && url.port == 443) {
            throw new SecurityException("Target port denied to untrusted applicatons");
        }
        if (url.path != null || url.query != null || url.fragment != null) {
            throw new IllegalArgumentException("Malformed address");
        }
        this.tcpConnection = new com.sun.midp.io.j2me.socket.Protocol();
        this.tcpConnection.openPrim(classSecurityToken, "//" + url.authority);
        try {
            OutputStream tcpOutputStream = this.tcpConnection.openOutputStream();
            try {
                InputStream tcpInputStream = this.tcpConnection.openInputStream();
                try {
                    WebPublicKeyStore.loadCertificateAuthorities();
                    this.sslConnection = new SSLStreamConnection(url.host, url.port, tcpInputStream, tcpOutputStream);
                }
                catch (IOException e) {
                    tcpInputStream.close();
                    throw e;
                }
            }
            catch (IOException e) {
                tcpOutputStream.close();
                throw e;
            }
        }
        catch (IOException e) {
            this.tcpConnection.close();
            throw e;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.sslConnection.close();
        }
        finally {
            this.tcpConnection.close();
        }
    }

    public InputStream openInputStream() throws IOException {
        return this.sslConnection.openInputStream();
    }

    public DataInputStream openDataInputStream() throws IOException {
        return this.sslConnection.openDataInputStream();
    }

    public OutputStream openOutputStream() throws IOException {
        return this.sslConnection.openOutputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return this.sslConnection.openDataOutputStream();
    }

    public void setSocketOption(byte option, int value) throws IllegalArgumentException, IOException {
        this.tcpConnection.setSocketOption(option, value);
    }

    public int getSocketOption(byte option) throws IllegalArgumentException, IOException {
        return this.tcpConnection.getSocketOption(option);
    }

    public String getLocalAddress() throws IOException {
        return this.tcpConnection.getLocalAddress();
    }

    public int getLocalPort() throws IOException {
        return this.tcpConnection.getLocalPort();
    }

    public String getAddress() throws IOException {
        return this.tcpConnection.getAddress();
    }

    public int getPort() throws IOException {
        return this.tcpConnection.getPort();
    }

    public SecurityInfo getSecurityInfo() throws IOException {
        return this.sslConnection.getSecurityInfo();
    }
}

