/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.socket;

import com.sun.cldc.io.Waiter;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.NetworkConnectionBase;
import com.sun.midp.io.Util;
import com.sun.midp.io.j2me.serversocket.Socket;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.Connection;
import javax.microedition.io.SocketConnection;

public class Protocol
extends NetworkConnectionBase
implements SocketConnection {
    protected static int bufferSize;
    private String host;
    private int port;
    private boolean outputShutdown;
    private boolean permissionChecked;
    private boolean isOwnerTrusted;
    private SecurityToken ownerSecurityToken = null;
    private static final String protocol = "TCP";

    public Protocol() {
        super(bufferSize);
    }

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\"");
        }
        HttpUrl url = new HttpUrl("socket", name);
        if (url.path != null || url.query != null || url.fragment != null) {
            throw new IllegalArgumentException("Malformed address");
        }
        this.host = url.host;
        this.port = url.port;
        if (this.host != null) {
            return super.openPrim(name, mode, timeouts);
        }
        Socket con = this.getServersocketClass();
        con.open(this.ownerSecurityToken, this.port);
        return con;
    }

    protected final void checkForPermission(SecurityToken token, String name) throws InterruptedIOException {
        if (this.permissionChecked) {
            return;
        }
        this.checkForPermission(token, 3, name, protocol);
        this.permissionChecked = true;
        if (token != null) {
            this.ownerSecurityToken = token;
            this.isOwnerTrusted = true;
            return;
        }
        MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
        this.isOwnerTrusted = midletSuite == null ? true : midletSuite.isTrusted();
    }

    public void connect(String name, int mode, boolean timeouts) throws IOException {
        if (!this.permissionChecked) {
            throw new SecurityException("The permission check was bypassed");
        }
        if (!(this.isOwnerTrusted || this.port != 80 && this.port != 8080 && this.port != 443)) {
            throw new SecurityException("Target port denied to untrusted applications");
        }
        if (this.port < 0) {
            throw new IllegalArgumentException("Missing port number");
        }
        byte[] szHost = Util.toCString(this.host);
        this.open0(szHost, this.port);
        this.registerCleanup();
    }

    public void open(SecurityToken token, int handle) {
        this.handle = handle;
        try {
            this.connectionOpen = true;
            this.checkForPermission(token, this.getAddress());
        }
        catch (Exception e2) {
            SecurityException e2;
            this.connectionOpen = false;
            if (e2 instanceof IOException) {
                e2 = new SecurityException("Unknown TCP client");
            }
            try {
                this.close0();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw (RuntimeException)e2;
        }
        this.registerCleanup();
    }

    public void disconnect() throws IOException {
        if (!this.outputShutdown) {
            this.shutdownOutput0();
        }
        this.close0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int nonBufferedRead(byte[] b, int off, int len) throws IOException {
        while (true) {
            int bytesRead;
            try {
                bytesRead = this.read0(b, off, len);
            }
            finally {
                if (this.iStreams == 0) {
                    throw new InterruptedIOException("Stream closed");
                }
            }
            if (bytesRead == -1) {
                this.eof = true;
                return -1;
            }
            if (bytesRead != 0) {
                return bytesRead;
            }
            Waiter.waitForIO();
        }
    }

    public int available() throws IOException {
        if (this.count > 0) {
            return this.count;
        }
        return this.available0();
    }

    public int writeBytes(byte[] b, int off, int len) throws IOException {
        return this.write0(b, off, len);
    }

    protected void closeOutputStream() throws IOException {
        this.shutdownOutput0();
        this.outputShutdown = true;
        super.closeOutputStream();
    }

    private void checkOption(byte option) throws IllegalArgumentException {
        if (option == 2 || option == 1 || option == 4 || option == 3 || option == 0) {
            return;
        }
        throw new IllegalArgumentException("Unsupported Socket Option");
    }

    public void setSocketOption(byte option, int value) throws IllegalArgumentException, IOException {
        this.checkOption(option);
        if (value < 0) {
            throw new IllegalArgumentException("Unsupported Socket Option");
        }
        this.ensureOpen();
        this.setSockOpt0(option, value);
    }

    public int getSocketOption(byte option) throws IllegalArgumentException, IOException {
        this.checkOption(option);
        this.ensureOpen();
        return this.getSockOpt0(option);
    }

    public String getLocalAddress() throws IOException {
        this.ensureOpen();
        return this.getHost0(true);
    }

    public int getLocalPort() throws IOException {
        this.ensureOpen();
        return this.getPort0(true);
    }

    public String getAddress() throws IOException {
        this.ensureOpen();
        return this.getHost0(false);
    }

    public int getPort() throws IOException {
        this.ensureOpen();
        return this.getPort0(false);
    }

    private native void open0(byte[] var1, int var2) throws IOException;

    private native int read0(byte[] var1, int var2, int var3) throws IOException;

    private native int write0(byte[] var1, int var2, int var3) throws IOException;

    private native int available0() throws IOException;

    private native void close0() throws IOException;

    private native void registerCleanup();

    private native void finalize();

    private native String getHost0(boolean var1);

    private native int getPort0(boolean var1);

    private native int getSockOpt0(int var1);

    private native void setSockOpt0(int var1, int var2);

    private native void shutdownOutput0();

    protected Socket getServersocketClass() {
        return new Socket();
    }

    static {
        String size = Configuration.getProperty("com.sun.midp.io.j2me.socket.buffersize");
        if (size != null) {
            try {
                bufferSize = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

