/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.sms;

import com.sun.midp.io.j2me.sms.TextEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

public class DatagramRecord {
    private static int INITIAL_SIZE = 10;
    private Vector keys = new Vector(INITIAL_SIZE);
    private Vector vals = new Vector(INITIAL_SIZE);
    private byte[] data = null;

    public String getHeader(String key) {
        int idx;
        if (key == null) {
            throw new NullPointerException();
        }
        for (idx = 0; idx < this.keys.size() && !key.equals(this.keys.elementAt(idx)); ++idx) {
        }
        String rv = null;
        if (idx != this.keys.size()) {
            rv = (String)this.vals.elementAt(idx);
        }
        return rv;
    }

    public synchronized String setHeader(String key, String value) {
        int idx;
        for (idx = 0; idx < this.keys.size() && !key.equals(this.keys.elementAt(idx)); ++idx) {
        }
        String rv = null;
        if (idx == this.keys.size()) {
            this.keys.addElement(key);
            this.vals.addElement(value);
        } else {
            rv = (String)this.vals.elementAt(idx);
            this.vals.setElementAt(value, idx);
        }
        return rv;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] buffer) {
        this.data = buffer;
    }

    public boolean addData(DatagramRecord rec) throws IOException {
        if (rec != null && !rec.getHeader("Date").equals(this.getHeader("Date"))) {
            throw new IOException("Bad fragmentation");
        }
        String total = rec != null ? rec.getHeader("Total-Size") : null;
        String cl = this.getHeader("Content-Length");
        String fr = this.getHeader("Fragment-Size");
        int len = 0;
        int contentlength = 0;
        try {
            contentlength = Integer.parseInt(cl);
        }
        catch (NumberFormatException npe) {
            // empty catch block
        }
        if (total == null) {
            len = this.data.length;
            byte[] newbuf = new byte[contentlength];
            if (this.data != null) {
                System.arraycopy(this.data, 0, newbuf, 0, this.data.length);
            }
            total = String.valueOf(this.data.length);
            this.setHeader("Total-Size", total);
            this.data = newbuf;
        } else {
            int offset = 0;
            int size = 0;
            try {
                offset = Integer.parseInt(this.getHeader("Fragment-Offset"));
            }
            catch (NumberFormatException npe) {
                // empty catch block
            }
            try {
                len = Integer.parseInt(this.getHeader("Fragment-Size"));
            }
            catch (NumberFormatException npe) {
                // empty catch block
            }
            byte[] newbuf = rec.getData();
            System.arraycopy(this.data, 0, newbuf, offset, len);
            this.data = newbuf;
            try {
                size = Integer.parseInt(total);
                size += len;
            }
            catch (NumberFormatException npe) {
                // empty catch block
            }
            total = String.valueOf(size);
            this.setHeader("Total-Size", total);
            len = size;
        }
        return len == contentlength;
    }

    public boolean parseData(byte[] buf, int length) {
        int colon = 0;
        int endofline = 0;
        int startofline = 0;
        String field = null;
        String value = null;
        int segments = 0;
        boolean colon_found = false;
        for (int i = 0; i < length; ++i) {
            if (!colon_found && buf[i] == 58) {
                colon = i;
                colon_found = true;
                field = new String(buf, startofline, colon - startofline);
            }
            if (buf[i] != 10) continue;
            endofline = i;
            value = new String(buf, colon + 1, endofline - colon - 1).trim();
            if (field.startsWith("Buffer")) {
                int startofdata = endofline + 1;
                this.data = new byte[length - startofdata];
                int j = startofdata;
                int k = 0;
                while (j < length) {
                    this.data[k] = buf[j];
                    ++j;
                    ++k;
                    ++i;
                }
            } else {
                this.setHeader(field, value);
            }
            startofline = endofline + 1;
            colon_found = false;
        }
        try {
            segments = Integer.parseInt(this.getHeader("Segments"));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return segments > 1;
    }

    public byte[] getFormattedData() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < this.keys.size(); ++i) {
                bos.write(((String)this.keys.elementAt(i) + ": " + (String)this.vals.elementAt(i) + "\n").getBytes());
            }
            bos.write("Buffer: \n".getBytes());
            bos.write(this.data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.keys.size(); ++i) {
            sb.append(this.keys.elementAt(i) + ": " + (String)this.vals.elementAt(i) + "\n");
        }
        if (this.getHeader("Content-Type").equals("text")) {
            String textbuf;
            String te = this.getHeader("Text-Encoding");
            if (te == null || te.equals("ucs2")) {
                textbuf = TextEncoder.toString(this.data);
            } else {
                byte[] gsmbytes = TextEncoder.decode(this.data);
                textbuf = TextEncoder.toString(gsmbytes);
            }
            sb.append("Buffer: " + textbuf + "\n");
        } else {
            sb.append("Buffer: (binary)\n" + new String(this.data) + "\n");
        }
        return sb.toString();
    }
}

