/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.http;

import com.sun.midp.io.Base64;
import com.sun.midp.io.ConnectionBaseAdapter;
import com.sun.midp.io.DateParser;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.Properties;
import com.sun.midp.io.j2me.http.StreamConnectionElement;
import com.sun.midp.io.j2me.http.StreamConnectionPool;
import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.StreamConnection;

public class Protocol
extends ConnectionBaseAdapter
implements HttpConnection {
    protected static final String HTTP_VERSION_10 = "HTTP/1.0";
    protected static final String HTTP_VERSION_11 = "HTTP/1.1";
    protected static String HTTP_VERSION;
    protected static final String UNTRUSTED_TOKEN = "UNTRUSTED/1.0";
    private static final int HTTP_OUTPUT_DATA_OFFSET = 24;
    private static final int HTTP_OUTPUT_EXTRA_ROOM = 8;
    private static SecurityToken classSecurityToken;
    private static int inputBufferSize;
    private static int outputBufferSize;
    private static int outputDataSize;
    private static String http_proxy;
    private static String proxyAuthentication;
    private static int maxNumberOfPersistentConnections;
    private static long connectionLingerTime;
    private static StreamConnectionPool connectionPool;
    private static boolean nonPersistentFlag;
    private static boolean useChunks;
    private ByteArrayOutputStream writeStreamBuff;
    protected String saved_url;
    protected int default_port = 80;
    protected HttpUrl url;
    protected String hostAndPort;
    protected int responseCode = -1;
    protected String responseMsg;
    protected Properties reqProperties;
    protected Properties headerFields;
    protected String method = "GET";
    private StreamConnection streamConnection;
    protected DataOutputStream streamOutput;
    protected DataInputStream streamInput;
    private StringBuffer stringbuffer;
    private String httpVer = null;
    private boolean ConnectionCloseFlag;
    private int contentLength = -1;
    private int chunksize = -1;
    private int totalbytesread;
    private boolean chunkedIn;
    private boolean chunkedOut;
    private boolean firstChunkSent;
    private boolean sendingRequest;
    private boolean requestFinished;
    private boolean eof;
    private byte[] readbuf;
    private int bytesleft;
    private int bytesread;
    private byte[] writebuf;
    private int bytesToWrite;
    private Properties proxyHeaders = new Properties();
    private byte handshakeError;
    private boolean readInProgress;
    private boolean permissionChecked;
    private boolean isOwnerTrusted;
    protected String protocol = "http";

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public Protocol() {
        this.reqProperties = new Properties();
        this.headerFields = new Properties();
        this.stringbuffer = new StringBuffer(32);
        String amsURL = System.getProperty("ams.url");
        if (amsURL != null) {
            int sepIndex = amsURL.indexOf("//");
            int hostIndex = amsURL.indexOf("localhost");
            if (sepIndex != -1 && sepIndex == hostIndex - 2) {
                String portStr = amsURL.substring(hostIndex + 10, amsURL.indexOf("/", hostIndex));
                try {
                    this.default_port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        if (nonPersistentFlag) {
            this.ConnectionCloseFlag = true;
        }
        this.readbuf = new byte[inputBufferSize];
        if (!useChunks) {
            this.writeStreamBuff = new ByteArrayOutputStream();
        }
    }

    protected void checkForPermission(SecurityToken token, String name) throws InterruptedIOException {
        if (this.permissionChecked) {
            return;
        }
        this.checkForPermission(token, 2, name, "http");
        this.permissionChecked = true;
        MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
        this.isOwnerTrusted = midletSuite == null ? true : midletSuite.isTrusted();
    }

    protected void connect(String name, int mode, boolean timeouts) throws IOException, IllegalArgumentException, ConnectionNotFoundException {
        this.saved_url = name;
        this.url = new HttpUrl(this.protocol, name);
        if (this.url.port == -1) {
            this.url.port = this.default_port;
        }
        if (this.url.host == null) {
            throw new IllegalArgumentException("missing host in URL");
        }
        this.hostAndPort = this.url.host + ":" + this.url.port;
    }

    public InputStream openInputStream() throws IOException {
        InputStream in = super.openInputStream();
        this.sendRequest();
        return in;
    }

    public OutputStream openOutputStream() throws IOException {
        OutputStream out = super.openOutputStream();
        this.writebuf = new byte[outputBufferSize];
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readBytes(byte[] b, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        DataInputStream dataInputStream = this.streamInput;
        synchronized (dataInputStream) {
            this.readInProgress = true;
        }
        try {
            int rc;
            if (this.chunkedIn || this.chunksize > 0) {
                int n = this.readBytesChunked(b, off, len);
                return n;
            }
            if (this.bytesleft == 0) {
                if (len >= inputBufferSize) {
                    rc = this.streamInput.read(b, off, len);
                } else {
                    this.bytesleft = rc = this.streamInput.read(this.readbuf, 0, inputBufferSize);
                    this.bytesread = 0;
                }
                if (rc == -1) {
                    this.eof = true;
                    int n = -1;
                    return n;
                }
                this.totalbytesread += rc;
                if (this.bytesleft == 0) {
                    int n = rc;
                    return n;
                }
            }
            int n = rc = this.readFromBuffer(b, off, len);
            return n;
        }
        finally {
            DataInputStream dataInputStream2 = this.streamInput;
            synchronized (dataInputStream2) {
                this.readInProgress = false;
            }
        }
    }

    private int readFromBuffer(byte[] b, int off, int len) throws IOException {
        int rc = len > this.bytesleft ? this.bytesleft : len;
        System.arraycopy(this.readbuf, this.bytesread, b, off, rc);
        this.bytesleft -= rc;
        this.bytesread += rc;
        return rc;
    }

    public int available() throws IOException {
        if (!this.requestFinished || this.eof) {
            return 0;
        }
        if (this.bytesleft > 0) {
            return this.bytesleft;
        }
        if (this.chunkedIn && this.totalbytesread == this.chunksize) {
            return this.readChunkSizeNonBlocking();
        }
        int bytesAvailable = this.streamInput.available();
        if (this.chunksize <= bytesAvailable) {
            return this.chunksize;
        }
        return bytesAvailable;
    }

    int readChunkSizeNonBlocking() throws IOException {
        int len = this.streamInput.available();
        int sblen = this.stringbuffer.length();
        char lastchar = '\u0000';
        if (sblen > 0) {
            lastchar = this.stringbuffer.charAt(sblen - 1);
        }
        int size = -1;
        while (len > 0) {
            char c = (char)this.streamInput.read();
            if (lastchar == '\r' && c == '\n') {
                this.stringbuffer.setLength(this.stringbuffer.length() - 1);
                if (this.stringbuffer.length() > 0) {
                    try {
                        String temp = this.stringbuffer.toString();
                        int semi = temp.indexOf(59);
                        if (semi > 0) {
                            temp = temp.substring(0, semi);
                        }
                        this.stringbuffer.setLength(0);
                        size = Integer.parseInt(temp, 16);
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("invalid chunk size number format");
                    }
                }
            } else {
                this.stringbuffer.append(c);
                lastchar = c;
            }
            --len;
        }
        if (size < 0) {
            return 0;
        }
        this.chunksize = size;
        if (size == 0) {
            this.eof = true;
            return 0;
        }
        this.totalbytesread = 0;
        return this.chunksize < len ? this.chunksize : len;
    }

    protected int readBytesChunked(byte[] b, int off, int len) throws IOException {
        int rc;
        if (this.bytesleft == 0) {
            int bytesToRead;
            if (this.totalbytesread == this.chunksize) {
                if (!this.chunkedIn) {
                    this.eof = true;
                    return -1;
                }
                this.skipEndOfChunkCRLF();
                this.chunksize = this.readChunkSize();
                if (this.chunksize == 0) {
                    this.eof = true;
                    return -1;
                }
                this.totalbytesread = 0;
            }
            if (len >= (bytesToRead = this.chunksize - this.totalbytesread)) {
                rc = this.streamInput.read(b, off, bytesToRead);
            } else if (len >= inputBufferSize) {
                rc = this.streamInput.read(b, off, len);
            } else {
                rc = inputBufferSize >= bytesToRead ? this.streamInput.read(this.readbuf, 0, bytesToRead) : this.streamInput.read(this.readbuf, 0, inputBufferSize);
                this.bytesleft = rc;
                this.bytesread = 0;
            }
            if (rc == -1) {
                this.eof = true;
                throw new IOException("unexpected end of stream");
            }
            this.totalbytesread += rc;
            if (this.bytesleft == 0) {
                return rc;
            }
        }
        rc = this.readFromBuffer(b, off, len);
        return rc;
    }

    private int readChunkSize() throws IOException {
        int size = -1;
        try {
            char ch;
            int i;
            String chunk = null;
            try {
                chunk = this.readLine(this.streamInput);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (chunk == null) {
                throw new IOException("No Chunk Size");
            }
            for (i = 0; i < chunk.length() && Character.digit(ch = chunk.charAt(i), 16) != -1; ++i) {
            }
            size = Integer.parseInt(chunk.substring(0, i), 16);
        }
        catch (NumberFormatException e) {
            throw new IOException("invalid chunk size number format");
        }
        return size;
    }

    private void skipEndOfChunkCRLF() throws IOException {
        if (this.stringbuffer.length() > 1) {
            return;
        }
        if (this.stringbuffer.length() == 1) {
            if (this.stringbuffer.charAt(0) != '\r') {
                return;
            }
            this.stringbuffer.setLength(0);
            int ch = this.streamInput.read();
            if (ch != 10) {
                throw new IOException("missing the LF of an expected CRLF");
            }
            return;
        }
        int ch = this.streamInput.read();
        if (ch != 13) {
            this.stringbuffer.append(ch);
            return;
        }
        ch = this.streamInput.read();
        if (ch != 10) {
            throw new IOException("missing the LF of an expected CRLF");
        }
    }

    protected int writeBytes(byte[] b, int off, int len) throws IOException {
        int bytesToCopy;
        if (this.requestFinished) {
            throw new IllegalStateException("Write attempted after request finished");
        }
        if (!useChunks) {
            this.writeStreamBuff.write(b, off, len);
            this.bytesToWrite += len;
            return len;
        }
        if (this.bytesToWrite == outputDataSize) {
            this.sendRequest(true, false);
        }
        if (len < (bytesToCopy = outputDataSize - this.bytesToWrite)) {
            bytesToCopy = len;
        }
        System.arraycopy(b, off, this.writebuf, 24 + this.bytesToWrite, bytesToCopy);
        this.bytesToWrite += bytesToCopy;
        return bytesToCopy;
    }

    public void flush() throws IOException {
        if (this.requestFinished) {
            throw new IllegalStateException("Flush attempted after request finished");
        }
        if (this.bytesToWrite > 0 && useChunks) {
            this.sendRequest(true, false);
        }
    }

    public String getURL() {
        return this.protocol + ":" + this.saved_url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.url.host;
    }

    public String getFile() {
        return this.url.path;
    }

    public String getRef() {
        return this.url.fragment;
    }

    public String getQuery() {
        return this.url.query;
    }

    public int getPort() {
        return this.url.port;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public void setRequestMethod(String method) throws IOException {
        this.ensureOpen();
        if (this.streamConnection != null) {
            throw new IOException("connection already open");
        }
        if (this.maxOStreams == 0) {
            return;
        }
        if (!(method.equals("HEAD") || method.equals("GET") || method.equals("POST"))) {
            throw new IOException("unsupported method: " + method);
        }
        this.method = method;
    }

    public String getRequestProperty(String key) {
        if (key.startsWith("Proxy-")) {
            return this.proxyHeaders.getProperty(key);
        }
        return this.reqProperties.getProperty(key);
    }

    public void setRequestProperty(String key, String value) throws IOException {
        int index = 0;
        this.ensureOpen();
        if (this.streamConnection != null) {
            throw new IOException("connection already open");
        }
        if (this.maxOStreams == 0) {
            return;
        }
        while ((index = value.indexOf("\r\n", index)) != -1) {
            if (HTTP_VERSION.equals(HTTP_VERSION_10)) {
                throw new IllegalArgumentException("illegal value found,folded headers are not supported by HTTP/1.0");
            }
            if ((index += 2) < value.length() && (value.charAt(index) == ' ' || value.charAt(index) == '\t')) continue;
            throw new IllegalArgumentException("illegal value found");
        }
        this.setRequestField(key, value);
    }

    protected void setRequestField(String key, String value) {
        if (key.startsWith("Proxy-")) {
            this.proxyHeaders.setProperty(key, value);
            return;
        }
        if (key.equals("Connection") && value.equals("close")) {
            this.ConnectionCloseFlag = true;
        }
        if (key.equals("Transfer-Encoding") && value.equals("chunked")) {
            this.chunkedOut = true;
        }
        this.reqProperties.setProperty(key, value);
    }

    public int getResponseCode() throws IOException {
        this.ensureOpen();
        this.sendRequest();
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        this.ensureOpen();
        this.sendRequest();
        return this.responseMsg;
    }

    public long getLength() {
        try {
            this.ensureOpen();
            this.sendRequest();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.contentLength;
    }

    public String getType() {
        try {
            return this.getHeaderField("content-type");
        }
        catch (IOException x) {
            return null;
        }
    }

    public String getEncoding() {
        try {
            return this.getHeaderField("content-encoding");
        }
        catch (IOException x) {
            return null;
        }
    }

    public long getExpiration() throws IOException {
        return this.getHeaderFieldDate("expires", 0L);
    }

    public long getDate() throws IOException {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() throws IOException {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public String getHeaderField(String name) throws IOException {
        this.ensureOpen();
        this.sendRequest();
        return this.headerFields.getProperty(name.toLowerCase());
    }

    public String getHeaderField(int index) throws IOException {
        this.ensureOpen();
        this.sendRequest();
        if (index >= this.headerFields.size()) {
            return null;
        }
        return this.headerFields.getValueAt(index);
    }

    public String getHeaderFieldKey(int index) throws IOException {
        this.ensureOpen();
        this.sendRequest();
        if (index >= this.headerFields.size()) {
            return null;
        }
        return this.headerFields.getKeyAt(index);
    }

    public int getHeaderFieldInt(String name, int def) throws IOException {
        this.ensureOpen();
        this.sendRequest();
        try {
            return Integer.parseInt(this.getHeaderField(name));
        }
        catch (IllegalArgumentException iae) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return def;
    }

    public long getHeaderFieldDate(String name, long def) throws IOException {
        this.ensureOpen();
        this.sendRequest();
        try {
            return DateParser.parse(this.getHeaderField(name));
        }
        catch (NumberFormatException nfe) {
        }
        catch (IllegalArgumentException iae) {
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        return def;
    }

    protected void sendRequest() throws IOException {
        this.sendRequest(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(boolean chunkData, boolean readResponseHeader) throws IOException {
        if (this.sendingRequest || this.requestFinished) {
            return;
        }
        this.sendingRequest = true;
        try {
            block13: {
                if (chunkData) {
                    this.chunkedOut = true;
                }
                int bytesToRetry = this.bytesToWrite;
                try {
                    this.startRequest();
                    this.sendRequestBody();
                    if (readResponseHeader) {
                        this.finishRequestGetResponseHeader();
                    }
                }
                catch (IOException ioe) {
                    if (!(this.streamConnection instanceof StreamConnectionElement)) {
                        throw ioe;
                    }
                    try {
                        connectionPool.remove((StreamConnectionElement)this.streamConnection);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (this.firstChunkSent) {
                        throw new IOException("Persistent connection dropped after first chunk sent, cannot retry");
                    }
                    this.streamConnection = null;
                    this.streamInput = null;
                    this.streamOutput = null;
                    this.bytesToWrite = bytesToRetry;
                    this.startRequest();
                    this.sendRequestBody();
                    if (!readResponseHeader) break block13;
                    this.finishRequestGetResponseHeader();
                }
            }
            if (this.chunkedOut) {
                this.firstChunkSent = true;
            }
        }
        finally {
            this.sendingRequest = false;
        }
    }

    private void startRequest() throws IOException {
        if (this.streamConnection != null) {
            return;
        }
        this.streamConnect();
        this.sendRequestHeader();
    }

    protected void streamConnect() throws IOException {
        if (!this.permissionChecked) {
            throw new SecurityException("The permission check was bypassed");
        }
        this.streamConnection = connectionPool.get(this.protocol, this.url.host, this.url.port);
        if (this.streamConnection == null) {
            this.streamConnection = this.connect();
        }
        if (this.streamOutput != null) {
            return;
        }
        this.streamOutput = this.streamConnection.openDataOutputStream();
        this.streamInput = this.streamConnection.openDataInputStream();
    }

    protected StreamConnection getStreamConnection() {
        return this.streamConnection;
    }

    private void sendRequestHeader() throws IOException {
        if (!this.isOwnerTrusted) {
            this.reqProperties.addProperty("User-Agent", UNTRUSTED_TOKEN);
        }
        if (this.getRequestProperty("Content-Length") == null) {
            this.setRequestField("Content-Length", Integer.toString(this.bytesToWrite));
        }
        StringBuffer reqLine = new StringBuffer(256);
        String filename = this.url.path;
        if (filename == null) {
            filename = "/";
        }
        reqLine.append(this.method);
        reqLine.append(" ");
        reqLine.append(filename);
        if (this.url.query != null) {
            reqLine.append("?");
            reqLine.append(this.url.query);
        }
        reqLine.append(" ");
        reqLine.append(HTTP_VERSION);
        reqLine.append("\r\n");
        this.setRequestField("Host", this.url.authority);
        if (this.chunkedOut) {
            this.setRequestField("Transfer-Encoding", "chunked");
        }
        int numberOfKeys = this.reqProperties.size();
        for (int i = 0; i < numberOfKeys; ++i) {
            String key = this.reqProperties.getKeyAt(i);
            if (key.equals("Content-Length")) {
                if (this.chunkedOut) continue;
                if (this.writebuf == null) {
                    reqLine.append("Content-Length: 0");
                } else {
                    reqLine.append("Content-Length: ");
                    reqLine.append(this.bytesToWrite);
                }
                reqLine.append("\r\n");
                continue;
            }
            reqLine.append(key);
            reqLine.append(": ");
            reqLine.append(this.reqProperties.getValueAt(i));
            reqLine.append("\r\n");
        }
        reqLine.append("\r\n");
        this.streamOutput.write(reqLine.toString().getBytes());
    }

    protected void sendRequestBody() throws IOException {
        if (this.bytesToWrite == 0) {
            return;
        }
        if (!useChunks) {
            byte[] buff = this.writeStreamBuff.toByteArray();
            this.streamOutput.write(buff, 0, buff.length);
            this.bytesToWrite = 0;
            return;
        }
        if (this.writebuf == null) {
            return;
        }
        int start = 24;
        int endOfData = 24 + this.bytesToWrite;
        int length = this.bytesToWrite;
        if (this.chunkedOut) {
            String temp = Integer.toHexString(this.bytesToWrite);
            int tempLen = temp.length();
            this.writebuf[--start] = 10;
            this.writebuf[--start] = 13;
            for (int i = tempLen - 1; i >= 0; --i) {
                this.writebuf[--start] = (byte)temp.charAt(i);
            }
            length += tempLen + 2;
            this.writebuf[endOfData++] = 13;
            this.writebuf[endOfData++] = 10;
            length += 2;
        }
        this.streamOutput.write(this.writebuf, start, length);
        this.bytesToWrite = 0;
    }

    protected void finishRequestGetResponseHeader() throws IOException {
        this.requestFinished = true;
        if (this.chunkedOut) {
            this.streamOutput.write("0\r\n\r\n".getBytes());
        }
        this.streamOutput.flush();
        this.readResponseMessage(this.streamInput);
        this.readHeaders(this.streamInput);
        if (this.responseCode == 100) {
            this.readResponseMessage(this.streamInput);
            this.readHeaders(this.streamInput);
        }
    }

    protected StreamConnection connect() throws IOException {
        if (!this.permissionChecked) {
            throw new SecurityException("The permission check was bypassed");
        }
        com.sun.midp.io.j2me.socket.Protocol conn = new com.sun.midp.io.j2me.socket.Protocol();
        if (http_proxy == null || this.hostAndPort.indexOf("localhost") > -1) {
            conn.openPrim(classSecurityToken, "//" + this.hostAndPort);
            conn.setSocketOption((byte)0, 0);
            return conn;
        }
        conn.openPrim(classSecurityToken, "//" + http_proxy);
        conn.setSocketOption((byte)0, 0);
        this.streamOutput = conn.openDataOutputStream();
        this.streamInput = conn.openDataInputStream();
        try {
            this.doTunnelHandshake(this.streamOutput, this.streamInput);
        }
        catch (IOException ioe) {
            String response = ioe.getMessage();
            try {
                this.disconnect(conn, this.streamInput, this.streamOutput);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.streamOutput = null;
            this.streamInput = null;
            if (response != null && response.indexOf(" 500 ") > -1) {
                throw new ConnectionNotFoundException(response);
            }
            throw ioe;
        }
        return conn;
    }

    protected void doTunnelHandshake(OutputStream os, InputStream is) throws IOException {
        String response;
        int c;
        String endOfLine;
        String emptyLine = endOfLine = "\r\n";
        String required = "CONNECT " + this.hostAndPort + " " + HTTP_VERSION + endOfLine;
        os.write(required.getBytes());
        if (proxyAuthentication != null) {
            byte[] data = proxyAuthentication.getBytes();
            String credentials = "Basic " + Base64.encode(data, 0, data.length);
            this.proxyHeaders.addProperty("Proxy-Authorization", credentials);
        }
        int numberOfKeys = this.proxyHeaders.size();
        for (int i = 0; i < numberOfKeys; ++i) {
            String optional = this.proxyHeaders.getKeyAt(i) + ": " + this.proxyHeaders.getValueAt(i) + endOfLine;
            os.write(optional.getBytes());
        }
        os.write(emptyLine.getBytes());
        os.flush();
        StringBuffer temp = new StringBuffer();
        boolean newline = false;
        while ((c = is.read()) != -1) {
            if (c == 10) {
                if (newline) break;
                newline = true;
            } else if (c != 13) {
                newline = false;
            }
            temp.append((char)c);
        }
        if (temp.length() == 0) {
            temp.append("none");
        }
        if ((response = temp.toString()).indexOf(" 200 ") == -1) {
            throw new IOException("Error initializing HTTP tunnel connection: \n" + response);
        }
    }

    private void readResponseMessage(InputStream in) throws IOException {
        String line = null;
        this.responseCode = -1;
        this.responseMsg = null;
        line = this.readLine(in);
        if (line != null && line.length() == 0) {
            line = this.readLine(in);
        }
        this.responseCode = -1;
        this.responseMsg = null;
        if (line == null) {
            throw new IOException("response empty");
        }
        int httpEnd = line.indexOf(32);
        if (httpEnd < 0) {
            if (line.length() > 10) {
                line = line.substring(0, 10);
            }
            throw new IOException("cannot find status code in response: " + line);
        }
        String temp = line.substring(0, httpEnd);
        if (!temp.startsWith("HTTP")) {
            if (httpEnd > 10) {
                temp = temp.substring(0, 10);
            }
            throw new IOException("response does not start with HTTP it starts with: " + temp);
        }
        this.httpVer = temp;
        if (line.length() <= httpEnd) {
            throw new IOException("status line ends after HTTP version");
        }
        int codeEnd = line.substring(httpEnd + 1).indexOf(32);
        if (codeEnd < 0) {
            throw new IOException("cannot find reason phrase in response");
        }
        if (line.length() <= (codeEnd += httpEnd + 1)) {
            throw new IOException("status line end after status code");
        }
        try {
            this.responseCode = Integer.parseInt(line.substring(httpEnd + 1, codeEnd));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("status code in response is not a number");
        }
        this.responseMsg = line.substring(codeEnd + 1);
    }

    private void readHeaders(InputStream in) throws IOException {
        String key = null;
        int prevPropIndex = this.headerFields.size() - 1;
        boolean firstLine = true;
        String prevValue = null;
        this.bytesleft = 0;
        this.chunksize = -1;
        this.bytesread = 0;
        this.totalbytesread = 0;
        this.chunkedIn = false;
        this.eof = false;
        while (true) {
            String value;
            String line;
            try {
                line = this.readLine(in);
            }
            catch (IOException ioe) {
                throw new IOException(ioe.getMessage());
            }
            if (line == null || line.equals("")) break;
            if (!(HTTP_VERSION.equals(HTTP_VERSION_10) || firstLine || line.charAt(0) != ' ' && line.charAt(0) != '\t')) {
                value = prevValue + "\r\n" + line;
                this.headerFields.setPropertyAt(prevPropIndex, value);
                prevValue = value;
                continue;
            }
            int index = line.indexOf(58);
            if (index < 0) {
                throw new IOException("malformed header field " + line);
            }
            key = line.substring(0, index).toLowerCase();
            if (key.length() == 0) {
                throw new IOException("malformed header field, no key " + line);
            }
            value = line.length() <= index + 1 ? "" : line.substring(index + 1).trim();
            if (key.equals("connection") && value.equals("close")) {
                this.ConnectionCloseFlag = true;
            }
            if (key.equals("transfer-encoding") && value.regionMatches(true, 0, "chunked", 0, value.length())) {
                this.chunkedIn = true;
            }
            if (key.equals("content-length")) {
                try {
                    this.contentLength = Integer.parseInt(value);
                }
                catch (IllegalArgumentException iae) {
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
            }
            this.headerFields.addProperty(key, value);
            firstLine = false;
            ++prevPropIndex;
            prevValue = value;
        }
        this.chunksize = this.method.equals("HEAD") ? 0 : (this.chunkedIn ? this.readChunkSize() : this.contentLength);
        if (this.chunksize == 0) {
            this.eof = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine(InputStream in) throws IOException {
        try {
            String line;
            while (true) {
                int c;
                if ((c = in.read()) < 0) {
                    String string = null;
                    return string;
                }
                if (c == 13) continue;
                if (c == 10) break;
                this.stringbuffer.append((char)c);
            }
            String string = line = this.stringbuffer.toString();
            return string;
        }
        finally {
            this.stringbuffer.setLength(0);
        }
    }

    protected void closeOutputStream() throws IOException {
        try {
            this.sendRequest();
            super.closeOutputStream();
        }
        catch (Exception e) {
            super.closeOutputStream();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() throws IOException {
        if (this.streamConnection == null) {
            return;
        }
        if (!this.eof && !this.chunkedIn && this.chunksize >= 0 && this.totalbytesread == this.chunksize) {
            this.eof = true;
        }
        DataInputStream dataInputStream = this.streamInput;
        synchronized (dataInputStream) {
            if (this.readInProgress) {
                this.ConnectionCloseFlag = true;
            }
        }
        if (!this.requestFinished || !this.eof || this.httpVer.equals(HTTP_VERSION_10) || this.ConnectionCloseFlag) {
            if (this.streamConnection instanceof StreamConnectionElement) {
                connectionPool.remove((StreamConnectionElement)this.streamConnection);
            } else {
                this.disconnect(this.streamConnection, this.streamInput, this.streamOutput);
            }
            return;
        }
        if (this.streamConnection instanceof StreamConnectionElement) {
            connectionPool.returnForReuse((StreamConnectionElement)this.streamConnection);
            return;
        }
        if (!connectionPool.add(this.protocol, this.url.host, this.url.port, this.streamConnection, this.streamOutput, this.streamInput)) {
            this.disconnect(this.streamConnection, this.streamInput, this.streamOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(StreamConnection connection, InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    static {
        int temp;
        HTTP_VERSION = HTTP_VERSION_11;
        inputBufferSize = 256;
        outputBufferSize = 2048;
        maxNumberOfPersistentConnections = 1;
        connectionLingerTime = 60000L;
        useChunks = true;
        http_proxy = Configuration.getProperty("com.sun.midp.io.http.proxy");
        proxyAuthentication = Configuration.getProperty("com.sun.midp.io.http.proxy_authentication");
        maxNumberOfPersistentConnections = 1;
        String flag = Configuration.getProperty("com.sun.midp.io.http.force_non_persistent");
        if (flag != null && flag.equals("true")) {
            nonPersistentFlag = true;
        }
        useChunks = (flag = Configuration.getProperty("com.sun.midp.io.http.use_chunks")) != null && flag.equals("true");
        String prop = Configuration.getProperty("com.sun.midp.io.http.max_persistent_connections");
        if (prop != null) {
            try {
                temp = Integer.parseInt(prop);
                if (temp <= 0) {
                    maxNumberOfPersistentConnections = temp;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((prop = Configuration.getProperty("com.sun.midp.io.http.persistent_connection_linger_time")) != null) {
            try {
                temp = Integer.parseInt(prop);
                if (temp >= 0) {
                    connectionLingerTime = temp;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        connectionPool = new StreamConnectionPool(maxNumberOfPersistentConnections, connectionLingerTime);
        prop = Configuration.getProperty("com.sun.midp.io.http.inputBufferSize");
        if (prop != null) {
            try {
                temp = Integer.parseInt(prop);
                if (temp <= 0) {
                    inputBufferSize = temp;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((prop = Configuration.getProperty("com.sun.midp.io.http.outputBufferSize")) != null) {
            try {
                temp = Integer.parseInt(prop);
                if (temp <= 0) {
                    outputBufferSize = temp;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        outputDataSize = outputBufferSize - 24 - 8;
        if (!useChunks && nonPersistentFlag) {
            HTTP_VERSION = HTTP_VERSION_10;
        }
    }
}

