/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.datagram;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.cldc.io.Waiter;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.NetworkConnectionBase;
import com.sun.midp.io.Util;
import com.sun.midp.io.j2me.datagram.DatagramObject;
import com.sun.midp.io.j2me.push.PushRegistryImpl;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Datagram;
import javax.microedition.io.UDPDatagramConnection;

public class Protocol
implements UDPDatagramConnection,
ConnectionBaseInterface {
    private static SecurityToken classSecurityToken;
    private int handle;
    private String host;
    private int port;
    private boolean open;
    private boolean ownerTrusted;

    public static void initSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            return;
        }
        classSecurityToken = token;
    }

    public Connection openPrim(SecurityToken token, String name, int mode, boolean timeouts) throws IOException {
        Scheduler scheduler = Scheduler.getScheduler();
        MIDletSuite midletSuite = scheduler.getMIDletSuite();
        int incommingPort = 0;
        HttpUrl url = new HttpUrl("datagram", name);
        if (url.path != null || url.query != null || url.fragment != null) {
            throw new IllegalArgumentException("Malformed address " + name);
        }
        this.host = url.host;
        this.port = url.port;
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with slash slash");
        }
        if (this.host == null) {
            try {
                if (token == null) {
                    midletSuite.checkForPermission(8, "UDP:" + name);
                } else {
                    token.checkIfPermissionAllowed(8);
                }
                this.ownerTrusted = midletSuite.isTrusted();
            }
            catch (SecurityException e) {
                PushRegistryImpl.checkInConnectionInternal(classSecurityToken, "datagram:" + name);
                throw e;
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted while trying to ask the user permission");
            }
            if (this.port > 0) {
                incommingPort = this.port;
            }
        } else {
            if (this.port < 0) {
                throw new IllegalArgumentException("Missing port number");
            }
            try {
                if (token == null) {
                    midletSuite.checkForPermission(7, "UDP:" + name);
                } else {
                    token.checkIfPermissionAllowed(7);
                }
                this.ownerTrusted = midletSuite.isTrusted();
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException("Interrupted while trying to ask the user permission");
            }
        }
        switch (mode) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode");
            }
        }
        String root = midletSuite.getStorageName();
        byte[] asciiStorage = Util.toCString(root);
        this.open0(incommingPort, asciiStorage);
        this.registerCleanup();
        this.open = true;
        return this;
    }

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        return this.openPrim(null, name, mode, timeouts);
    }

    void ensureOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Connection closed");
        }
    }

    public int getMaximumLength() throws IOException {
        this.ensureOpen();
        return this.getMaximumLength0();
    }

    public int getNominalLength() throws IOException {
        this.ensureOpen();
        return this.getNominalLength0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Datagram dgram) throws IOException {
        Datagram datagram = dgram;
        synchronized (datagram) {
            int port;
            int ipNumber;
            this.ensureOpen();
            int length = dgram.getLength();
            if (length < 0) {
                throw new IOException("Bad datagram length");
            }
            if (dgram instanceof DatagramObject) {
                DatagramObject dh = (DatagramObject)dgram;
                ipNumber = dh.ipNumber;
                if (ipNumber == 0) {
                    throw new IOException("No address in datagram");
                }
                port = dh.port;
            } else {
                String addr = dgram.getAddress();
                if (addr == null) {
                    throw new IOException("No address in datagram");
                }
                HttpUrl url = new HttpUrl(addr);
                String host = url.host;
                port = url.port;
                if (host == null) {
                    throw new IOException("Missing host");
                }
                if (port == -1) {
                    throw new IOException("Missing port");
                }
                ipNumber = Protocol.getIpNumber(Util.toCString(host));
                if (ipNumber == -1) {
                    throw new IOException("Invalid host");
                }
            }
            if (!this.ownerTrusted && port >= 9200 && port <= 9203) {
                throw new SecurityException("Target port denied to untrusted applications");
            }
            while (true) {
                int res;
                try {
                    res = this.send0(ipNumber, port, dgram.getData(), dgram.getOffset(), length);
                }
                finally {
                    if (!this.open) {
                        throw new InterruptedIOException("Socket closed");
                    }
                }
                if (res == dgram.getLength()) break;
                if (res != 0) {
                    throw new IOException("Failed to send datagram");
                }
                Waiter.waitForIO();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receive(Datagram dgram) throws IOException {
        Datagram datagram = dgram;
        synchronized (datagram) {
            long res;
            this.ensureOpen();
            int length = dgram.getLength();
            if (length <= 0) {
                throw new IOException("Bad datagram length");
            }
            while (true) {
                try {
                    res = this.receive0(dgram.getData(), dgram.getOffset(), length);
                }
                finally {
                    if (!this.open) {
                        throw new InterruptedIOException("Socket closed");
                    }
                }
                if (res != 0L) break;
                Waiter.waitForIO();
            }
            int count = (int)res & 0xFFFF;
            dgram.setLength(count);
            int ipNumber = (int)(res >> 32);
            String host = Protocol.getHostByAddr(ipNumber).trim();
            int port = (int)(res >> 16) & 0xFFFF;
            String addr = "datagram://" + host + ":" + port;
            if (dgram instanceof DatagramObject) {
                DatagramObject dh = (DatagramObject)dgram;
                dh.address = addr;
                dh.ipNumber = ipNumber;
                dh.port = port;
            } else {
                dgram.setAddress("datagram://" + host + ":" + port);
            }
        }
    }

    public void close() throws IOException {
        if (this.open) {
            this.open = false;
            this.close0();
        }
    }

    public Datagram newDatagram(int size) throws IOException {
        this.ensureOpen();
        if (size < 0) {
            throw new IllegalArgumentException("Size is negative");
        }
        byte[] buf = new byte[size];
        DatagramObject dgram = new DatagramObject(buf, size);
        if (this.host != null) {
            try {
                dgram.setAddress("datagram://" + this.host + ":" + this.port);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return dgram;
    }

    public Datagram newDatagram(int size, String addr) throws IOException {
        Datagram dgram = this.createDatagram(true, null, size);
        dgram.setAddress(addr);
        return dgram;
    }

    public Datagram newDatagram(byte[] buf, int size) throws IOException {
        return this.createDatagram(false, buf, size);
    }

    public Datagram newDatagram(byte[] buf, int size, String addr) throws IOException {
        Datagram dgram = this.createDatagram(false, buf, size);
        dgram.setAddress(addr);
        return dgram;
    }

    private Datagram createDatagram(boolean createBuffer, byte[] buf, int size) throws IOException {
        this.ensureOpen();
        if (size < 0) {
            throw new IllegalArgumentException("Size is negative");
        }
        if (createBuffer) {
            buf = new byte[size];
        } else {
            if (buf == null) {
                throw new IllegalArgumentException("Buffer is invalid");
            }
            if (size > buf.length) {
                throw new IllegalArgumentException("Size bigger than the buffer");
            }
        }
        DatagramObject dgram = new DatagramObject(buf, size);
        if (this.host != null) {
            dgram.setAddress("datagram://" + this.host + ":" + this.port);
        }
        return dgram;
    }

    public String getLocalAddress() throws IOException {
        this.ensureOpen();
        return this.getHost0();
    }

    public int getLocalPort() throws IOException {
        this.ensureOpen();
        return this.getPort0();
    }

    private native void open0(int var1, byte[] var2) throws IOException;

    private native int send0(int var1, int var2, byte[] var3, int var4, int var5) throws IOException;

    private native long receive0(byte[] var1, int var2, int var3) throws IOException;

    private native void close0() throws IOException;

    private native void registerCleanup();

    static native String getHostByAddr(int var0);

    static native int getIpNumber(byte[] var0);

    native int getMaximumLength0() throws IOException;

    native int getNominalLength0() throws IOException;

    private native void finalize();

    private native String getHost0();

    private native int getPort0();

    static {
        NetworkConnectionBase.initializeNativeNetwork();
    }
}

