/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.datagram;

import com.sun.midp.io.HttpUrl;
import com.sun.midp.io.Util;
import com.sun.midp.io.j2me.datagram.Protocol;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import javax.microedition.io.Datagram;

public class DatagramObject
implements Datagram {
    private static final int MAX_HOST_LENGTH = 256;
    private byte[] buffer;
    private int offset;
    private int length;
    String address;
    int ipNumber;
    int port;
    private int readWritePosition;

    public DatagramObject(byte[] buf, int len) {
        this.setData(buf, 0, len);
    }

    public String getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.buffer;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setAddress(String addr) {
        if (addr == null) {
            throw new IllegalArgumentException("Invalid address");
        }
        HttpUrl url = new HttpUrl(addr);
        if (url.scheme == null || !url.scheme.equals("datagram")) {
            throw new IllegalArgumentException("Invalid scheme");
        }
        if (url.path != null || url.query != null || url.fragment != null) {
            throw new IllegalArgumentException("Malformed address");
        }
        this.port = url.port;
        if (url.host == null) {
            throw new IllegalArgumentException("Missing host");
        }
        if (this.port == -1) {
            throw new IllegalArgumentException("Missing port");
        }
        int temp = Protocol.getIpNumber(Util.toCString(url.host));
        if (temp == -1) {
            throw new IllegalArgumentException("Invalid host");
        }
        this.ipNumber = temp;
        this.address = addr;
    }

    public void setAddress(Datagram reference) {
        this.setAddress(reference.getAddress());
    }

    public void setLength(int len) {
        this.setData(this.buffer, this.offset, len);
    }

    public void setData(byte[] buf, int off, int len) {
        if (len < 0 || off < 0 || buf == null || off > 0 && off == buf.length || len + off > buf.length || len + off < 0) {
            throw new IllegalArgumentException("Illegal length or offset");
        }
        this.buffer = buf;
        this.offset = off;
        this.length = len;
    }

    public void reset() {
        this.readWritePosition = 0;
        this.offset = 0;
        this.length = 0;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        if (this.readWritePosition >= this.length) {
            return 0L;
        }
        int min = Math.min((int)n, this.length - this.readWritePosition);
        this.readWritePosition += min;
        return min;
    }

    public int read() {
        if (this.readWritePosition >= this.length) {
            return -1;
        }
        return this.buffer[this.offset + this.readWritePosition++] & 0xFF;
    }

    public void write(int ch) throws IOException {
        if (this.offset + this.readWritePosition >= this.buffer.length) {
            throw new IOException("Buffer full");
        }
        this.buffer[this.offset + this.readWritePosition++] = (byte)ch;
        this.length = this.readWritePosition;
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    public void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    public void writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.write(bytearr);
    }

    public void writeFloat(float f) {
    }

    public void writeDouble(double d) {
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int ch = this.read();
            if (ch < 0) {
                throw new EOFException();
            }
            b[off + n++] = (byte)ch;
        }
    }

    public int skipBytes(int n) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < n && (cur = (int)this.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    public boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public int readUnsignedByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF((DataInput)((Object)this));
    }

    public float readFloat() {
        return 0.0f;
    }

    public double readDouble() {
        return 0.0;
    }
}

