/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.content;

import com.sun.midp.content.AppProxy;
import com.sun.midp.content.CHStore;
import com.sun.midp.content.ContentHandlerImpl;
import com.sun.midp.content.InvocationImpl;
import com.sun.midp.content.InvocationStore;
import com.sun.midp.content.ResponseListenerImpl;
import com.sun.midp.io.HttpUrl;
import com.sun.midp.security.SecurityInitializer;
import com.sun.midp.security.SecurityToken;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.content.ActionNameMap;
import javax.microedition.content.ContentHandler;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.Invocation;
import javax.microedition.content.Registry;
import javax.microedition.content.ResponseListener;

public final class RegistryImpl {
    private static final SecurityToken classSecurityToken = SecurityInitializer.getSecurityToken();
    private final Hashtable activeInvocations = new Hashtable();
    private static Hashtable registries;
    private static final Object mutex;
    private static Vector registeredTypes;
    private ResponseListenerImpl listenerImpl;
    private ContentHandlerImpl handlerImpl;
    private Registry registry;
    final AppProxy application;
    int responseCalls;
    private static final int BY_TYPE = 0;
    private static final int BY_SUFFIX = 1;
    private static final int BY_ACTION = 2;
    private static final int BY_ID = 3;

    public static RegistryImpl getRegistryImpl(String classname, Object token) throws ContentHandlerException {
        AppProxy.checkAPIPermission(token);
        return RegistryImpl.getRegistryImpl(classname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RegistryImpl getRegistryImpl(String classname) throws ContentHandlerException {
        RegistryImpl curr = null;
        Object object = mutex;
        synchronized (object) {
            curr = (RegistryImpl)registries.get(classname);
            if (curr != null) {
                if (curr.handlerImpl == null && !curr.application.isRegistered()) {
                    throw new ContentHandlerException("not a registered MIDlet", 1);
                }
                return curr;
            }
            curr = new RegistryImpl(classname);
            registries.put(classname, curr);
        }
        InvocationStore.setCleanup(curr.application.getStorageID(), classname, true);
        return curr;
    }

    private RegistryImpl(String classname) throws ContentHandlerException {
        try {
            this.application = AppProxy.getCurrent().forClass(classname);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ContentHandlerException("not an application", 1);
        }
        catch (IllegalArgumentException iae) {
            throw new ContentHandlerException("not an application", 1);
        }
        this.handlerImpl = this.getServer(this.application);
        if (this.handlerImpl == null && !this.application.isRegistered()) {
            throw new ContentHandlerException("not a registered MIDlet", 1);
        }
    }

    public void setRegistry(Registry newRegistry) {
        if (this.registry == null) {
            this.registry = newRegistry;
        }
    }

    public Registry getRegistry() {
        return this.registry;
    }

    static void cleanup(String suiteID, String classname) {
        InvocationImpl invoc = null;
        while ((invoc = InvocationStore.getCleanup(suiteID, classname)) != null) {
            invoc.setStatus(7);
        }
    }

    private static ContentHandlerImpl newHandler(String classname, String[] types, String[] suffixes, String[] actions, ActionNameMap[] actionnames, String id, String[] accessRestricted, AppProxy appl) throws IllegalArgumentException {
        if (id == null) {
            id = appl.getDefaultID();
        }
        ContentHandlerImpl handler = new ContentHandlerImpl(types, suffixes, actions, actionnames, id, accessRestricted);
        handler.classname = appl.getClassname();
        handler.storageID = appl.getStorageID();
        handler.appname = appl.getApplicationName();
        handler.version = appl.getVersion();
        handler.authority = appl.getAuthority();
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentHandlerImpl register(String classname, String[] types, String[] suffixes, String[] actions, ActionNameMap[] actionnames, String id, String[] accessRestricted) throws SecurityException, IllegalArgumentException, ClassNotFoundException, ContentHandlerException {
        this.application.checkRegisterPermission("register");
        AppProxy appl = this.application.forClass(classname);
        Object object = mutex;
        synchronized (object) {
            ContentHandlerImpl handler = RegistryImpl.newHandler(classname, types, suffixes, actions, actionnames, id, accessRestricted, appl);
            handler.dynamic = true;
            ContentHandlerImpl conflict = RegistryImpl.checkConflicts(handler, null, false);
            registeredTypes.removeElement(conflict);
            CHStore.postUpdate(handler);
            RegistryImpl.checkForUpdates();
            if (AppProxy.LOG_INFO) {
                appl.logInfo("Register: " + classname + ", id: " + handler.getID());
            }
            return handler;
        }
    }

    private static void register(ContentHandlerImpl handler) {
        registeredTypes.addElement(handler);
        RegistryImpl impl = (RegistryImpl)registries.get(handler.classname);
        if (impl != null) {
            impl.handlerImpl = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServer(ContentHandlerImpl server) {
        Object object = mutex;
        synchronized (object) {
            RegistryImpl impl;
            RegistryImpl.checkForUpdates();
            int size = registeredTypes.size();
            for (int i = 0; i < size; ++i) {
                ContentHandlerImpl curr = (ContentHandlerImpl)registeredTypes.elementAt(i);
                if (!server.classname.equals(curr.classname) || !server.storageID.equals(curr.storageID)) continue;
                registeredTypes.setElementAt(server, i);
                break;
            }
            if ((impl = (RegistryImpl)registries.get(server.classname)) != null) {
                impl.handlerImpl = server;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Vector handlers) {
        Object object = mutex;
        synchronized (object) {
            for (int i = 0; i < handlers.size(); ++i) {
                ContentHandlerImpl handler = (ContentHandlerImpl)handlers.elementAt(i);
                CHStore.postUpdate(handler);
                if (!AppProxy.LOG_INFO) continue;
                AppProxy.getCurrent().logInfo("Register: " + handler.classname + ", id: " + handler.getID());
            }
        }
        RegistryImpl.checkForUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ContentHandlerImpl checkConflicts(ContentHandlerImpl handler, Vector handlers, boolean skipSameSuite) throws ContentHandlerException {
        Object object = mutex;
        synchronized (object) {
            if (handlers == null) {
                RegistryImpl.checkForUpdates();
                handlers = registeredTypes;
            }
            ContentHandlerImpl existing = null;
            int size = handlers.size();
            for (int i = 0; i < size; ++i) {
                ContentHandlerImpl curr = (ContentHandlerImpl)handlers.elementAt(i);
                if (handler.storageID.equals(curr.storageID)) {
                    if (handler.classname.equals(curr.classname)) {
                        existing = curr;
                        continue;
                    }
                    if (skipSameSuite) continue;
                }
                if (!handler.ID.startsWith(curr.ID) && !curr.ID.startsWith(handler.ID)) continue;
                throw new ContentHandlerException("ID would be ambiguous", 3);
            }
            return existing;
        }
    }

    public String[] getTypes() {
        return this.registeredByKind(0);
    }

    public String[] getIDs() {
        return this.registeredByKind(3);
    }

    public String[] getActions() {
        return this.registeredByKind(2);
    }

    public String[] getSuffixes() {
        return this.registeredByKind(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregister(ContentHandlerImpl handler) {
        Object object = mutex;
        synchronized (object) {
            registeredTypes.removeElement(handler);
            RegistryImpl impl = (RegistryImpl)registries.get(handler.classname);
            if (impl != null) {
                impl.handlerImpl = null;
            }
            handler.markUnregistered();
        }
        AppProxy appl = AppProxy.getCurrent();
        if (AppProxy.LOG_INFO) {
            appl.logInfo("Unregister: " + handler.classname + ", id: " + handler.ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(String classname) {
        String suiteID = this.application.getStorageID();
        Object object = mutex;
        synchronized (object) {
            RegistryImpl.checkForUpdates();
            for (int i = 0; i < registeredTypes.size(); ++i) {
                ContentHandlerImpl handler = (ContentHandlerImpl)registeredTypes.elementAt(i);
                if (!classname.equals(handler.classname) || !suiteID.equals(handler.storageID)) continue;
                RegistryImpl.unregister(handler);
                CHStore.postUpdate(handler);
                RegistryImpl.checkForUpdates();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(Vector handlers) {
        Object object = mutex;
        synchronized (object) {
            for (int i = 0; i < handlers.size(); ++i) {
                ContentHandlerImpl handler = (ContentHandlerImpl)handlers.elementAt(i);
                RegistryImpl.unregister(handler);
                CHStore.postUpdate(handler);
            }
            RegistryImpl.checkForUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterAll(String suiteID) {
        Object object = mutex;
        synchronized (object) {
            Vector handlers = RegistryImpl.forSuite(suiteID);
            for (int i = 0; i < handlers.size(); ++i) {
                ContentHandlerImpl handler = (ContentHandlerImpl)handlers.elementAt(i);
                RegistryImpl.unregister(handler);
                CHStore.postUpdate(handler);
            }
            RegistryImpl.checkForUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(InvocationImpl invocation, InvocationImpl previous) throws IllegalArgumentException, IOException, ContentHandlerException {
        Object object = mutex;
        synchronized (object) {
            ContentHandlerImpl handler = this.findHandlerOrAutoLoader(invocation);
            invocation.invokingID = this.getID();
            invocation.invokingSuiteID = this.application.getStorageID();
            invocation.invokingClassname = this.application.getClassname();
            invocation.invokingAuthority = this.application.getAuthority();
            invocation.invokingAppName = this.application.getApplicationName();
            boolean shouldExit = invocation.invoke(previous, handler);
            this.insertActive(invocation);
            return shouldExit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reinvoke(InvocationImpl invocation) throws IllegalArgumentException, IOException, ContentHandlerException, SecurityException {
        Object object = mutex;
        synchronized (object) {
            ContentHandlerImpl handler = this.findHandlerOrAutoLoader(invocation);
            int tid = invocation.tid;
            boolean shouldExit = invocation.invoke(null, handler);
            invocation.tid = tid;
            invocation.setStatus(100);
            invocation.setStatus(5);
            return shouldExit;
        }
    }

    public Invocation getResponse(boolean wait, InvocationImpl resp) {
        if (this.responseCalls == 0) {
            InvocationStore.setCleanup(this.application.getStorageID(), this.application.getClassname(), false);
        }
        ++this.responseCalls;
        InvocationImpl invoc = InvocationStore.getResponse(resp, this.application.getStorageID(), this.application.getClassname(), wait);
        if (invoc != null) {
            InvocationImpl existing = this.removeActive(invoc);
            if (existing != null) {
                existing.ID = invoc.ID;
                existing.arguments = invoc.arguments;
                existing.data = invoc.data;
                existing.url = invoc.url;
                existing.type = invoc.type;
                existing.action = invoc.action;
                existing.status = invoc.status;
                invoc = existing;
            } else if (invoc.previousTid != 0) {
                invoc.previous = InvocationStore.getByTid(invoc.previousTid, 0);
            }
            if (invoc.previous != null && invoc.previous.status == 4) {
                invoc.previous.setStatus(2);
            }
            if (invoc.invokingSuiteID != null && invoc.invokingClassname != null) {
                AppProxy.requestForeground(invoc.invokingSuiteID, invoc.invokingClassname, invoc.suiteID, invoc.classname);
            }
            return invoc.invocation;
        }
        return null;
    }

    public void cancelGetResponse() {
        InvocationStore.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(ResponseListener listener) {
        RegistryImpl registryImpl = this;
        synchronized (registryImpl) {
            if (listener != null || this.listenerImpl != null) {
                if (this.listenerImpl == null) {
                    this.listenerImpl = new ResponseListenerImpl(this, listener);
                } else {
                    this.listenerImpl.setListener(listener);
                }
                if (listener == null) {
                    this.listenerImpl = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentHandler[] findHandler(InvocationImpl invoc) throws IOException, ContentHandlerException {
        Object handler;
        Vector handlers = null;
        if (invoc.getID() != null) {
            handler = this.forID(invoc.getID(), false);
            handlers = new Vector();
            if (handler != null) {
                handlers.addElement(handler);
            }
        } else {
            handler = mutex;
            synchronized (handler) {
                if (invoc.getType() == null && invoc.getURL() != null) {
                    try {
                        invoc.findType();
                    }
                    catch (ContentHandlerException che) {
                        // empty catch block
                    }
                }
                if (invoc.getType() != null) {
                    handlers = this.registeredHandlers(0, invoc.getType());
                } else if (invoc.getURL() != null) {
                    handlers = this.lookupBySuffix(invoc);
                } else if (invoc.getAction() != null) {
                    handlers = this.registeredHandlers(2, invoc.getAction());
                } else {
                    throw new IllegalArgumentException("not ID, type, URL, or action");
                }
            }
        }
        String action = invoc.getAction();
        if (action != null && action.length() > 0) {
            for (int i = handlers.size() - 1; i >= 0; --i) {
                ContentHandlerImpl handler2 = (ContentHandlerImpl)handlers.elementAt(i);
                if (handler2.hasAction(action)) continue;
                handlers.removeElementAt(i);
            }
        }
        if (handlers.size() == 0) {
            throw new ContentHandlerException("no registered handler", 1);
        }
        return this.copyOut(handlers);
    }

    private ContentHandlerImpl findHandlerOrAutoLoader(InvocationImpl invoc) throws IOException, ContentHandlerException {
        ContentHandlerImpl handler;
        block2: {
            handler = null;
            try {
                ContentHandler[] handlers = this.findHandler(invoc);
                handler = (ContentHandlerImpl)handlers[0];
            }
            catch (ContentHandlerException cex) {
                String autoID = this.application.getAutoLoadHandlerID();
                if (autoID != null && (handler = (ContentHandlerImpl)this.forID(autoID, true)) != null) break block2;
                throw cex;
            }
        }
        return handler;
    }

    private Vector lookupBySuffix(InvocationImpl invoc) {
        int size = registeredTypes.size();
        Vector<ContentHandlerImpl> handlers = new Vector<ContentHandlerImpl>(size);
        String path = "";
        try {
            HttpUrl url = new HttpUrl(invoc.getURL());
            if (url.path != null) {
                path = url.path;
            }
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        int lenPath = path.length();
        if (lenPath == 0) {
            return handlers;
        }
        block2: for (int i = 0; i < size; ++i) {
            ContentHandlerImpl handler = (ContentHandlerImpl)registeredTypes.elementAt(i);
            if (this.isAccessRestricted(handler)) continue;
            String[] suffixes = handler.suffixes;
            for (int j = 0; j < suffixes.length; ++j) {
                int lenSuffix = suffixes[j].length();
                if (!path.regionMatches(true, lenPath - lenSuffix, suffixes[j], 0, lenSuffix)) continue;
                handlers.addElement(handler);
                continue block2;
            }
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] registeredByKind(int kind) {
        Object object = mutex;
        synchronized (object) {
            RegistryImpl.checkForUpdates();
            int size = registeredTypes.size();
            Vector names = new Vector(size);
            block9: for (int i = 0; i < size; ++i) {
                ContentHandlerImpl handler = (ContentHandlerImpl)registeredTypes.elementAt(i);
                if (this.isAccessRestricted(handler)) continue;
                switch (kind) {
                    case 3: {
                        this.addUnique(handler.ID, names);
                        continue block9;
                    }
                    case 0: {
                        this.addUnique(handler.types, names);
                        continue block9;
                    }
                    case 1: {
                        this.addUnique(handler.suffixes, names);
                        continue block9;
                    }
                    case 2: {
                        this.addUnique(handler.actions, names);
                    }
                }
            }
            Object[] retval = new String[names.size()];
            names.copyInto(retval);
            return retval;
        }
    }

    private void addUnique(Object[] objs, Vector vector) {
        for (int i = 0; i < objs.length; ++i) {
            if (vector.contains(objs[i])) continue;
            vector.addElement(objs[i]);
        }
    }

    private void addUnique(Object obj, Vector vector) {
        if (!vector.contains(obj)) {
            vector.addElement(obj);
        }
    }

    public ContentHandler[] forType(String type) {
        Vector handlers = this.registeredHandlers(0, type);
        return this.copyOut(handlers);
    }

    public ContentHandler[] forAction(String action) {
        Vector handlers = this.registeredHandlers(2, action);
        return this.copyOut(handlers);
    }

    public ContentHandler[] forSuffix(String suffix) {
        Vector handlers = this.registeredHandlers(1, suffix);
        return this.copyOut(handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentHandler forID(String ID, boolean exact) {
        Object object = mutex;
        synchronized (object) {
            RegistryImpl.checkForUpdates();
            int size = registeredTypes.size();
            for (int i = 0; i < size; ++i) {
                ContentHandlerImpl handler = (ContentHandlerImpl)registeredTypes.elementAt(i);
                if (this.isAccessRestricted(handler) || exact && ID.length() != handler.ID.length() || !ID.startsWith(handler.ID)) continue;
                return handler;
            }
            return null;
        }
    }

    static ContentHandlerImpl findHandler(String storageID, String classname) {
        int size = registeredTypes.size();
        for (int i = 0; i < size; ++i) {
            ContentHandlerImpl curr = (ContentHandlerImpl)registeredTypes.elementAt(i);
            if (!classname.equals(curr.classname) || !storageID.equals(curr.storageID)) continue;
            return curr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector registeredHandlers(int kind, String value) {
        Object object = mutex;
        synchronized (object) {
            RegistryImpl.checkForUpdates();
            int size = registeredTypes.size();
            Vector<ContentHandlerImpl> val = new Vector<ContentHandlerImpl>(size);
            if (value.length() == 0) {
                return val;
            }
            block8: for (int i = 0; i < size; ++i) {
                ContentHandlerImpl handler = (ContentHandlerImpl)registeredTypes.elementAt(i);
                if (this.isAccessRestricted(handler)) continue;
                String[] strings = null;
                switch (kind) {
                    case 0: {
                        strings = handler.types;
                        break;
                    }
                    case 1: {
                        strings = handler.suffixes;
                        break;
                    }
                    case 2: {
                        strings = handler.actions;
                    }
                }
                if (strings == null) continue;
                int valLen = value.length();
                for (int j = strings.length - 1; j >= 0; --j) {
                    if (valLen != strings[j].length() || !value.regionMatches(kind != 2, 0, strings[j], 0, valLen) || val.contains(handler)) continue;
                    val.addElement(handler);
                    continue block8;
                }
            }
            return val;
        }
    }

    public ContentHandlerImpl getServer() {
        return this.handlerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentHandlerImpl getServer(AppProxy appl) {
        Object object = mutex;
        synchronized (object) {
            RegistryImpl.checkForUpdates();
            String classname = appl.getClassname();
            String storageID = appl.getStorageID();
            return RegistryImpl.findHandler(storageID, classname);
        }
    }

    ContentHandlerImpl[] copyOut(Vector handlers) {
        Object[] retval = new ContentHandlerImpl[handlers.size()];
        handlers.copyInto(retval);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector forSuite(String suiteID) {
        Object object = mutex;
        synchronized (object) {
            RegistryImpl.checkForUpdates();
            Vector<ContentHandlerImpl> subset = new Vector<ContentHandlerImpl>(10);
            for (int i = 0; i < registeredTypes.size(); ++i) {
                ContentHandlerImpl handler = (ContentHandlerImpl)registeredTypes.elementAt(i);
                if (!suiteID.equals(handler.storageID)) continue;
                subset.addElement(handler);
            }
            return subset;
        }
    }

    public String getID() {
        return this.handlerImpl != null ? this.handlerImpl.getID() : this.application.getApplicationID();
    }

    private boolean isAccessRestricted(ContentHandlerImpl handler) {
        if (handler.accessRestricted == null || handler.accessRestricted.length == 0) {
            return false;
        }
        String[] allowed = handler.accessRestricted;
        for (int i = allowed.length - 1; i >= 0; --i) {
            if (!this.getID().startsWith(allowed[i])) continue;
            return false;
        }
        return true;
    }

    private void insertActive(InvocationImpl invoc) {
        Integer tid = new Integer(invoc.tid);
        this.activeInvocations.put(tid, invoc);
    }

    private InvocationImpl removeActive(InvocationImpl invoc) {
        Integer tid = new Integer(invoc.tid);
        return (InvocationImpl)this.activeInvocations.remove(tid);
    }

    private static void checkForUpdates() {
        ContentHandlerImpl handler;
        while ((handler = CHStore.getUpdate()) != null) {
            ContentHandlerImpl prev = RegistryImpl.findHandler(handler.storageID, handler.classname);
            if (prev != null) {
                RegistryImpl.unregister(prev);
            }
            if (handler.removed) continue;
            RegistryImpl.register(handler);
        }
        if (registeredTypes.size() == 0) {
            handler = RegistryImpl.initGraphicalInstaller();
            CHStore.postUpdate(handler);
        }
    }

    private static ContentHandlerImpl initGraphicalInstaller() {
        String[] types = new String[]{"text/vnd.sun.j2me.app-descriptor", "application/java-archive"};
        String[] suffixes = new String[]{".jad", ".jar"};
        ContentHandlerImpl handler = new ContentHandlerImpl(types, suffixes, null, null, null, null);
        handler.ID = "GraphicalInstaller";
        handler.appname = "GraphicalInstaller";
        handler.version = "1.0";
        handler.storageID = "manager_storage_";
        handler.classname = "com.sun.midp.dev.GraphicalInstaller";
        handler.dynamic = false;
        return handler;
    }

    static {
        AppProxy.setSecurityToken(classSecurityToken);
        registries = new Hashtable();
        mutex = new Object();
        registeredTypes = new Vector(10);
    }
}

