/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.content;

import com.sun.midp.content.AppProxy;
import com.sun.midp.content.InvocationImpl;

class InvocationStore {
    private static final Object mutex = new Object();
    private static int cancelCount;
    private static final int MODE_REQUEST = 0;
    private static final int MODE_RESPONSE = 1;
    private static final int MODE_CLEANUP = 2;
    private static final int MODE_LREQUEST = 3;
    private static final int MODE_LRESPONSE = 4;
    private static final int MODE_TID = 6;
    private static final int MODE_TID_NEXT = 7;
    private static final int MODE_TID_PREV = 8;

    private InvocationStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyChanged() {
        Object object = mutex;
        synchronized (object) {
            mutex.notify();
        }
    }

    static void put(InvocationImpl invoc) {
        if (invoc.suiteID == null || invoc.classname == null) {
            throw new NullPointerException();
        }
        InvocationStore.put0(invoc);
        if (AppProxy.LOG_INFO) {
            AppProxy.getCurrent().logInfo("Store put0: " + invoc);
        }
        InvocationStore.notifyChanged();
    }

    static InvocationImpl getRequest(String suiteID, String classname, boolean shouldBlock) {
        InvocationImpl invoc = new InvocationImpl();
        if (suiteID == null || classname == null) {
            throw new NullPointerException();
        }
        invoc.suiteID = suiteID;
        invoc.classname = classname;
        return InvocationStore.get(invoc, 0, shouldBlock);
    }

    static InvocationImpl getResponse(InvocationImpl invoc, String suiteID, String classname, boolean shouldBlock) {
        invoc.suiteID = suiteID;
        invoc.classname = classname;
        return InvocationStore.get(invoc, 1, shouldBlock);
    }

    static InvocationImpl getCleanup(String suiteID, String classname) {
        InvocationImpl invoc = new InvocationImpl();
        invoc.suiteID = suiteID;
        invoc.classname = classname;
        return InvocationStore.get(invoc, 2, false);
    }

    static InvocationImpl getByTid(int tid, int relative) {
        InvocationImpl invoc = new InvocationImpl();
        int mode = 6;
        if (relative < 0) {
            mode = 8;
        } else if (relative > 0) {
            mode = 7;
        }
        invoc.suiteID = null;
        invoc.classname = null;
        invoc.tid = tid;
        return InvocationStore.get(invoc, mode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InvocationImpl get(InvocationImpl invoc, int mode, boolean shouldBlock) {
        String classname = invoc.classname;
        invoc.setArgs(null);
        invoc.setData(null);
        int s = 0;
        Object object = mutex;
        synchronized (object) {
            while ((s = InvocationStore.get0(invoc, invoc.suiteID, invoc.classname, mode)) != 1) {
                if (s == -1) {
                    invoc.setArgs(new String[invoc.argsLen]);
                    invoc.setData(new byte[invoc.dataLen]);
                    continue;
                }
                if (!shouldBlock) break;
                int oldCancelCount = cancelCount;
                try {
                    mutex.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (cancelCount <= oldCancelCount) continue;
                s = 0;
                break;
            }
        }
        if (s == 0) {
            invoc = null;
        }
        if (AppProxy.LOG_INFO) {
            AppProxy.getCurrent().logInfo("Store get: " + classname + ", mode: " + mode + ", " + invoc);
        }
        return invoc;
    }

    static void setStatus(InvocationImpl invoc) {
        InvocationStore.setStatus0(invoc);
        if (AppProxy.LOG_INFO) {
            AppProxy.getCurrent().logInfo("Store setStatus0: " + invoc);
        }
        InvocationStore.notifyChanged();
    }

    static void setParams(InvocationImpl invoc) {
        InvocationStore.setParams0(invoc);
        if (AppProxy.LOG_INFO) {
            AppProxy.getCurrent().logInfo("Store setParams0: " + invoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean listen(String suiteID, String classname, boolean request, boolean shouldBlock) {
        boolean pending;
        if (suiteID == null || classname == null) {
            throw new NullPointerException();
        }
        int mode = request ? 3 : 4;
        Object object = mutex;
        synchronized (object) {
            while (!(pending = InvocationStore.listen0(suiteID, classname, mode)) && shouldBlock) {
                int oldCancelCount = cancelCount;
                try {
                    mutex.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (cancelCount <= oldCancelCount) continue;
                break;
            }
        }
        if (AppProxy.LOG_INFO) {
            AppProxy.getCurrent().logInfo("Store listen: " + classname + ", request: " + request + ", pending: " + pending);
        }
        return pending;
    }

    static void setListenNotify(String suiteID, String classname, boolean request) {
        if (suiteID == null || classname == null) {
            throw new NullPointerException();
        }
        int mode = request ? 3 : 4;
        InvocationStore.setListenNotify0(suiteID, classname, mode);
        if (AppProxy.LOG_INFO) {
            AppProxy.getCurrent().logInfo("Store setListenNotify: " + classname + ", request: " + request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cancel() {
        Object object = mutex;
        synchronized (object) {
            ++cancelCount;
            mutex.notifyAll();
        }
    }

    static void setCleanup(String suiteID, String classname, boolean cleanup) {
        if (AppProxy.LOG_INFO) {
            AppProxy.getCurrent().logInfo("Store setCleanup: " + classname + ": " + cleanup);
        }
        InvocationStore.setCleanup0(suiteID, classname, cleanup);
    }

    static int size() {
        return InvocationStore.size0();
    }

    private static native void put0(InvocationImpl var0);

    private static native int get0(InvocationImpl var0, String var1, String var2, int var3);

    private static native void setStatus0(InvocationImpl var0);

    private static native void setParams0(InvocationImpl var0);

    private static native boolean listen0(String var0, String var1, int var2);

    private static native void setListenNotify0(String var0, String var1, int var2);

    private static native void setCleanup0(String var0, String var1, boolean var2);

    private static native int size0();
}

