/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.content;

import com.sun.midp.content.AppProxy;
import com.sun.midp.content.ContentHandlerImpl;
import com.sun.midp.content.InvocationStore;
import java.io.IOException;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.Invocation;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public final class InvocationImpl {
    public Invocation invocation;
    String url;
    String type;
    String ID;
    String action;
    String[] arguments;
    int argsLen;
    byte[] data;
    int dataLen;
    boolean responseRequired;
    String username;
    String password;
    int tid;
    String suiteID;
    String classname;
    int status;
    String invokingAuthority;
    String invokingID;
    String invokingSuiteID;
    String invokingClassname;
    String invokingAppName;
    InvocationImpl previous;
    int previousTid;
    private static final byte[] ZERO_BYTES = new byte[0];
    static final int DISPOSE = 100;

    InvocationImpl() {
        this.invocation = this.invocation;
        this.status = 1;
        this.responseRequired = true;
        this.arguments = ContentHandlerImpl.ZERO_STRINGS;
        this.data = ZERO_BYTES;
    }

    public InvocationImpl(Invocation invocation) {
        this();
        this.invocation = invocation;
    }

    public void setArgs(String[] args) {
        this.arguments = args == null ? ContentHandlerImpl.ZERO_STRINGS : args;
    }

    public String[] getArgs() {
        return this.arguments;
    }

    public void setData(byte[] data) {
        this.data = data == null ? ZERO_BYTES : data;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public boolean getResponseRequired() {
        return this.responseRequired;
    }

    public void setResponseRequired(boolean responseRequired) {
        if (this.getStatus() != 1) {
            throw new IllegalStateException();
        }
        this.responseRequired = responseRequired;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    boolean invoke(InvocationImpl previous, ContentHandlerImpl handler) throws IllegalArgumentException, IOException, ContentHandlerException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != null) continue;
            throw new IllegalArgumentException("argument is null");
        }
        if (previous != null) {
            this.previous = previous;
            this.previousTid = previous.tid;
        }
        this.setStatus(1);
        this.setID(handler.ID);
        this.suiteID = handler.storageID;
        this.classname = handler.classname;
        InvocationStore.put(this);
        boolean shouldExit = false;
        try {
            AppProxy appl = AppProxy.getCurrent().forApp(this.suiteID, this.classname);
            shouldExit = appl.launch(handler.getAppName());
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        this.status = 3;
        if (previous != null) {
            previous.setStatus(4);
        }
        return shouldExit;
    }

    boolean finish(int status) {
        if (status != 5 && status != 6 && status != 8) {
            throw new IllegalArgumentException();
        }
        if (this.getResponseRequired() && this.tid != 0) {
            InvocationStore.setParams(this);
        }
        this.setStatus(status);
        if (this.getResponseRequired()) {
            try {
                AppProxy appl = AppProxy.getCurrent().forApp(this.suiteID, this.classname);
                return appl.launch(this.invokingAppName);
            }
            catch (ClassNotFoundException cnfe) {
                cnfe.printStackTrace();
            }
        }
        return false;
    }

    public Connection open(boolean timeouts) throws IOException {
        Connection conn = Connector.open((String)this.getURL(), (int)1, (boolean)timeouts);
        return conn;
    }

    public void setCredentials(String username, char[] password) {
        this.username = username;
        this.password = password == null ? null : new String(password);
    }

    public int getStatus() {
        return this.status;
    }

    void setStatus(int status) {
        this.status = status;
        if (this.tid != 0) {
            InvocationStore.setStatus(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findType() throws IOException, ContentHandlerException {
        block16: {
            if (this.type != null) {
                return this.type;
            }
            if (this.url == null) {
                throw new ContentHandlerException("URL is null", 2);
            }
            Connection conn = null;
            int rc = 0;
            try {
                while ((conn = Connector.open((String)this.url)) instanceof HttpConnection) {
                    HttpConnection httpc = (HttpConnection)conn;
                    httpc.setRequestMethod("HEAD");
                    rc = httpc.getResponseCode();
                    if (rc == 200) {
                        this.type = httpc.getType();
                        if (this.type != null) {
                            int ndx = this.type.indexOf(59);
                            if (ndx >= 0) {
                                this.type = this.type.substring(0, ndx);
                            }
                            this.type = this.type.trim();
                        }
                        if (this.type == null || this.type.length() == 0) {
                            this.type = null;
                            throw new ContentHandlerException("unable to determine type", 2);
                        }
                        break block16;
                    }
                    if (rc == 307 || rc == 302 || rc == 301) {
                        this.url = httpc.getHeaderField("location");
                        conn.close();
                        conn = null;
                        continue;
                    }
                    throw new IOException("http status: " + rc);
                }
                throw new ContentHandlerException("URL scheme not supported", 2);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.type;
    }

    public InvocationImpl getPrevious() {
        return this.previous;
    }

    public String getInvokingAuthority() {
        if (this.status != 2 && this.status != 4) {
            return null;
        }
        return this.invokingAuthority;
    }

    public String getInvokingAppName() {
        if (this.status != 2 && this.status != 4) {
            return null;
        }
        return this.invokingAppName;
    }

    public String getInvokingID() {
        if (this.status != 2 && this.status != 4) {
            return null;
        }
        return this.invokingID;
    }

    public String toString() {
        if (AppProxy.LOG_INFO) {
            StringBuffer sb = new StringBuffer(200);
            sb.append("tid: ");
            sb.append(this.tid);
            sb.append(" status: ");
            sb.append(this.status);
            sb.append(", type: ");
            sb.append(this.getType());
            sb.append(", url: ");
            sb.append(this.getURL());
            sb.append(", respReq: ");
            sb.append(this.getResponseRequired());
            sb.append("\n   invokee: ");
            sb.append(this.classname);
            sb.append(", invoker: ");
            sb.append(this.invokingClassname);
            return sb.toString();
        }
        return super.toString();
    }
}

