/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.content;

import com.sun.midp.io.Util;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.midletsuite.Installer;
import com.sun.midp.security.SecurityToken;
import java.util.Hashtable;
import java.util.Vector;

class AppProxy {
    private static SecurityToken classSecurityToken;
    private static AppProxy currentApp;
    static final boolean LOG_INFO;
    private static boolean oneExecute;
    protected Hashtable appmap;
    protected static final Object mutex;
    protected final MIDletSuite msuite;
    protected final String storageID;
    protected String classname;
    private String applicationName;
    private String applicationID;
    private boolean isRegistered;

    static void setSecurityToken(SecurityToken token) {
        if (classSecurityToken != null) {
            throw new SecurityException();
        }
        classSecurityToken = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AppProxy getCurrent() {
        Object object = mutex;
        synchronized (object) {
            if (currentApp == null) {
                MIDletSuite msuite = Scheduler.getScheduler().getMIDletSuite();
                try {
                    currentApp = msuite != null ? new AppProxy(msuite, msuite.getInitialMIDletClassname(), null) : new AppProxy("internal", "");
                }
                catch (ClassNotFoundException cnfe) {
                    return null;
                }
            }
        }
        return currentApp;
    }

    protected AppProxy(MIDletSuite msuite, String classname, Hashtable appmap) throws ClassNotFoundException {
        if (appmap == null) {
            appmap = new Hashtable<String, AppProxy>();
        }
        this.msuite = msuite;
        this.storageID = msuite.getStorageName();
        this.classname = classname;
        this.appmap = appmap;
        if (classname != null) {
            this.verifyApplication(classname);
            this.initAppInfo();
            appmap.put(classname, this);
            if (LOG_INFO) {
                this.logInfo("AppProxy created: " + classname);
            }
        }
    }

    protected AppProxy(String storageID, String classname) {
        this.storageID = storageID;
        this.classname = classname;
        this.msuite = null;
        if (LOG_INFO) {
            this.logInfo("AppProxy created: " + classname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AppProxy forClass(String classname) throws ClassNotFoundException {
        AppProxy curr = null;
        Object object = mutex;
        synchronized (object) {
            curr = (AppProxy)this.appmap.get(classname);
            if (curr == null) {
                curr = new AppProxy(this.msuite, classname, this.appmap);
            }
        }
        return curr;
    }

    AppProxy forApp(String storageID, String classname) throws ClassNotFoundException {
        if (storageID.equals(this.storageID)) {
            return this.forClass(classname);
        }
        AppProxy curr = new AppProxy(storageID, classname);
        return curr;
    }

    String getStorageID() {
        return this.storageID;
    }

    String getClassname() {
        return this.classname;
    }

    String getApplicationName() {
        return this.applicationName;
    }

    String getApplicationID() {
        return this.applicationID;
    }

    String getVersion() {
        return this.msuite.getProperty("MIDlet-Version");
    }

    String getAuthority() {
        return this.msuite.getCA();
    }

    boolean isRegistered() {
        return this.isRegistered;
    }

    String getProperty(String key) {
        return this.msuite.getProperty(key);
    }

    final void checkRegisterPermission(String reason) {
        try {
            this.msuite.checkForPermission(47, this.getApplicationName(), reason);
        }
        catch (InterruptedException ie) {
            throw new SecurityException("interrupted");
        }
    }

    static final void checkAPIPermission(Object securityToken) {
        if (securityToken != null) {
            ((SecurityToken)securityToken).checkIfPermissionAllowed(0);
        } else {
            MIDletSuite msuite = Scheduler.getScheduler().getMIDletSuite();
            if (msuite != null) {
                msuite.checkIfPermissionAllowed(1);
            }
        }
    }

    static void requestForeground(String invokingSuiteID, String invokingClassname, String targetSuiteID, String targetClassname) {
    }

    boolean launch(String displayName) {
        if (oneExecute) {
            if (LOG_INFO) {
                this.logInfo("Launch: " + this.classname + ", oneExecute: " + oneExecute);
            }
            return true;
        }
        oneExecute = Installer.getInstaller(classSecurityToken).execute(this.getStorageID(), this.classname);
        if (LOG_INFO) {
            this.logInfo("Launch: " + this.classname + ", oneExecute: " + oneExecute);
        }
        return oneExecute;
    }

    protected void verifyApplication(String classname) throws ClassNotFoundException {
        Class<?> appClass = Class.forName(classname);
        Class<?> midletClass = Class.forName("javax.microedition.midlet.MIDlet");
        if (!midletClass.isAssignableFrom(appClass) || appClass == midletClass) {
            throw new IllegalArgumentException("not a MIDlet");
        }
    }

    protected void initAppInfo() {
        String[] minfo = AppProxy.getMIDletInfo(this.msuite, this.classname);
        if (minfo != null) {
            this.applicationName = minfo[0];
            this.applicationID = minfo[2];
            this.isRegistered = true;
        }
        if (this.applicationName == null || this.applicationName.length() == 0) {
            this.applicationName = this.msuite.getProperty("MIDlet-Name");
        }
        if (this.applicationID == null || this.applicationID.length() == 0) {
            this.applicationID = this.getDefaultID();
        }
    }

    String getDefaultID() {
        StringBuffer sb = new StringBuffer(80);
        String s = this.msuite.getProperty("MIDlet-Vendor");
        sb.append(s != null ? s : "internal");
        sb.append('-');
        s = this.msuite.getProperty("MIDlet-Name");
        sb.append(s != null ? s : "system");
        sb.append('-');
        sb.append(this.classname);
        return sb.toString().replace(' ', '_');
    }

    private static String[] getMIDletInfo(MIDletSuite suite, String classname) {
        String midletn;
        String attr;
        int i = 1;
        while ((attr = suite.getProperty(midletn = "MIDlet-".concat(Integer.toString(i)))) != null) {
            Vector args = Util.getCommaSeparatedValues(attr);
            if (args.size() >= 3 && classname.equals(args.elementAt(2))) {
                Object[] values = new String[args.size()];
                args.copyInto(values);
                String ID = suite.getProperty(midletn.concat("-ID"));
                values[2] = ID;
                return values;
            }
            ++i;
        }
        return null;
    }

    String getAutoLoadHandlerID() {
        return null;
    }

    void logInfo(String msg) {
        if (LOG_INFO) {
            System.out.println(">> " + this.threadID() + ": " + msg);
        }
    }

    void logException(String msg, Throwable t) {
        if (LOG_INFO) {
            System.out.println("** " + this.threadID() + ": " + msg);
            t.printStackTrace();
        }
    }

    public String toString() {
        if (LOG_INFO) {
            return "class: " + this.classname + ", suite: " + this.storageID + ", registered: " + this.isRegistered + ", name: " + this.applicationName + ", ID: " + this.applicationID;
        }
        return super.toString();
    }

    private String threadID() {
        if (LOG_INFO) {
            Thread thread = Thread.currentThread();
            int i = thread.hashCode() & 0xFF;
            return "T" + i;
        }
        return "";
    }

    static {
        LOG_INFO = "true".equals(System.getProperty("chapi.logging"));
        mutex = new Object();
    }
}

