/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim.formats;

import java.io.ByteArrayOutputStream;

public class Base64Encoding {
    private static char[] BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static byte[] BASE64_BYTES = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public static byte[] fromBase64(String sdata) {
        char char1;
        char char0;
        if (sdata == null || sdata.length() < 2) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int length = sdata.length();
        char[] data = new char[length + 2];
        sdata.getChars(0, length, data, 0);
        data[length] = 61;
        data[length + 1] = 61;
        int i = Base64Encoding.nextCharIndex(data, 0);
        boolean offset = false;
        while (i < data.length && (char0 = data[i = Base64Encoding.nextCharIndex(data, i)]) != '=' && (char1 = data[i = Base64Encoding.nextCharIndex(data, i + 1)]) != '=') {
            i = Base64Encoding.nextCharIndex(data, i + 1);
            char char2 = data[i];
            i = Base64Encoding.nextCharIndex(data, i + 1);
            char char3 = data[i];
            i = Base64Encoding.nextCharIndex(data, i + 1);
            out.write(BASE64_BYTES[char0] << 2 | BASE64_BYTES[char1] >> 4);
            if (char2 == '=') continue;
            int value = BASE64_BYTES[char1] << 4 | BASE64_BYTES[char2] >> 2;
            out.write(value & 0xFF);
            if (char3 == '=') continue;
            value = BASE64_BYTES[char2] << 6 | BASE64_BYTES[char3];
            out.write(value & 0xFF);
        }
        return out.toByteArray();
    }

    private static int nextCharIndex(char[] data, int i) {
        while (i < data.length && (data[i] > '\u007f' || BASE64_BYTES[data[i]] == -1)) {
            ++i;
        }
        return i;
    }

    public static String toBase64(byte[] data, int lineLength, int indent) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int charsInLine = 0;
        while (i < data.length) {
            int byte0 = data[i++] & 0xFF;
            int byte1 = i < data.length ? data[i++] & 0xFF : 256;
            int byte2 = i < data.length ? data[i++] & 0xFF : 256;
            sb.append(BASE64_CHARS[byte0 >> 2]);
            if (byte1 == 256) {
                sb.append(BASE64_CHARS[byte0 << 4 & 0x30]);
                sb.append("==");
            } else {
                sb.append(BASE64_CHARS[(byte0 << 4 | byte1 >> 4) & 0x3F]);
                if (byte2 == 256) {
                    sb.append(BASE64_CHARS[byte1 << 2 & 0x3F]);
                    sb.append('=');
                } else {
                    sb.append(BASE64_CHARS[(byte1 << 2 | byte2 >> 6) & 0x3F]);
                    sb.append(BASE64_CHARS[byte2 & 0x3F]);
                }
            }
            if ((charsInLine += 4) + 4 <= lineLength || i >= data.length) continue;
            sb.append("\r\n");
            for (int j = 0; j < indent; ++j) {
                sb.append(' ');
            }
        }
        return sb.toString();
    }
}

