/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkableInputStream
extends InputStream {
    private final InputStream in;
    private ByteArrayOutputStream baos;
    private byte[] buffer;
    private int bufferIndex;

    public MarkableInputStream(InputStream in) {
        this.in = in;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int lookahead) {
        this.baos = new ByteArrayOutputStream();
    }

    public void reset() throws IOException {
        if (this.baos == null) {
            throw new IOException("Cannot reset an unmarked stream");
        }
        if (this.baos.size() == 0) {
            this.baos = null;
        } else {
            this.buffer = this.baos.toByteArray();
            this.baos = null;
            this.bufferIndex = 0;
        }
    }

    public void close() throws IOException {
        this.in.close();
        this.baos.close();
        this.baos = null;
        this.buffer = null;
    }

    public int read() throws IOException {
        if (this.buffer != null) {
            return this.readFromBuffer();
        }
        return this.readFromStream();
    }

    private int readFromBuffer() {
        byte i = this.buffer[this.bufferIndex++];
        if (this.baos != null) {
            this.baos.write(i);
        }
        if (this.bufferIndex == this.buffer.length) {
            this.buffer = null;
        }
        return i;
    }

    private int readFromStream() throws IOException {
        int i = this.in.read();
        if (i != -1 && this.baos != null) {
            this.baos.write(i);
        }
        return i;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.buffer != null) {
            return this.readFromBuffer(b, offset, length);
        }
        return this.readFromStream(b, offset, length);
    }

    private int readFromBuffer(byte[] b, int offset, int length) {
        int bytesRead = -1;
        if (length <= this.buffer.length - this.bufferIndex) {
            System.arraycopy(this.buffer, this.bufferIndex, b, offset, length);
            this.bufferIndex += length;
            bytesRead = length;
        } else {
            int count = this.buffer.length - this.bufferIndex;
            System.arraycopy(this.buffer, this.bufferIndex, b, offset, count);
            this.buffer = null;
            bytesRead = count;
        }
        if (this.baos != null) {
            this.baos.write(b, offset, bytesRead);
        }
        return bytesRead;
    }

    private int readFromStream(byte[] b, int offset, int length) throws IOException {
        int i = this.in.read(b, offset, length);
        if (i != -1 && this.baos != null) {
            this.baos.write(b, offset, i);
        }
        return i;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

