/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim;

import com.sun.kvem.midp.pim.AbstractPIMList;
import com.sun.kvem.midp.pim.EventImpl;
import com.sun.kvem.midp.pim.KeySortUtility;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.pim.Event;
import javax.microedition.pim.EventList;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.RepeatRule;

class EventListImpl
extends AbstractPIMList
implements EventList {
    EventListImpl(String name, int mode) throws PIMException {
        super(2, name, mode);
    }

    public Event createEvent() {
        return new EventImpl(this);
    }

    public int[] getSupportedRepeatRuleFields(int frequency) {
        switch (frequency) {
            case 16: {
                return new int[]{32, 128, 64};
            }
            case 17: {
                return new int[]{32, 128, 64, 2};
            }
            case 18: {
                return new int[]{32, 128, 64, 2, 16, 1};
            }
            case 19: {
                return new int[]{32, 128, 64, 2, 16, 1, 8, 4};
            }
        }
        throw new IllegalArgumentException("Unsupported frequency: " + frequency);
    }

    public Event importEvent(Event item) {
        return new EventImpl(this, item);
    }

    public Enumeration items(int searchType, long startDate, long endDate, boolean initialEventOnly) throws PIMException {
        switch (searchType) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid search type: " + searchType);
            }
        }
        if (startDate > endDate) {
            throw new IllegalArgumentException("Start date must be earlier than end date");
        }
        Vector selectedItems = new Vector();
        Vector itemKeys = new Vector();
        Enumeration e = this.items();
        while (e.hasMoreElements()) {
            Event event = (Event)e.nextElement();
            long eventStart = 0L;
            long eventEnd = 0L;
            if (event.countValues(106) != 0) {
                eventStart = event.getDate(106, 0);
                eventEnd = event.countValues(102) != 0 ? event.getDate(102, 0) : eventStart;
            } else {
                if (event.countValues(102) == 0) continue;
                eventStart = eventEnd = event.getDate(102, 0);
            }
            long duration = Math.max(0L, eventEnd - eventStart);
            RepeatRule repeatRule = event.getRepeat();
            boolean includeItem = false;
            if (repeatRule != null) {
                long timeSlot = eventEnd - eventStart;
                Enumeration dates = repeatRule.dates(eventStart, Math.max(startDate - duration, 0L), endDate);
                while (dates.hasMoreElements()) {
                    Date date = (Date)dates.nextElement();
                    eventStart = date.getTime();
                    eventEnd = eventStart + timeSlot;
                    if (eventStart <= endDate && !(includeItem = this.checkRange(searchType, startDate, endDate, eventStart, eventEnd)) && !initialEventOnly) continue;
                    break;
                }
            } else {
                includeItem = this.checkRange(searchType, startDate, endDate, eventStart, eventEnd);
            }
            if (!includeItem) continue;
            KeySortUtility.store(itemKeys, selectedItems, eventStart, event);
        }
        return selectedItems.elements();
    }

    private boolean checkRange(int searchType, long startDate, long endDate, long eventStart, long eventEnd) {
        switch (searchType) {
            case 0: {
                return eventStart >= startDate && eventStart <= endDate;
            }
            case 1: {
                return eventEnd >= startDate && eventEnd <= endDate;
            }
            case 2: {
                return eventStart <= endDate && eventEnd >= startDate;
            }
        }
        return false;
    }

    public void removeEvent(Event item) throws PIMException {
        this.removeItem((PIMItem)item);
    }
}

