/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim;

import com.sun.kvem.midp.pim.AbstractPIMItem;
import com.sun.kvem.midp.pim.AbstractPIMList;
import com.sun.kvem.midp.pim.EventListImpl;
import com.sun.kvem.midp.pim.PIMFormat;
import com.sun.kvem.midp.pim.PIMHandler;
import com.sun.kvem.midp.pim.formats.VCalendar10Format;
import java.util.Date;
import java.util.Enumeration;
import javax.microedition.pim.Event;
import javax.microedition.pim.FieldEmptyException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.RepeatRule;

public class EventImpl
extends AbstractPIMItem
implements Event {
    private RepeatRule repeatRule = null;

    public EventImpl(EventListImpl list) {
        super((AbstractPIMList)list, 2);
    }

    EventImpl(EventListImpl list, Event base) {
        super((AbstractPIMList)list, (PIMItem)base);
        this.repeatRule = base.getRepeat();
    }

    public RepeatRule getRepeat() {
        if (this.repeatRule == null) {
            return null;
        }
        int[] fields = this.repeatRule.getFields();
        RepeatRule newRule = new RepeatRule();
        block4: for (int i = 0; i < fields.length; ++i) {
            int field = fields[i];
            switch (field) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: 
                case 32: 
                case 128: {
                    newRule.setInt(field, this.repeatRule.getInt(field));
                    continue block4;
                }
                case 64: {
                    newRule.setDate(field, this.repeatRule.getDate(field));
                }
            }
        }
        Enumeration dates = this.repeatRule.getExceptDates();
        while (dates.hasMoreElements()) {
            Date date = (Date)dates.nextElement();
            newRule.addExceptDate(date.getTime());
        }
        return newRule;
    }

    public void setRepeat(RepeatRule value) {
        this.repeatRule = value;
        this.setModified(true);
    }

    PIMFormat getEncodingFormat() {
        return new VCalendar10Format();
    }

    static boolean isValidPIMField(int field) {
        switch (field) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                return true;
            }
        }
        return false;
    }

    public void addInt(int field, int attributes, int value) {
        if (field == 101) {
            this.validateClass(value);
        }
        super.addInt(field, attributes, value);
    }

    public void setInt(int field, int index, int attributes, int value) {
        if (field == 101) {
            this.validateClass(value);
        }
        super.setInt(field, index, attributes, value);
    }

    private void validateClass(int value) {
        switch (value) {
            case 200: 
            case 201: 
            case 202: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid CLASS value: " + value);
    }

    protected int getRevisionField() {
        return 105;
    }

    protected int getUIDField() {
        return 108;
    }

    protected void setDefaultValues() {
        super.setDefaultValues();
        if (this.repeatRule != null) {
            try {
                this.repeatRule.getInt(0);
            }
            catch (FieldEmptyException e) {
                this.repeatRule.setInt(0, 16);
            }
            try {
                this.repeatRule.getInt(128);
            }
            catch (FieldEmptyException e) {
                this.repeatRule.setInt(128, 1);
            }
        }
    }

    protected String toDisplayableString() {
        StringBuffer sb = new StringBuffer("Event[");
        String data = this.formatData();
        sb.append(data);
        RepeatRule rule = this.getRepeat();
        if (rule != null) {
            if (data.length() > 0) {
                sb.append(", ");
            }
            sb.append("Rule=[");
            int[] fields = rule.getFields();
            block17: for (int i = 0; i < fields.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                int field = fields[i];
                switch (field) {
                    case 0: {
                        sb.append("Frequency=");
                        switch (rule.getInt(field)) {
                            case 16: {
                                sb.append("Daily");
                                continue block17;
                            }
                            case 17: {
                                sb.append("Weekly");
                                continue block17;
                            }
                            case 18: {
                                sb.append("Monthly");
                                continue block17;
                            }
                            case 19: {
                                sb.append("Yearly");
                                continue block17;
                            }
                        }
                        sb.append("<Unknown: " + rule.getInt(field) + ">");
                        continue block17;
                    }
                    case 64: {
                        sb.append("End=" + PIMHandler.getInstance().composeDateTime(rule.getDate(field)));
                        continue block17;
                    }
                    case 32: {
                        sb.append("Count=" + rule.getInt(field));
                        continue block17;
                    }
                    case 128: {
                        sb.append("Interval=" + rule.getInt(field));
                        continue block17;
                    }
                    case 2: {
                        sb.append("DayInWeek=0x" + Integer.toHexString(rule.getInt(field)));
                        continue block17;
                    }
                    case 1: {
                        sb.append("DayInMonth=" + rule.getInt(field));
                        continue block17;
                    }
                    case 4: {
                        sb.append("DayInYear=" + rule.getInt(field));
                        continue block17;
                    }
                    case 16: {
                        sb.append("WeekInMonth=0x" + Integer.toHexString(rule.getInt(field)));
                        continue block17;
                    }
                    case 8: {
                        sb.append("MonthInYear=0x" + Integer.toHexString(rule.getInt(field)));
                        continue block17;
                    }
                    default: {
                        sb.append("<Unknown: " + field + "=" + rule.getInt(field));
                    }
                }
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

