/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.pim;

import com.sun.kvem.midp.pim.AbstractPIMItem;
import com.sun.kvem.midp.pim.AbstractPIMList;
import com.sun.kvem.midp.pim.ContactListImpl;
import com.sun.kvem.midp.pim.PIMFormat;
import com.sun.kvem.midp.pim.formats.VCard30Format;
import javax.microedition.pim.Contact;
import javax.microedition.pim.PIMItem;

public class ContactImpl
extends AbstractPIMItem
implements Contact {
    public ContactImpl(ContactListImpl list) {
        super((AbstractPIMList)list, 1);
    }

    ContactImpl(ContactListImpl list, Contact base) {
        super((AbstractPIMList)list, (PIMItem)base);
    }

    public int getPreferredIndex(int field) {
        int indices = this.countValues(field);
        for (int i = 0; i < indices; ++i) {
            int attributes = this.getAttributes(field, i);
            if ((attributes & 0x80) == 0) continue;
            return i;
        }
        return -1;
    }

    PIMFormat getEncodingFormat() {
        return new VCard30Format();
    }

    static boolean isValidPIMField(int field) {
        switch (field) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                return true;
            }
        }
        return false;
    }

    public void addBinary(int field, int attributes, byte[] value, int offset, int length) {
        super.addBinary(field, attributes, value, offset, length);
        if (field == 112) {
            while (this.countValues(113) > 0) {
                this.removeValue(113, 0);
            }
        }
    }

    public void addString(int field, int attributes, String value) {
        super.addString(field, attributes, value);
        if (field == 113) {
            while (this.countValues(112) > 0) {
                this.removeValue(112, 0);
            }
        }
    }

    public void addInt(int field, int attributes, int value) {
        if (field == 102) {
            this.validateClass(value);
        }
        super.addInt(field, attributes, value);
    }

    public void setInt(int field, int index, int attributes, int value) {
        if (field == 102) {
            this.validateClass(value);
        }
        super.setInt(field, index, attributes, value);
    }

    private void validateClass(int value) {
        switch (value) {
            case 200: 
            case 201: 
            case 202: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid CLASS value: " + value);
    }

    protected int getRevisionField() {
        return 114;
    }

    protected int getUIDField() {
        return 117;
    }

    protected String toDisplayableString() {
        return "Contact[" + this.formatData() + "]";
    }
}

