/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.location;

import com.sun.kvem.location.LocationEventHandler;
import com.sun.kvem.location.LocationProviderImpl;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.location.Coordinates;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.ProximityListener;
import javax.microedition.location.QualifiedCoordinates;

public class ProximityNotifier
implements Runnable {
    private static ProximityNotifier Instance;
    private Vector proximityListeners = new Vector();

    public static ProximityNotifier getInstance() {
        if (Instance == null) {
            Instance = new ProximityNotifier();
            LocationEventHandler.getInstance();
        }
        return Instance;
    }

    private ProximityNotifier() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProximityListener(ProximityListener listener, Coordinates coordinates, float proximityRadius) throws LocationException {
        this.proximityListeners.addElement(new ProximityListenerDecorator(listener, coordinates, proximityRadius));
        ProximityNotifier proximityNotifier = this;
        synchronized (proximityNotifier) {
            ProximityNotifier.getInstance().notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProximityEvent(Location location) {
        Object[] listeners = null;
        Vector vector = this.proximityListeners;
        synchronized (vector) {
            listeners = new ProximityListenerDecorator[this.proximityListeners.size()];
            this.proximityListeners.copyInto(listeners);
        }
        for (int iter = 0; iter < listeners.length; ++iter) {
            boolean notified = ((ProximityListenerDecorator)listeners[iter]).proximityEvent(location);
            if (!notified) continue;
            this.removeProximityListener(((ProximityListenerDecorator)listeners[iter]).listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMonitoringStateChanged(boolean isMonitoringActive) {
        Object[] listeners = null;
        Vector vector = this.proximityListeners;
        synchronized (vector) {
            listeners = new ProximityListener[this.proximityListeners.size()];
            this.proximityListeners.copyInto(listeners);
        }
        for (int iter = 0; iter < listeners.length; ++iter) {
            listeners[iter].monitoringStateChanged(isMonitoringActive);
        }
    }

    public void removeProximityListener(ProximityListener listener) {
        Enumeration e = this.proximityListeners.elements();
        while (e.hasMoreElements()) {
            ProximityListenerDecorator decorator = (ProximityListenerDecorator)e.nextElement();
            if (decorator.listener != listener) continue;
            this.proximityListeners.removeElement(decorator);
            e = this.proximityListeners.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Location currentLocation = null;
        while (true) {
            try {
                ProximityNotifier proximityNotifier;
                if (this.proximityListeners.size() > 0) {
                    currentLocation = LocationProviderImpl.getLastKnownLocationImpl();
                    if (currentLocation != null) {
                        this.fireProximityEvent(currentLocation);
                    }
                    proximityNotifier = this;
                    synchronized (proximityNotifier) {
                        this.wait(1000L);
                        continue;
                    }
                }
                proximityNotifier = this;
                synchronized (proximityNotifier) {
                    this.wait();
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    static class ProximityListenerDecorator
    implements ProximityListener {
        private ProximityListener listener;
        private Coordinates coordinates;
        private float proximityRadius;

        ProximityListenerDecorator(ProximityListener listener, Coordinates coordinates, float proximityRadius) {
            this.listener = listener;
            this.coordinates = coordinates;
            this.proximityRadius = proximityRadius;
        }

        public boolean proximityEvent(Location location) {
            boolean notified = false;
            if (!location.isValid()) {
                return notified;
            }
            QualifiedCoordinates qCoord = location.getQualifiedCoordinates();
            float distance = this.coordinates.distance((Coordinates)qCoord);
            float hAccuracy = qCoord.getHorizontalAccuracy();
            if (Float.isNaN(hAccuracy)) {
                hAccuracy = 0.0f;
            }
            if (distance - hAccuracy <= this.proximityRadius) {
                this.listener.proximityEvent(this.coordinates, location);
                notified = true;
            }
            return notified;
        }

        public void proximityEvent(Coordinates coordinates, Location location) {
            this.listener.proximityEvent(coordinates, location);
        }

        public void monitoringStateChanged(boolean isMonitoringActive) {
            this.listener.monitoringStateChanged(isMonitoringActive);
        }
    }
}

