/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ObexAuth;
import com.sun.kvem.jsr082.obex.ObexTransport;
import com.sun.kvem.jsr082.obex.QueuedHeader;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.obex.Authenticator;

public abstract class ObexPacketStream
implements Connection {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG2 = false;
    static final int OPCODE_CONNECT = 128;
    static final int OPCODE_DISCONNECT = 129;
    static final int OPCODE_PUT = 2;
    static final int OPCODE_GET = 3;
    static final int OPCODE_SETPATH = 133;
    static final int OPCODE_CONTINUE = 144;
    static final int OPCODE_ABORT = 255;
    static final int OPCODE_FINAL = 128;
    static final int OPCODE_GET_FINAL = 131;
    static final byte[] PACKET_ABORT = new byte[]{-1, 0, 0};
    static final byte[] PACKET_CONTINUE = new byte[]{-112, 0, 0};
    static final byte[] PACKET_DISCONNECT = new byte[]{-127, 0, 0};
    static final byte[] PACKET_SUCCESS = new byte[]{-96, 0, 0};
    static final byte[] PACKET_BAD_REQUEST = new byte[]{-64, 0, 0};
    static final byte[] PACKET_NOT_IMPLEMENTED = new byte[]{-47, 0, 0};
    private static final int HEADER_BODY = 72;
    private static final int HEADER_EOFBODY = 73;
    private static final int HEADER_CONNECTION_ID = 203;
    static final int HEADER_AUTH_CHALLENGE = 77;
    static final int HEADER_AUTH_RESPONSE = 78;
    static TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private static final byte[] nullChar = new byte[]{0, 0};
    private ObexTransport transport;
    Authenticator authenticator;
    Vector authResponses = new Vector();
    Vector authChallenges = new Vector();
    boolean moreHeaders = false;
    boolean challengesToSend = false;
    boolean headerOverflow = false;
    boolean containsTargetHeader = false;
    Vector queuedHeaders;
    QueuedHeader newHeader;
    Stack emptyHeadersPool;
    boolean authFailed = false;
    boolean isClient;
    boolean isConnected;
    int OBEX_MAXIMUM_PACKET_LENGTH;
    byte[] buffer;
    int packetLength;
    int packetOffset;
    int packetType;
    int maxSendLength;
    boolean dataOpened;
    boolean dataClosed;
    boolean isEof;
    int dataOffset;

    ObexPacketStream(ObexTransport transport) {
        this.transport = transport;
        this.OBEX_MAXIMUM_PACKET_LENGTH = transport.getMaximumPacketSize();
        this.buffer = new byte[this.OBEX_MAXIMUM_PACKET_LENGTH];
        this.maxSendLength = this.OBEX_MAXIMUM_PACKET_LENGTH;
        this.newHeader = new QueuedHeader(this);
        this.queuedHeaders = new Vector();
        this.emptyHeadersPool = new Stack();
    }

    public void close() {
        try {
            if (this.transport != null) {
                this.transport.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.transport = null;
    }

    public void setAuthenticator(Authenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("null authenticator");
        }
        this.authenticator = authenticator;
    }

    public Connection getTransport() {
        return this.transport.getUnderlyingConnection();
    }

    void brokenLink() {
        this.close();
    }

    boolean isClosed() {
        return this.transport == null;
    }

    void packetBegin(byte[] head) {
        this.containsTargetHeader = false;
        this.moreHeaders = true;
        this.challengesToSend = false;
        System.arraycopy(head, 0, this.buffer, 0, head.length);
        this.packetLength = head.length;
        this.authChallenges.removeAllElements();
        this.dataOpened = false;
        this.dataClosed = false;
        this.dataOffset = -3;
    }

    int packetAddData(byte[] data, int offset, int length) {
        if (this.dataClosed) {
            return 0;
        }
        if (!this.dataOpened) {
            if (this.packetLength + 6 > this.maxSendLength) {
                return 0;
            }
            this.buffer[this.packetLength] = 72;
            this.dataOffset = this.packetLength;
            this.packetLength += 3;
            this.dataOpened = true;
        }
        int len = this.packetLength + length > this.maxSendLength ? this.maxSendLength - this.packetLength : length;
        System.arraycopy(data, offset, this.buffer, this.packetLength, len);
        this.packetLength += len;
        return len;
    }

    int getPacketLength() {
        return this.packetLength;
    }

    void restorePacketLength(int len) {
        this.packetLength = len;
    }

    boolean packetEOFBody() {
        if (this.dataClosed) {
            return false;
        }
        if (this.dataOpened) {
            this.buffer[this.dataOffset + 0] = 73;
            return true;
        }
        if (this.packetLength + 3 > this.maxSendLength) {
            return false;
        }
        this.buffer[this.packetLength++] = 73;
        this.buffer[this.packetLength++] = 0;
        this.buffer[this.packetLength++] = 3;
        return true;
    }

    void packetMarkFinal() {
        this.buffer[0] = (byte)(this.buffer[0] | 0x80);
    }

    void setPacketType(int type) {
        this.buffer[0] = (byte)type;
    }

    void packetEndStripConnID() throws IOException {
        if ((this.buffer[3] & 0xFF) == 70) {
            this.packetLength -= 5;
            for (int i = 3; i < this.packetLength; ++i) {
                this.buffer[i] = this.buffer[i + 5];
            }
        }
        this.packetEnd();
    }

    void packetEnd() throws IOException {
        this.moreHeaders = false;
        if (this.transport == null) {
            throw new IOException("connection error");
        }
        if (this.dataOpened) {
            int len = this.packetLength - this.dataOffset;
            this.buffer[this.dataOffset + 1] = (byte)(len >> 8);
            this.buffer[this.dataOffset + 2] = (byte)len;
            this.dataOpened = false;
            this.dataClosed = true;
        }
        this.buffer[1] = (byte)(this.packetLength / 256);
        this.buffer[2] = (byte)(this.packetLength % 256);
        try {
            this.transport.write(this.buffer, this.packetLength);
        }
        catch (IOException e) {
            this.brokenLink();
            throw e;
        }
    }

    final void packetAddConnectionID(long id, HeaderSetImpl headers) {
        if (headers != null && headers.getHeader(70) != null) {
            return;
        }
        if (id < 0L || id > 0xFFFFFFFFL) {
            return;
        }
        this.buffer[this.packetLength++] = -53;
        this.encodeInt(id);
    }

    abstract void headerTooLarge() throws IOException;

    final void packetAddHeaders(HeaderSetImpl headers) throws IOException {
        this.headerOverflow = false;
        this.newHeader.sendAllQueued();
        if (headers == null) {
            return;
        }
        int[] idList = headers.getHeaderList();
        if (!headers.challenges.isEmpty()) {
            this.newHeader.sendOrQueue(77, headers.challenges);
        }
        if (idList == null) {
            return;
        }
        for (int i = 0; i < idList.length; ++i) {
            int id = idList[i];
            Object value = headers.getHeader(id);
            this.newHeader.sendOrQueue(id, value);
        }
    }

    void packetAddAuthResponses() throws IOException {
        try {
            for (int i = 0; i < this.authResponses.size(); ++i) {
                ObexAuth response = (ObexAuth)this.authResponses.elementAt(i);
                int len = response.replyAuthChallenge(this.buffer, this.packetLength, this.authenticator);
                this.packetLength += len;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("auth response request too large");
        }
        if (this.packetLength > this.maxSendLength) {
            throw new IOException("auth response request too large");
        }
    }

    final void sendPacket(byte[] head, long connectionId, HeaderSetImpl headers, boolean allHeaders) throws IOException {
        this.packetBegin(head);
        this.packetAddConnectionID(connectionId, headers);
        this.packetAddAuthResponses();
        this.packetAddHeaders(headers);
        if (allHeaders && !this.queuedHeaders.isEmpty()) {
            this.queuedHeaders.removeAllElements();
            throw new IOException("packet too large for peer");
        }
        this.packetEnd();
    }

    private final void encodeInt(long val) {
        this.buffer[this.packetLength++] = (byte)(val >> 24);
        this.buffer[this.packetLength++] = (byte)(val >> 16);
        this.buffer[this.packetLength++] = (byte)(val >> 8);
        this.buffer[this.packetLength++] = (byte)val;
    }

    final void recvPacket() throws IOException {
        this.authResponses.removeAllElements();
        if (this.transport == null) {
            throw new IOException("connection error");
        }
        try {
            this.packetLength = this.transport.read(this.buffer);
            this.packetType = this.buffer[0] & 0xFF;
        }
        catch (IOException e) {
            this.brokenLink();
            throw e;
        }
    }

    private final void parseHeader(HeaderSetImpl headers) throws IOException {
        try {
            int headerId = this.buffer[this.packetOffset++] & 0xFF;
            int inputType = headerId >> 6;
            int outputType = HeaderSetImpl.internalType(headerId);
            if (outputType != 7) {
                inputType = outputType;
            }
            Object result = null;
            switch (inputType) {
                case 5: {
                    result = this.decodeTime8601();
                    break;
                }
                case 4: {
                    long date = this.decodeInt();
                    Calendar cal = Calendar.getInstance(utcTimeZone);
                    cal.setTime(new Date(date * 1000L));
                    result = cal;
                    this.packetOffset += 4;
                    break;
                }
                case 6: {
                    int len = this.decodeLength16(this.packetOffset) - 3;
                    this.packetOffset += 2;
                    if (this.buffer[this.packetOffset + len - 1] != 0) {
                        throw new IOException("protocol error, type field not null terminated");
                    }
                    result = new String(this.buffer, this.packetOffset, len - 1, "ISO-8859-1");
                    this.packetOffset += len;
                    break;
                }
                case 3: {
                    result = new Long(this.decodeInt());
                    this.packetOffset += 4;
                    break;
                }
                case 0: {
                    int len = this.decodeLength16(this.packetOffset) - 3;
                    this.packetOffset += 2;
                    if (len < 2 || this.buffer[this.packetOffset + len - 1] != 0 || this.buffer[this.packetOffset + len - 2] != 0) {
                        throw new IOException("protocol error, unicode string is not null terminated");
                    }
                    result = new String(this.buffer, this.packetOffset, len - 2, "UTF-16BE");
                    this.packetOffset += len;
                    break;
                }
                case 1: {
                    int len = this.decodeLength16(this.packetOffset) - 3;
                    this.packetOffset += 2;
                    result = new byte[len];
                    System.arraycopy(this.buffer, this.packetOffset, result, 0, len);
                    this.packetOffset += len;
                    break;
                }
                case 2: {
                    result = new Byte(this.buffer[this.packetOffset++]);
                    break;
                }
                case 8: {
                    int len = this.decodeLength16(this.packetOffset);
                    ObexAuth response = ObexAuth.parseAuthChallenge(this.buffer, this.packetOffset - 1, len);
                    if (response != null) {
                        this.authResponses.addElement(response);
                    }
                    this.packetOffset += len - 1;
                    return;
                }
                case 9: {
                    int len = this.decodeLength16(this.packetOffset);
                    boolean good = ObexAuth.checkAuthResponse(this.buffer, this.packetOffset - 1, len, this, this.authChallenges);
                    if (good) {
                        this.authFailed = false;
                    }
                    this.packetOffset += len - 1;
                    return;
                }
            }
            if (this.packetOffset > this.packetLength) {
                throw new IOException("protocol error");
            }
            if (outputType != 7) {
                headers.setHeader(headerId, result);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("protocol error");
        }
    }

    abstract void onAuthenticationFailure(byte[] var1) throws IOException;

    void onMissingAuthResponse() throws IOException {
    }

    boolean shouldSendAuthResponse() {
        return this.packetType == 193 && this.authResponses.size() != 0;
    }

    final void parsePacketHeaders(HeaderSetImpl headers, int offset) throws IOException {
        this.packetOffset = offset;
        headers.packetType = this.buffer[0] & 0xFF;
        this.parseConnectionID();
        while (this.packetOffset != this.packetLength) {
            this.parseHeader(headers);
        }
        this.parseEnd();
    }

    private final void parseConnectionID() {
        int headerId = this.buffer[this.packetOffset] & 0xFF;
        if (this.packetOffset + 5 > this.packetLength || headerId != 203) {
            return;
        }
        ++this.packetOffset;
        long id = this.decodeInt();
        this.packetOffset += 4;
        this.setConnectionID(id);
    }

    public abstract void setConnectionID(long var1);

    public abstract long getConnectionID();

    final void parsePacketDataBegin(HeaderSetImpl headers, int offset) {
        this.packetOffset = offset;
        headers.packetType = this.buffer[0] & 0xFF;
        this.parseConnectionID();
        this.dataOffset = this.packetOffset;
    }

    final int parsePacketData(HeaderSetImpl headers, byte[] output, int outputOffset, int outputLength) throws IOException {
        int result = 0;
        while (true) {
            int len;
            if ((len = this.packetOffset - this.dataOffset) > 0) {
                if (output == null) {
                    return 1;
                }
                if (len > outputLength) {
                    len = outputLength;
                }
                System.arraycopy(this.buffer, this.dataOffset, output, outputOffset, len);
                outputOffset += len;
                this.dataOffset += len;
                result += len;
                if ((outputLength -= len) != 0) continue;
                return result;
            }
            if (this.packetOffset == this.packetLength) {
                return result;
            }
            int headerId = this.buffer[this.packetOffset] & 0xFF;
            if (headerId == 72 || headerId == 73) {
                this.isEof = headerId == 73;
                this.dataOffset = this.packetOffset + 3;
                int length = this.decodeLength16(this.packetOffset + 1);
                if (this.packetOffset + length > this.packetLength) {
                    throw new IOException("protocol error");
                }
                this.packetOffset += length;
                continue;
            }
            this.parseHeader(headers);
            this.dataOffset = this.packetOffset;
        }
    }

    final void parseEnd() throws IOException {
        if (this.authFailed) {
            this.authFailed = false;
            this.onMissingAuthResponse();
        }
    }

    final int decodeLength16(int off) {
        return ((this.buffer[off] & 0xFF) << 8) + (this.buffer[off + 1] & 0xFF);
    }

    private final long decodeInt() {
        return (((long)this.buffer[this.packetOffset + 0] & 0xFFL) << 24) + (((long)this.buffer[this.packetOffset + 1] & 0xFFL) << 16) + (((long)this.buffer[this.packetOffset + 2] & 0xFFL) << 8) + ((long)this.buffer[this.packetOffset + 3] & 0xFFL);
    }

    private final Calendar decodeTime8601() throws IOException {
        int len = this.decodeLength16(this.packetOffset) - 3;
        this.packetOffset += 2;
        if (len < 15 || len > 16 || this.buffer[this.packetOffset + 8] != 84 || len == 16 && this.buffer[this.packetOffset + 15] != 90) {
            throw new IOException("corrupted time header");
        }
        for (int i = 0; i < 14; ++i) {
            int chr;
            if (i == 8 || (chr = this.buffer[this.packetOffset + i] - 48) >= 0 && chr <= 9) continue;
            throw new IOException("corrupted time header");
        }
        int year = (this.buffer[this.packetOffset + 0] - 48) * 1000 + (this.buffer[this.packetOffset + 1] - 48) * 100 + (this.buffer[this.packetOffset + 2] - 48) * 10 + (this.buffer[this.packetOffset + 3] - 48);
        int month = (this.buffer[this.packetOffset + 4] - 48) * 10 + (this.buffer[this.packetOffset + 5] - 48);
        int date = (this.buffer[this.packetOffset + 6] - 48) * 10 + (this.buffer[this.packetOffset + 7] - 48);
        int hour = (this.buffer[this.packetOffset + 9] - 48) * 10 + (this.buffer[this.packetOffset + 10] - 48);
        int minute = (this.buffer[this.packetOffset + 11] - 48) * 10 + (this.buffer[this.packetOffset + 12] - 48);
        int second = (this.buffer[this.packetOffset + 13] - 48) * 10 + (this.buffer[this.packetOffset + 14] - 48);
        Calendar cal = len == 15 ? Calendar.getInstance(utcTimeZone) : Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, date);
        cal.set(10, hour);
        cal.set(12, minute);
        cal.set(13, second);
        this.packetOffset += len;
        return cal;
    }

    static int validateStatus(int status) {
        switch (status) {
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 224: 
            case 225: {
                return status;
            }
        }
        return 208;
    }
}

