/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.obex;

import com.sun.kvem.jsr082.obex.ClientOperation;
import com.sun.kvem.jsr082.obex.HeaderSetImpl;
import com.sun.kvem.jsr082.obex.ObexPacketStream;
import com.sun.kvem.jsr082.obex.ObexTransport;
import java.io.IOException;
import javax.obex.ClientSession;
import javax.obex.HeaderSet;
import javax.obex.Operation;

public class ClientSessionImpl
extends ObexPacketStream
implements ClientSession {
    private boolean busy;
    private Object lockObject = new Object();
    private int owner = 2;
    Operation operation = null;
    private long connId = -1L;

    public ClientSessionImpl(ObexTransport transport) throws IOException {
        super(transport);
        this.isClient = true;
    }

    public HeaderSet createHeaderSet() {
        return new HeaderSetImpl(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockCheckHeaders(HeaderSet headers) throws IOException {
        if (this.isClosed()) {
            throw new IOException("session closed");
        }
        if (this.operation != null) {
            throw new IOException("already in operation");
        }
        if (!(headers == null || headers instanceof HeaderSetImpl && ((HeaderSetImpl)headers).owner != this.owner)) {
            throw new IllegalArgumentException("wrong headerset class");
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.busy) {
                throw new IOException("already in operation");
            }
            this.busy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        Object object = this.lockObject;
        synchronized (object) {
            this.busy = false;
        }
    }

    void onAuthenticationFailure(byte[] username) throws IOException {
        if (this.operation != null) {
            this.operation.abort();
        }
        throw new IOException("server is not authenticated");
    }

    void onMissingAuthResponse() throws IOException {
        if (this.packetType != 193) {
            if (this.operation != null) {
                this.operation.abort();
            }
            throw new IOException("no auth response from server");
        }
    }

    public void setConnectionID(long id) {
        if (id < 0L || id > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("invalid id");
        }
        this.connId = id;
    }

    public long getConnectionID() {
        return this.connId;
    }

    void headerTooLarge() throws IOException {
        throw new IOException("header too large");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet connect(HeaderSet headers) throws IOException {
        this.lockCheckHeaders(headers);
        try {
            if (this.isConnected) {
                throw new IOException("already connected");
            }
            byte[] head = new byte[]{-128, 0, 0, 16, 0, (byte)(this.OBEX_MAXIMUM_PACKET_LENGTH / 256), (byte)(this.OBEX_MAXIMUM_PACKET_LENGTH % 256)};
            this.sendPacket(head, -1L, (HeaderSetImpl)headers, true);
            this.recvPacket();
            if (this.packetLength < 7 || this.buffer[3] != 16) {
                throw new IOException("unsupported server obex version");
            }
            HeaderSetImpl recvHeaders = new HeaderSetImpl(this.owner);
            this.parsePacketHeaders(recvHeaders, 7);
            if (this.shouldSendAuthResponse()) {
                this.authFailed = false;
                this.sendPacket(head, -1L, (HeaderSetImpl)headers, true);
                this.recvPacket();
                if (this.packetLength < 7 || this.buffer[3] != 16) {
                    throw new IOException("unsupported server obex version");
                }
                recvHeaders = new HeaderSetImpl(this.owner);
                this.parsePacketHeaders(recvHeaders, 7);
            }
            this.maxSendLength = this.decodeLength16(5);
            if (this.maxSendLength > this.OBEX_MAXIMUM_PACKET_LENGTH) {
                this.maxSendLength = this.OBEX_MAXIMUM_PACKET_LENGTH;
            }
            if (this.packetType == 160) {
                if (this.authFailed) {
                    throw new IOException("server is not authenticated");
                }
                this.isConnected = true;
            }
            HeaderSetImpl headerSetImpl = recvHeaders;
            return headerSetImpl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet disconnect(HeaderSet headers) throws IOException {
        this.lockCheckHeaders(headers);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            this.sendPacket(PACKET_DISCONNECT, this.connId, (HeaderSetImpl)headers, true);
            this.recvPacket();
            HeaderSetImpl recvHeaders = new HeaderSetImpl(this.owner);
            this.parsePacketHeaders(recvHeaders, 3);
            if (this.packetType == 160) {
                this.isConnected = false;
            }
            HeaderSetImpl headerSetImpl = recvHeaders;
            return headerSetImpl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation put(HeaderSet headers) throws IOException {
        this.lockCheckHeaders(headers);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            new ClientOperation(this, (HeaderSetImpl)headers, false);
            Operation operation = this.operation;
            return operation;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Operation get(HeaderSet headers) throws IOException {
        this.lockCheckHeaders(headers);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            new ClientOperation(this, (HeaderSetImpl)headers, true);
            Operation operation = this.operation;
            return operation;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet setPath(HeaderSet headers, boolean backup, boolean create) throws IOException {
        this.lockCheckHeaders(headers);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            byte[] head = new byte[]{-123, 0, 0, (byte)((backup ? 1 : 0) + (create ? 0 : 2)), 0};
            this.sendPacket(head, this.connId, (HeaderSetImpl)headers, true);
            this.recvPacket();
            HeaderSetImpl recvHeaders = new HeaderSetImpl(this.owner);
            this.parsePacketHeaders(recvHeaders, 3);
            HeaderSetImpl headerSetImpl = recvHeaders;
            return headerSetImpl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderSet delete(HeaderSet headers) throws IOException {
        this.lockCheckHeaders(headers);
        try {
            if (!this.isConnected) {
                throw new IOException("not connected");
            }
            ClientOperation op = new ClientOperation(this, (HeaderSetImpl)headers, false);
            int code = op.getResponseCode();
            HeaderSet recvHeaders = op.getReceivedHeaders();
            op.close();
            HeaderSet headerSet = recvHeaders;
            return headerSet;
        }
        finally {
            this.unlock();
        }
    }
}

