/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.jsr082.impl.bluetooth;

import com.sun.kvem.jsr082.bluetooth.DiscoveryAgentImpl;
import com.sun.kvem.jsr082.bluetooth.RemoteDeviceImpl;
import com.sun.kvem.jsr082.impl.bluetooth.BluetoothController;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityState;
import com.sun.kvem.jsr082.impl.bluetooth.SecurityTokenHandler;
import com.sun.kvem.jsr082.impl.io.JSR082Connection;
import com.sun.kvem.jsr082.impl.io.JSR082Notifier;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.bluetooth.BluetoothStateException;

class SecurityListener
implements Runnable {
    private static final boolean DEBUG = false;
    private static boolean running = true;
    private static JSR082Notifier notif;
    private static JSR082Connection conn;
    private static BluetoothController control;
    static final int ENCRYPT = 1;
    static final int AUTHENTICATE = 2;
    static final int FORCE_MASTER = 3;
    static final int ERROR = 4;

    private SecurityListener() {
    }

    static void start(BluetoothController control) throws IOException {
        try {
            notif = new JSR082Notifier(SecurityTokenHandler.getSecurityToken());
            SecurityListener.control = control;
            control.registerSecurityListener(notif.getServerPort());
        }
        catch (IOException e) {
            System.err.println("SecurityListener not created");
            try {
                if (notif != null) {
                    notif.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        new Thread(new SecurityListener()).start();
    }

    private static void stop() {
        running = false;
        try {
            notif.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            conn.close();
        }
        catch (NullPointerException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        while (running) {
            try {
                conn = notif.acceptAndOpen();
                this.processRequest();
            }
            catch (IOException e) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void processRequest() throws IOException {
        String remoteAddress = SecurityListener.readBTAddress(conn);
        DiscoveryAgentImpl agent = control.getDiscoveryAgent();
        RemoteDeviceImpl remoteDevice = agent.getRemoteDevice(remoteAddress);
        byte[] cmd = new byte[2];
        boolean res = false;
        if (conn.read(cmd) != 2) {
            throw new IOException("internal error");
        }
        boolean param = cmd[1] != 0;
        byte[] reply = new byte[1];
        try {
            switch (cmd[0]) {
                case 1: {
                    res = this.processCmdEncrypt(remoteDevice, param);
                    break;
                }
                case 2: {
                    res = this.processCmdAuthenticate(remoteDevice);
                    break;
                }
                case 3: {
                    res = this.processCmdForceMaster(remoteDevice);
                    break;
                }
                default: {
                    System.err.println("SecurityListener.processRequest(): unknown request " + cmd[0]);
                }
            }
            reply[0] = (byte)(res ? 1 : 0);
        }
        catch (BluetoothStateException e) {
            reply[0] = 4;
        }
        conn.write(reply);
    }

    static JSR082Connection createSecurityConnection(RemoteDeviceImpl remoteDevice) throws IOException {
        int port = control.getSecurityListenerPort(remoteDevice.getBluetoothAddress());
        JSR082Connection conn = new JSR082Connection(SecurityTokenHandler.getSecurityToken(), port);
        SecurityListener.writeBTAddress(conn, control.getBluetoothAddress());
        return conn;
    }

    static boolean sendCommand(RemoteDeviceImpl remoteDevice, int cmd, boolean param) throws IOException {
        byte[] command;
        JSR082Connection conn = SecurityListener.createSecurityConnection(remoteDevice);
        if (cmd == 2) {
            byte[] data = control.getDevicePinCode();
            if (data == null) {
                data = new byte[]{};
            }
            command = new byte[6 + data.length];
            command[0] = (byte)cmd;
            command[1] = (byte)(param ? 1 : 0);
            command[2] = (byte)(data.length >>> 24);
            command[3] = (byte)(data.length >>> 16 & 0xFF);
            command[4] = (byte)(data.length >>> 8 & 0xFF);
            command[5] = (byte)(data.length & 0xFF);
            System.arraycopy(data, 0, command, 6, data.length);
        } else {
            command = new byte[]{(byte)cmd, (byte)(param ? 1 : 0)};
        }
        conn.write(command);
        byte[] reply = new byte[1];
        conn.read(reply);
        if (reply[0] == 4) {
            throw new BluetoothStateException("request ignored");
        }
        return reply[0] != 0;
    }

    static String readBTAddress(JSR082Connection transport) throws IOException {
        byte[] addr = new byte[12];
        transport.read(addr);
        try {
            return new String(addr, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("security parameters error 1");
        }
    }

    static void writeBTAddress(JSR082Connection transport, String address) throws IOException {
        if (address.length() != 12) {
            throw new IOException("security parameters error 2");
        }
        try {
            transport.write(address.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("security parameters error 3");
        }
    }

    private boolean processCmdEncrypt(RemoteDeviceImpl remoteDevice, boolean on) throws BluetoothStateException {
        SecurityState state = SecurityState.getSecurityState(remoteDevice);
        return state.remoteRequestForEncrypt(on);
    }

    private boolean processCmdAuthenticate(RemoteDeviceImpl remoteDevice) throws IOException {
        byte[] lenData = new byte[4];
        conn.read(lenData);
        int len = (lenData[0] & 0xFF) << 24;
        len |= (lenData[1] & 0xFF) << 16;
        len |= (lenData[2] & 0xFF) << 8;
        byte[] remotePinCode = new byte[len |= lenData[3] & 0xFF];
        conn.read(remotePinCode);
        SecurityState state = SecurityState.getSecurityState(remoteDevice);
        return state.remoteRequestForAuthenticate(remotePinCode);
    }

    private boolean processCmdForceMaster(RemoteDeviceImpl remoteDevice) throws IOException {
        SecurityState state = SecurityState.getSecurityState(remoteDevice);
        return state.remoteRequestForMaster();
    }
}

